/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.charset.ICharsetAccess;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.locking.ILock;
import de.intarsys.tools.locking.ILockLevel;
import de.intarsys.tools.locking.ILockSupport;
import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.stream.TempFileOutputStream;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;

public class FileLocator
extends CommonLocator
implements ILockSupport,
ICharsetAccess {
    private File file;
    private String charset;
    private boolean outOfSynch;
    private boolean synchSynchronous = false;
    private long lastModified = 0L;
    private boolean useTempFile = false;
    private File canonicalFile;
    private final boolean append;

    public FileLocator(File file) {
        this.file = file;
        this.append = false;
    }

    public FileLocator(File file, boolean bl) {
        this.file = file;
        this.append = bl;
    }

    public FileLocator(String string) {
        this(new File(string));
    }

    @Override
    public void delete() throws IOException {
        if (this.getFile() == null) {
            return;
        }
        this.getFile().delete();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileLocator)) {
            return false;
        }
        return this.getCanonicalFile().equals(((FileLocator)object).getCanonicalFile());
    }

    @Override
    public boolean exists() {
        return this.getFile().exists();
    }

    public File getCanonicalFile() {
        if (this.canonicalFile == null) {
            try {
                this.canonicalFile = this.getFile().getCanonicalFile();
            }
            catch (IOException iOException) {
                this.canonicalFile = this.getFile();
            }
        }
        return this.canonicalFile;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public ILocator getChild(String string) {
        File file = new File(this.getFile(), string);
        FileLocator fileLocator = new FileLocator(file);
        fileLocator.setSynchSynchronous(this.isSynchSynchronous());
        return fileLocator;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getFullName() {
        if (this.getFile() == null) {
            return "unknown";
        }
        return this.getFile().getAbsolutePath();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.getLastModified();
        return new FileInputStream(this.getFile());
    }

    protected long getLastModified() {
        if (this.lastModified == 0L && this.file.exists()) {
            this.lastModified = this.file.lastModified();
        }
        return this.lastModified;
    }

    @Override
    public long getLength() throws IOException {
        return this.file.length();
    }

    @Override
    public String getLocalName() {
        if (this.getFile() == null) {
            return "unknown";
        }
        return FileTools.getBaseName(this.getFile());
    }

    @Override
    public ILock getLock() {
        return new FileLocatorLock();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.getLastModified();
        if (!this.getFile().getParentFile().exists()) {
            this.getFile().getParentFile().mkdirs();
        }
        if (this.isUseTempFile()) {
            return new TempFileOutputStream(this.getFile(), "tmp_", "." + this.getType());
        }
        return new FileOutputStream(this.getFile(), this.isAppend());
    }

    @Override
    public ILocator getParent() {
        File file = FileTools.getParentFile(this.getFile());
        if (file == null) {
            return null;
        }
        FileLocator fileLocator = new FileLocator(file);
        fileLocator.setSynchSynchronous(this.isSynchSynchronous());
        return fileLocator;
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        this.getLastModified();
        if (this.isUseTempFile()) {
            throw new UnsupportedOperationException("no random access to temp file");
        }
        return new de.intarsys.tools.randomaccess.RandomAccessFile(this.getFile());
    }

    @Override
    public Reader getReader() throws IOException {
        this.getLastModified();
        if (StringTools.isEmpty(this.getCharset())) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.getCharset());
    }

    @Override
    public Reader getReader(String string) throws IOException {
        this.getLastModified();
        if (StringTools.isEmpty(string)) {
            return this.getReader();
        }
        return new InputStreamReader(this.getInputStream(), string);
    }

    @Override
    public String getType() {
        if (this.getFile() == null) {
            return "<unknown>";
        }
        return FileTools.getExtension(this.getFile());
    }

    @Override
    public String getTypedName() {
        if (this.getFile() == null) {
            return "unknown";
        }
        return this.getFile().getName();
    }

    @Override
    public Writer getWriter() throws IOException {
        this.getLastModified();
        if (StringTools.isEmpty(this.getCharset())) {
            return new OutputStreamWriter(this.getOutputStream());
        }
        return new OutputStreamWriter(this.getOutputStream(), this.getCharset());
    }

    @Override
    public Writer getWriter(String string) throws IOException {
        this.getLastModified();
        if (StringTools.isEmpty(string)) {
            return this.getWriter();
        }
        return new OutputStreamWriter(this.getOutputStream(), string);
    }

    public int hashCode() {
        try {
            return this.getFile().getCanonicalFile().hashCode();
        }
        catch (IOException iOException) {
            return 17;
        }
    }

    public boolean isAppend() {
        return this.append;
    }

    @Override
    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    @Override
    public synchronized boolean isOutOfSynch() {
        if (this.isSynchSynchronous()) {
            this.synch();
        }
        return this.outOfSynch;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isReadOnly() {
        IRandomAccess iRandomAccess;
        block7: {
            block8: {
                if (super.isReadOnly()) {
                    return true;
                }
                iRandomAccess = null;
                try {
                    if (!this.getFile().exists()) {
                        if (!this.getFile().createNewFile()) break block7;
                        this.getFile().delete();
                        break block8;
                    }
                    iRandomAccess = this.getRandomAccess();
                    if (iRandomAccess == null || iRandomAccess.isReadOnly()) break block7;
                }
                catch (IOException iOException) {
                    StreamTools.close(iRandomAccess);
                    return true;
                }
                catch (Throwable throwable) {
                    StreamTools.close(iRandomAccess);
                    throw throwable;
                }
            }
            StreamTools.close(iRandomAccess);
            return false;
        }
        StreamTools.close(iRandomAccess);
        return true;
    }

    public boolean isSynchSynchronous() {
        return this.synchSynchronous;
    }

    public boolean isUseTempFile() {
        return this.useTempFile;
    }

    @Override
    public ILocator[] listLocators(final ILocatorNameFilter iLocatorNameFilter) throws IOException {
        if (!this.getFile().exists()) {
            throw new FileNotFoundException(String.valueOf(this.getFile().getName()) + " not found");
        }
        if (!this.getFile().isDirectory()) {
            throw new IOException(String.valueOf(this.getFile().getName()) + " not a directory");
        }
        File[] fileArray = iLocatorNameFilter == null ? this.getFile().listFiles() : this.getFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return iLocatorNameFilter.accept(FileLocator.this, string);
            }
        });
        if (fileArray == null) {
            throw new IOException("error listing resources");
        }
        ILocator[] iLocatorArray = new ILocator[fileArray.length];
        int n = 0;
        while (n < iLocatorArray.length) {
            FileLocator fileLocator = new FileLocator(fileArray[n].getPath());
            fileLocator.setSynchSynchronous(this.isSynchSynchronous());
            fileLocator.setCharset(this.getCharset());
            iLocatorArray[n] = fileLocator;
            ++n;
        }
        return iLocatorArray;
    }

    @Override
    public void rename(String string) throws IOException {
        if (this.getFile() == null) {
            return;
        }
        File file = new File(string);
        if (!file.isAbsolute()) {
            File file2 = this.getFile().getParentFile();
            if (file2 == null) {
                file2 = this.getFile().getAbsoluteFile().getParentFile();
            }
            file = file2 == null ? new File(string) : new File(file2, string);
        }
        FileTools.renameFile(this.getFile(), file);
        this.file = file;
        this.canonicalFile = null;
        this.lastModified = 0L;
    }

    @Override
    public void setCharset(String string) {
        this.charset = string;
    }

    public void setSynchSynchronous(boolean bl) {
        this.synchSynchronous = bl;
    }

    public void setUseTempFile(boolean bl) {
        this.useTempFile = bl;
    }

    @Override
    public synchronized void synch() {
        if (this.getFile() == null) {
            return;
        }
        if (this.getLastModified() != this.getFile().lastModified()) {
            LogTools.getLogger(this.getClass()).log(Level.FINEST, "'" + this.getFullName() + "' out of synch!");
            this.outOfSynch = true;
        }
    }

    public String toString() {
        return this.getFile().toString();
    }

    @Override
    public URL toURL() {
        try {
            if (this.isDirectory()) {
                return new URL("file", null, String.valueOf(this.getFullName()) + "/");
            }
            return new URL("file", null, this.getFullName());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    class FileLocatorLock
    implements ILock {
        private RandomAccessFile ra;

        FileLocatorLock() {
        }

        @Override
        public boolean acquire(Object object, ILockLevel iLockLevel) {
            try {
                this.ra = new RandomAccessFile(FileLocator.this.getFile(), "r");
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        }

        @Override
        public void release(Object object) {
            StreamTools.close(this.ra);
        }
    }
}

