/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.st.STDocument;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.string.CharacterTools;
import java.util.Map;

public class PasswordProvider {
    public static final String ATTR_PASSWORD = "password";
    public static final String ATTR_PASSWORDPROVIDER = "passwordProvider";
    private static final ThreadLocal<IPasswordProvider> threadLocal = new ThreadLocal();
    private static IPasswordProvider Unique;

    public static IPasswordProvider get() {
        if (PasswordProvider.getThreadLocal() == null) {
            return Unique;
        }
        return PasswordProvider.getThreadLocal();
    }

    public static char[] getPassword(STDocument sTDocument) {
        Object object = sTDocument.getAttribute(ATTR_PASSWORD);
        if (object instanceof String) {
            return ((String)object).toCharArray();
        }
        if (object instanceof char[]) {
            return (char[])object;
        }
        if (object instanceof byte[]) {
            return CharacterTools.toCharArray((byte[])((byte[])object));
        }
        return null;
    }

    public static IPasswordProvider getPasswordProvider(STDocument sTDocument) {
        Object object = sTDocument.getAttribute(ATTR_PASSWORDPROVIDER);
        if (object instanceof IPasswordProvider) {
            return (IPasswordProvider)object;
        }
        return null;
    }

    private static IPasswordProvider getThreadLocal() {
        return threadLocal.get();
    }

    public static void set(IPasswordProvider iPasswordProvider) {
        Unique = iPasswordProvider;
    }

    public static void setPassword(Map map, char[] cArray) {
        map.put(ATTR_PASSWORD, cArray);
    }

    public static void setPasswordProvider(Map map, IPasswordProvider iPasswordProvider) {
        map.put(ATTR_PASSWORDPROVIDER, iPasswordProvider);
    }

    public static void setThreadLocal(IPasswordProvider iPasswordProvider) {
        threadLocal.set(iPasswordProvider);
    }

    private PasswordProvider() {
    }
}

