/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSCompositeObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.crypt.COSEncryption;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.ISecurityHandler;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.crypt.SecurityHandlerFactory;
import de.intarsys.pdf.crypt.SystemSecurityHandlerV0;
import de.intarsys.pdf.crypt.SystemSecurityHandlerV1;
import de.intarsys.pdf.crypt.SystemSecurityHandlerV2;
import de.intarsys.pdf.crypt.SystemSecurityHandlerV3;
import de.intarsys.pdf.crypt.SystemSecurityHandlerV4;
import de.intarsys.pdf.st.EnumWriteMode;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STStreamXRefSection;

public abstract class SystemSecurityHandler
implements ISystemSecurityHandler {
    public static final int DEFAULT_LENGTH = 40;
    private final COSDictionary cosEncryption;
    private COSArray currentCosIDs;
    private final COSEncryption encryption;
    private COSDictionary currentCosTrailer;
    private COSDictionary currentCosEncryption;
    private ISecurityHandler securityHandler;
    private STDocument stDoc;
    private COSCompositeObject[] contextStack = new COSCompositeObject[5];
    private short stackPtr = (short)-1;
    private boolean enabled = true;

    public static SystemSecurityHandler createFromSt(STDocument sTDocument) throws COSSecurityException {
        SystemSecurityHandler systemSecurityHandler = null;
        COSDictionary cOSDictionary = sTDocument.cosGetTrailer().get(COSTrailer.DK_Encrypt).asDictionary();
        if (cOSDictionary != null) {
            int n = 0;
            COSNumber cOSNumber = cOSDictionary.get(COSEncryption.DK_V).asNumber();
            if (cOSNumber != null) {
                n = cOSNumber.intValue();
            }
            if (n == 0) {
                systemSecurityHandler = new SystemSecurityHandlerV0(cOSDictionary);
            } else if (n == 1) {
                systemSecurityHandler = new SystemSecurityHandlerV1(cOSDictionary);
            } else if (n == 2) {
                systemSecurityHandler = new SystemSecurityHandlerV2(cOSDictionary);
            } else if (n == 3) {
                systemSecurityHandler = new SystemSecurityHandlerV3(cOSDictionary);
            } else if (n == 4) {
                systemSecurityHandler = new SystemSecurityHandlerV4(cOSDictionary);
            } else {
                throw new COSSecurityException("unsupported security version " + n);
            }
            systemSecurityHandler.initialize(sTDocument);
        }
        return systemSecurityHandler;
    }

    public static SystemSecurityHandler createNewV1() {
        COSDictionary cOSDictionary = COSDictionary.create();
        cOSDictionary.beIndirect();
        SystemSecurityHandlerV1 systemSecurityHandlerV1 = new SystemSecurityHandlerV1(cOSDictionary);
        systemSecurityHandlerV1.initializeFromScratch();
        return systemSecurityHandlerV1;
    }

    public static SystemSecurityHandler createNewV2() {
        COSDictionary cOSDictionary = COSDictionary.create();
        cOSDictionary.beIndirect();
        SystemSecurityHandlerV2 systemSecurityHandlerV2 = new SystemSecurityHandlerV2(cOSDictionary);
        ((SystemSecurityHandler)systemSecurityHandlerV2).initializeFromScratch();
        return systemSecurityHandlerV2;
    }

    public static SystemSecurityHandler createNewV4() {
        COSDictionary cOSDictionary = COSDictionary.create();
        cOSDictionary.beIndirect();
        SystemSecurityHandlerV4 systemSecurityHandlerV4 = new SystemSecurityHandlerV4(cOSDictionary);
        ((SystemSecurityHandler)systemSecurityHandlerV4).initializeFromScratch();
        return systemSecurityHandlerV4;
    }

    protected SystemSecurityHandler(COSDictionary cOSDictionary) {
        this.currentCosEncryption = this.cosEncryption = cOSDictionary;
        this.encryption = (COSEncryption)COSEncryption.META.createFromCos(cOSDictionary);
    }

    @Override
    public void attach(STDocument sTDocument) throws COSSecurityException {
        this.stDoc = sTDocument;
        this.currentCosTrailer = sTDocument.cosGetTrailer();
        this.currentCosIDs = this.currentCosTrailer.get(COSTrailer.DK_ID).asArray();
        this.currentCosTrailer.put(COSTrailer.DK_Encrypt, this.cosGetEncryption());
        if (this.getSecurityHandler() != null) {
            this.getSecurityHandler().attach(sTDocument);
        }
        this.forceFullWrite();
    }

    @Override
    public void authenticate() throws COSSecurityException {
        this.securityHandler.authenticate();
    }

    public COSDictionary cosGetEncryption() {
        return this.cosEncryption;
    }

    @Override
    public void detach(STDocument sTDocument) throws COSSecurityException {
        if (this.getSecurityHandler() != null) {
            this.getSecurityHandler().detach(sTDocument);
        }
        sTDocument.cosGetTrailer().remove(COSTrailer.DK_Encrypt);
        this.forceFullWrite();
    }

    protected void forceFullWrite() {
        if (this.stGetDoc() == null) {
            return;
        }
        this.stGetDoc().setWriteModeHint(EnumWriteMode.FULL);
    }

    @Override
    public COSCompositeObject getContextObject() {
        if (this.stackPtr < 0) {
            return null;
        }
        return this.contextStack[this.stackPtr];
    }

    public COSEncryption getEncryption() {
        return this.encryption;
    }

    @Override
    public int getLength() {
        COSEncryption cOSEncryption = this.getEncryption();
        return cOSEncryption.getFieldInt(COSEncryption.DK_Length, 40);
    }

    @Override
    public ISecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public abstract int getVersion();

    @Override
    public void initialize(STDocument sTDocument) throws COSSecurityException {
        this.stDoc = sTDocument;
        this.initializeFromSt();
    }

    protected void initializeFromScratch() {
        COSEncryption cOSEncryption = this.getEncryption();
        cOSEncryption.cosSetField(COSEncryption.DK_V, COSInteger.create(this.getVersion()));
    }

    protected void initializeFromSt() throws COSSecurityException {
        COSEncryption cOSEncryption = this.getEncryption();
        this.securityHandler = SecurityHandlerFactory.get().getSecurityHandler(cOSEncryption);
        this.securityHandler.initialize(this.stGetDoc());
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public COSCompositeObject popContextObject() {
        COSDictionary cOSDictionary;
        short s = this.stackPtr;
        this.stackPtr = (short)(s - 1);
        COSCompositeObject cOSCompositeObject = this.contextStack[s];
        if (cOSCompositeObject == this.currentCosEncryption || cOSCompositeObject == this.currentCosIDs) {
            this.enabled = true;
        }
        if (cOSCompositeObject instanceof COSStream && (cOSDictionary = cOSCompositeObject.asStream().getDict()) != null && cOSDictionary.get(STStreamXRefSection.DK_Type).equals(STStreamXRefSection.CN_Type_XRef)) {
            this.enabled = true;
        }
        return cOSCompositeObject;
    }

    @Override
    public void pushContextObject(COSCompositeObject cOSCompositeObject) {
        Object object;
        this.stackPtr = (short)(this.stackPtr + 1);
        if (this.stackPtr >= this.contextStack.length) {
            object = new COSCompositeObject[this.contextStack.length + 5];
            System.arraycopy(this.contextStack, 0, object, 0, this.contextStack.length);
            this.contextStack = object;
        }
        this.contextStack[this.stackPtr] = cOSCompositeObject;
        if (cOSCompositeObject == this.currentCosEncryption || cOSCompositeObject == this.currentCosIDs) {
            this.enabled = false;
        }
        if (cOSCompositeObject instanceof COSStream && (object = cOSCompositeObject.asStream().getDict()) != null && ((COSDictionary)object).get(STStreamXRefSection.DK_Type).equals(STStreamXRefSection.CN_Type_XRef)) {
            this.enabled = false;
        }
    }

    public void setLength(int n) {
        COSEncryption cOSEncryption = this.getEncryption();
        cOSEncryption.setFieldInt(COSEncryption.DK_Length, n);
    }

    @Override
    public void setSecurityHandler(ISecurityHandler iSecurityHandler) throws COSSecurityException {
        if (this.securityHandler != null) {
            this.securityHandler.detach(this.stGetDoc());
        }
        this.securityHandler = iSecurityHandler;
        if (this.securityHandler != null) {
            this.securityHandler.attach(this.stGetDoc());
        }
    }

    @Override
    public STDocument stGetDoc() {
        return this.stDoc;
    }

    @Override
    public void updateTrailer(COSDictionary cOSDictionary) {
        this.currentCosTrailer = cOSDictionary;
        this.currentCosIDs = this.currentCosTrailer.get(COSTrailer.DK_ID).asArray();
        this.currentCosEncryption = cOSDictionary.get(COSTrailer.DK_Encrypt).asDictionary();
    }
}

