/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.pdf.pd.PDCSICCBased;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtCSCIEBased;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.color.ProfileDataException;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;

public class AwtCSICCBased
extends AwtCSCIEBased {
    public AwtCSICCBased(PDColorSpace pDColorSpace) {
        super(pDColorSpace);
    }

    @Override
    protected ColorSpace createColorSpace() {
        PDColorSpace pDColorSpace;
        ICC_Profile iCC_Profile = this.resolveProfile();
        if (iCC_Profile != null) {
            try {
                ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(iCC_Profile);
                float[] fArray = new float[iCC_ColorSpace.getNumComponents()];
                int n = 0;
                while (n < fArray.length) {
                    fArray[n] = ((ColorSpace)iCC_ColorSpace).getMinValue(n);
                    ++n;
                }
                ((ColorSpace)iCC_ColorSpace).toRGB(fArray);
                return iCC_ColorSpace;
            }
            catch (ProfileDataException profileDataException) {
                // empty catch block
            }
        }
        if ((pDColorSpace = this.myPDColorSpace().getAlternate()) != null) {
            return AwtCSICCBased.getColorSpace(pDColorSpace).getColorSpace();
        }
        return FALLBACK;
    }

    @Override
    public ColorModel getColorModel(PDImage pDImage) {
        int n = pDImage.getBitsPerComponent();
        ColorSpace colorSpace = this.getColorSpace();
        if (n < 8 && colorSpace.getNumComponents() == 1) {
            byte[] byArray = new byte[(int)Math.pow(2.0, n)];
            byte[] byArray2 = new byte[byArray.length];
            byte[] byArray3 = new byte[byArray.length];
            int n2 = 0;
            while (n2 < byArray.length) {
                float[] fArray = colorSpace.toRGB(new float[]{(float)n2 / (float)(byArray.length - 1)});
                byArray[n2] = (byte)((int)(fArray[0] * 255.0f) & 0xFF);
                byArray2[n2] = (byte)((int)(fArray[1] * 255.0f) & 0xFF);
                byArray3[n2] = (byte)((int)(fArray[2] * 255.0f) & 0xFF);
                ++n2;
            }
            IndexColorModel indexColorModel = new IndexColorModel(n, byArray.length, byArray, byArray2, byArray3);
            return indexColorModel;
        }
        return new ComponentColorModel(colorSpace, false, false, 1, 0);
    }

    protected PDCSICCBased myPDColorSpace() {
        return (PDCSICCBased)this.getPDColorSpace();
    }

    public ICC_Profile resolveProfile() {
        try {
            return ICC_Profile.getInstance(this.myPDColorSpace().cosGetProfileStream().getDecodedBytes());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

