#lang racket/base
(require racket/contract)

(define (string-len-one? x)
  (and (string? x)
       (= 1 (string-length x))))
  
(provide/contract
 [tex-shortcut-table
  (listof (list/c string? string-len-one?))])

(define tex-shortcut-table
  '(("Downarrow" "⇓")
    ("nwarrow" "↖")
    ("downarrow" "↓")
    ("Rightarrow" "⇒")
    ("rightarrow" "→")
    ("mapsto" "↦")
    ("searrow" "↘")
    ("swarrow" "↙")
    ("leftarrow" "←")
    ("uparrow" "↑")
    ("Leftarrow" "⇐")
    ("longrightarrow" "−")
    ("Uparrow" "⇑")
    ("Leftrightarrow" "⇔")
    ("updownarrow" "↕")
    ("leftrightarrow" "↔")
    ("nearrow" "↗")
    ("Updownarrow" "⇕")
   
    ;; arrows that didn't come out right in copy & paste
    ;←− \longleftarrow
    ;⇐= \Longleftarrow 
    ;← 􏰂 \hookleftarrow
    ;←→ \longleftrightarrow 
    ;􏰁 → \hookrightarrow
    ;⇐⇒ \Longleftrightarrow
    ;􏴲 \leadsto∗ 
    ;􏰃−→ \longmapsto
    ;=⇒ \Longrightarrow 
    ;􏰃→ \mapsto
    
    ("aleph" "א")
    ("prime" "′")
    ("emptyset" "∅")
    ("nabla" "∇")
    ("diamondsuit" "♦")
    ("spadesuit" "♠")
    ("clubsuit" "♣")
    ("heartsuit" "♥")
    ("sharp" "♯")
    ("flat" "♭")
    ("natural" "♮")
    ("surd" "√")
    ("neg" "¬")
    ("triangle" "△")
    ("forall" "∀")
    ("exists" "∃")
    ("infty" "∞")
    ("circ" "∘")
    ("alpha" "α")
    ("theta" "θ")
    ("tau" "τ")
    ("beta" "β")
    ("vartheta" "θ")
    ("pi" "π")
    ("upsilon" "υ")
    ("gamma" "γ")
    ("varpi" "π")
    ("phi" "φ")
    ("delta" "δ")
    ("kappa" "κ")
    ("rho" "ρ")
    ("varphi" "φ")
    ("epsilon" "ε")
    ("lambda" "λ")
    ("varrho" "ρ")
    ("chi" "χ")
    ("varepsilon" "ε")
    ("mu" "μ")
    ("sigma" "σ")
    ("psi" "ψ")
    ("zeta" "ζ")
    ("nu" "ν")
    ("varsigma" "ς")
    ("omega" "ω")
    ("eta" "η")
    ("xi" "ξ")
    ("iota" "ι")
    ("Gamma" "Γ")
    ("Lambda" "Λ")
    ("Sigma" "Σ")
    ("Psi" "Ψ")
    ("Delta" "Δ")
    ("Xi" "Ξ")
    ("Upsilon" "Υ")
    ("Omega" "Ω")
    ("Theta" "Θ")
    ("Pi" "Π")
    ("Phi" "Φ")
    ("pm" "±")
    ("cap" "∩")
    ("diamond" "◇")
    ("oplus" "⊕")
    ("mp" "∓")
    ("cup" "∪")
    ("bigtriangleup" "△")
    ("ominus" "⊖")
    ("times" "×")
    ("uplus" "⊎")
    ("bigtriangledown" "▽")
    ("otimes" "⊗")
    ("div" "÷")
    ("sqcap" "⊓")
    ("triangleright" "▹")
    ("oslash" "⊘")
    ("ast" "∗")
    ("sqcup" "⊔")
    ("vee" "∨")
    ("wedge" "∧")
    ("triangleleft" "◃")
    ("odot" "⊙")
    ("star" "★")
    ("dagger" "†")
    ("bullet" "•")
    ("ddagger" "‡")
    ("wr" "≀")
    ("amalg" "⨿")
    ("leq" "≤")
    ("geq" "≥")
    ("equiv" "≡")
    ("models" "⊨")
    ("prec" "≺")
    ("succ" "≻")
    ("precdot" "⋖")
    ("succdot" "⋗")
    ("sim" "∼")
    ("perp" "⊥")
    ("bot" "⊥")
    ("top" "⊤")
    ("preceq" "≼")
    ("succeq" "≽")
    ("simeq" "≃")
    ("ll" "≪")
    ("gg" "≫")
    ("asymp" "≍")
    ("parallel" "∥")
    ("subset" "⊂")
    ("supset" "⊃")
    ("approx" "≈")
    ("bowtie" "⋈")
    ("subseteq" "⊆")
    ("supseteq" "⊇")
    ("cong" "≌")
    ("sqsubsetb" "⊏")
    ("sqsupsetb" "⊐")
    ("neq" #;"≠" "≠")
    ("smile" "⌣")
    ("sqsubseteq" "⊑")
    ("sqsupseteq" "⊒")
    ("doteq" "≐")
    ("frown" "⌢")
    ("in" "∈")
    ("ni" "∋")
    ("propto" "∝")
    ("vdash" "⊢")
    ("dashv" "⊣")
    ("cdot" "·")
    ("sum" "∑")
    ("prod" "∏")
    ("coprod" "∐")
    
    ("int" "∫")
    ("oint" "∮")

    ("sqrt" "√")
    
    ("skull" "☠") 
    ("smiley" "☺")
    ("blacksmiley" "☻")
    ("frownie" "☹")
    
    ("S" "§")
    ("l" "ł")
    
    ("newpage" "\f")
    
    ("vdots" "⋮")
    ("ddots" "⋱")
    ("cdots" "⋯")
    ("hdots" "⋯")
    
    ("langle" "⟨")
    ("rangle" "⟩")))

(module+ test
  (require racket/match)
  (define name-ht (make-hash))
  (define val-ht (make-hash))
  (for ([line (in-list tex-shortcut-table)])
    (match-define (list name obj) line)
    (hash-set! name-ht name (cons obj (hash-ref name-ht name '()))))
  (for ([(k v) (in-hash name-ht)])
    (unless (= 1 (length v))
      (eprintf "duplicate: ~s -> ~s\n" k v))))


