/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPopupMenu;

public class FigureAttributes
implements Cloneable,
Serializable {
    private Hashtable fMap = new Hashtable();
    private static final long serialVersionUID = -6886355144423666716L;
    private int figureAttributesSerializedDataVersion = 1;

    public Object get(String name) {
        return this.fMap.get(name);
    }

    public void set(String name, Object value) {
        if (value != null) {
            this.fMap.put(name, value);
        } else {
            this.fMap.remove(name);
        }
    }

    public boolean hasDefined(String name) {
        return this.fMap.containsKey(name);
    }

    public Object clone() {
        try {
            FigureAttributes a = (FigureAttributes)super.clone();
            a.fMap = (Hashtable)this.fMap.clone();
            return a;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void read(StorableInput dr) throws IOException {
        String s = dr.readString();
        if (!s.toLowerCase().equals("attributes")) {
            throw new IOException("Attributes expected");
        }
        this.fMap = new Hashtable();
        int size = dr.readInt();
        for (int i = 0; i < size; ++i) {
            String key = dr.readString();
            String valtype = dr.readString();
            Object val = null;
            if (valtype.equals("Color")) {
                val = new Color(dr.readInt(), dr.readInt(), dr.readInt());
            } else if (valtype.equals("Boolean")) {
                val = new Boolean(dr.readString());
            } else if (valtype.equals("String")) {
                val = dr.readString();
            } else if (valtype.equals("Int")) {
                val = new Integer(dr.readInt());
            } else if (valtype.equals("Storable")) {
                val = dr.readStorable();
            } else if (valtype.equals("POPUP_MENU") || valtype.equals("UNKNOWN")) continue;
            this.fMap.put(key, val);
        }
    }

    public void write(StorableOutput dw) {
        dw.writeString("attributes");
        dw.writeInt(this.fMap.size());
        Enumeration k = this.fMap.keys();
        while (k.hasMoreElements()) {
            String s = (String)k.nextElement();
            Object v = this.fMap.get(s);
            dw.writeString(s);
            if (v instanceof String) {
                dw.writeString("String");
                dw.writeString((String)v);
                continue;
            }
            if (v instanceof Color) {
                FigureAttributes.writeColor(dw, "Color", (Color)v);
                continue;
            }
            if (v instanceof Boolean) {
                dw.writeString("Boolean");
                if (((Boolean)v).booleanValue()) {
                    dw.writeString("TRUE");
                    continue;
                }
                dw.writeString("FALSE");
                continue;
            }
            if (v instanceof Integer) {
                dw.writeString("Int");
                dw.writeInt((Integer)v);
                continue;
            }
            if (v instanceof Storable) {
                dw.writeString("Storable");
                dw.writeStorable((Storable)v);
                continue;
            }
            if (v instanceof JPopupMenu) {
                dw.writeString("POPUP_MENU");
                continue;
            }
            System.err.println("Unknown attribute: " + v);
            dw.writeString("UNKNOWN");
        }
    }

    public static void writeColor(StorableOutput dw, String colorName, Color color) {
        if (color != null) {
            dw.writeString(colorName);
            dw.writeInt(color.getRed());
            dw.writeInt(color.getGreen());
            dw.writeInt(color.getBlue());
        }
    }

    public static Color readColor(StorableInput dr) throws IOException {
        return new Color(dr.readInt(), dr.readInt(), dr.readInt());
    }
}

