/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.client;

import ch.softenvironment.client.UserSettings;
import ch.softenvironment.util.ParserCSV;
import ch.softenvironment.util.StringUtils;
import ch.softenvironment.util.Tracer;
import java.awt.Color;
import java.awt.Font;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.UIManager;

public class ApplicationOptions
extends Properties
implements UserSettings {
    private static final char SEPARATOR = ';';
    protected static final String HOME_DIRECTORY = "user.home";
    private static final String LOOK_AND_FEEL = "LOOK_AND_FEEL";
    private static final String BACKGROUND_COLOR = "BACKGROUND_COLOR";
    private static final String FONT = "FONT";
    private static final String FOREGROUND_COLOR = "FOREGROUND_COLOR";
    private static final String IMPORT_DIRECTORY = "IMPORT_DIRECTORY";
    private static final String LANGUAGE = "LANGUAGE";
    private static final String COUNTRY = "COUNTRY";
    private static final String SHOW_STATUS_BAR = "SHOW_STATUS_BAR";
    private static final String SHOW_TOOLBAR = "SHOW_TOOLBAR";
    private static final String WORKING_DIRECTORY = "WORKING_DIRECTORY";
    private static final String LAST_FILES = "LAST_FILES";
    private static final String WINDOW_HEIGHT = "WINDOW_HEIGHT";
    private static final String WINDOW_WIDTH = "WINDOW_WIDTH";
    private static final String WINDOW_X = "WINDOW_X";
    private static final String WINDOW_Y = "WINDOW_Y";
    private String filename = null;
    private transient Locale plattformLocale = null;

    protected ApplicationOptions() {
        this.setPlattformLocale(Locale.getDefault());
        this.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        this.setBackgroundColor(Color.white);
        this.setForegroundColor(Color.black);
        this.setImportDirectory(System.getProperty(HOME_DIRECTORY));
        this.setShowStatusBar(Boolean.TRUE);
        this.setShowToolBar(Boolean.TRUE);
        this.setWorkingDirectory(System.getProperty(HOME_DIRECTORY));
        this.setLastFiles(new ArrayList());
        this.setWindowHeight(new Integer(600));
        this.setWindowWidth(new Integer(800));
        this.setWindowX(new Integer(10));
        this.setWindowY(new Integer(10));
    }

    public ApplicationOptions(String filename) {
        this(filename, new ApplicationOptions());
    }

    protected ApplicationOptions(String filename, Properties defaults) {
        super(defaults);
        this.setPlattformLocale(Locale.getDefault());
        try {
            this.filename = filename;
            FileInputStream inputStream = new FileInputStream(filename);
            super.load(inputStream);
        }
        catch (FileNotFoundException fe) {
            Tracer.getInstance().runtimeWarning("File not found: " + fe.getLocalizedMessage());
        }
        catch (IOException ioe) {
            Tracer.getInstance().runtimeWarning("IO failure: " + ioe.getLocalizedMessage());
        }
    }

    @Override
    public boolean getActive() {
        return true;
    }

    @Override
    public boolean getAdmin() {
        return false;
    }

    public Color getBackgroundColor() {
        return new Color(new Integer(this.getProperty(BACKGROUND_COLOR)));
    }

    @Override
    public String getCountry() {
        String country = this.getProperty(COUNTRY);
        if (StringUtils.isNullOrEmpty(country)) {
            return Locale.getDefault().getCountry();
        }
        return country;
    }

    public Font getFont() {
        if (StringUtils.isNullOrEmpty(this.getFontString())) {
            return null;
        }
        return Font.decode(this.getFontString());
    }

    public String getFontString() {
        return this.getProperty(FONT);
    }

    public Color getForegroundColor() {
        return new Color(new Integer(this.getProperty(FOREGROUND_COLOR)));
    }

    public String getImportDirectory() {
        return this.getProperty(IMPORT_DIRECTORY);
    }

    @Override
    public String getLanguage() {
        String language = this.getProperty(LANGUAGE);
        if (StringUtils.isNullOrEmpty(language)) {
            return Locale.getDefault().getLanguage();
        }
        return language;
    }

    public List getLastFiles() {
        return ParserCSV.stringToArray(this.getProperty(LAST_FILES), ';');
    }

    @Override
    public String getLookAndFeel() {
        return this.getProperty(LOOK_AND_FEEL);
    }

    @Override
    public String getProviderSMTP() {
        return null;
    }

    public Boolean getShowStatusBar() {
        return Boolean.valueOf(this.getProperty(SHOW_STATUS_BAR));
    }

    public Boolean getShowToolBar() {
        return Boolean.valueOf(this.getProperty(SHOW_TOOLBAR));
    }

    @Override
    public String getUserId() {
        return "<NONE>";
    }

    public Integer getWindowHeight() {
        return new Integer(this.getProperty(WINDOW_HEIGHT));
    }

    public Integer getWindowWidth() {
        return new Integer(this.getProperty(WINDOW_WIDTH));
    }

    public Integer getWindowX() {
        return new Integer(this.getProperty(WINDOW_X));
    }

    public Integer getWindowY() {
        return new Integer(this.getProperty(WINDOW_Y));
    }

    @Override
    public String getWorkingDirectory() {
        String tmp = this.getProperty(WORKING_DIRECTORY);
        if (tmp == null) {
            return System.getProperty(HOME_DIRECTORY);
        }
        return tmp;
    }

    @Override
    public final void save() {
        try {
            FileOutputStream outputStream = new FileOutputStream(this.filename);
            super.store(outputStream, "User Properties <" + this.filename + ">");
        }
        catch (Throwable e) {
            Tracer.getInstance().runtimeWarning("IGNORE: Failed for User Properties <" + this.filename + ">");
        }
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.setProperty(BACKGROUND_COLOR, new Integer(backgroundColor.getRGB()).toString());
    }

    public void setCountry(String country) {
        this.setProperty(COUNTRY, country);
    }

    public void setFont(Font font) {
        if (font == null) {
            this.setProperty(FONT, null);
        } else {
            String s = font.getFamily() + "-";
            switch (font.getStyle()) {
                case 1: {
                    s = s + "BOLD";
                    break;
                }
                case 2: {
                    s = s + "ITALIC";
                    break;
                }
                case 3: {
                    s = s + "BOLDITALIC";
                    break;
                }
                default: {
                    s = s + "PLAIN";
                }
            }
            this.setProperty(FONT, s + "-" + font.getSize());
        }
    }

    public void setForegroundColor(Color foregroundColor) {
        this.setProperty(FOREGROUND_COLOR, new Integer(foregroundColor.getRGB()).toString());
    }

    public void setImportDirectory(String importDirectory) {
        this.setProperty(IMPORT_DIRECTORY, importDirectory);
    }

    public void setLanguage(String language) {
        this.setProperty(LANGUAGE, language);
    }

    public void setLastFiles(List lastFiles) {
        this.setProperty(LAST_FILES, ParserCSV.arrayToString(lastFiles, ';'));
    }

    public void setLookAndFeel(String string) {
        this.setProperty(LOOK_AND_FEEL, string);
    }

    public void setShowStatusBar(Boolean showStatusBar) {
        this.setProperty(SHOW_STATUS_BAR, showStatusBar.toString());
    }

    public void setShowToolBar(Boolean showToolBar) {
        this.setProperty(SHOW_TOOLBAR, showToolBar.toString());
    }

    public void setWindowHeight(Integer value) {
        this.setProperty(WINDOW_HEIGHT, value.toString());
    }

    public void setWindowWidth(Integer value) {
        this.setProperty(WINDOW_WIDTH, value.toString());
    }

    public void setWindowX(Integer value) {
        this.setProperty(WINDOW_X, value.toString());
    }

    public void setWindowY(Integer value) {
        this.setProperty(WINDOW_Y, value.toString());
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.setProperty(WORKING_DIRECTORY, workingDirectory);
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return super.setProperty(key, value == null ? "" : value);
    }

    protected final void setPlattformLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale must not be null!");
        }
        this.plattformLocale = locale;
        Tracer.getInstance().debug("Platform Locale: " + (locale == null ? "null" : locale.toString()));
    }

    public final Locale getPlattformLocale() {
        return this.plattformLocale == null ? Locale.getDefault() : this.plattformLocale;
    }
}

