/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view.tree;

import ch.softenvironment.util.Tracer;
import ch.softenvironment.view.tree.AutoScrollingTree;
import ch.softenvironment.view.tree.TreeNodeUtility;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class NavigationTreeCellRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (tree instanceof AutoScrollingTree && ((AutoScrollingTree)tree).getUtility() != null) {
            TreeNodeUtility utility = ((AutoScrollingTree)tree).getUtility();
            Icon icon = utility.getIcon(value.getClass(), expanded);
            if (icon != null) {
                this.setIcon(icon);
            }
            String name = utility.getName(value);
            this.setText(name);
            if (value != null) {
                this.setToolTipText(utility.getToolTip(value));
            }
        } else {
            Tracer.getInstance().developerWarning("tree expected as instanceof AutoScrollingTree with a non-null #getUtility()");
        }
        return this;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }
}

