/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.fife.ui.autocomplete.AbstractCompletionProvider;
import org.fife.ui.autocomplete.AutoCompletePopupWindow;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ExternalURLHandler;
import org.fife.ui.autocomplete.SizeGrip;
import org.fife.ui.autocomplete.TipUtil;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;

class AutoCompleteDescWindow
extends JWindow
implements HyperlinkListener {
    private AutoCompletion ac;
    private JEditorPane descArea;
    private JScrollPane scrollPane;
    private JPanel bottomPanel;
    private JToolBar descWindowNavBar;
    private Action backAction;
    private Action forwardAction;
    private List history;
    private int historyPos;
    private Timer timer;
    private TimerAction timerAction;
    private ResourceBundle bundle;
    private static final int INITIAL_TIMER_DELAY = 120;
    private static final String MSG = "org.fife.ui.autocomplete.AutoCompleteDescWindow";

    public AutoCompleteDescWindow(Window window, AutoCompletion autoCompletion) {
        super(window);
        PopupWindowDecorator popupWindowDecorator;
        this.ac = autoCompletion;
        ComponentOrientation componentOrientation = autoCompletion.getTextComponentOrientation();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(TipUtil.getToolTipBorder());
        this.descArea = new JEditorPane("text/html", null);
        TipUtil.tweakTipEditorPane(this.descArea);
        this.descArea.addHyperlinkListener(this);
        this.scrollPane = new JScrollPane(this.descArea);
        Border border = BorderFactory.createEmptyBorder();
        this.scrollPane.setBorder(border);
        this.scrollPane.setViewportBorder(border);
        this.scrollPane.setBackground(this.descArea.getBackground());
        this.scrollPane.getViewport().setBackground(this.descArea.getBackground());
        jPanel.add(this.scrollPane);
        this.descWindowNavBar = new JToolBar();
        this.backAction = new ToolBarBackAction(componentOrientation.isLeftToRight());
        this.forwardAction = new ToolBarForwardAction(componentOrientation.isLeftToRight());
        this.descWindowNavBar.setFloatable(false);
        this.descWindowNavBar.add(new JButton(this.backAction));
        this.descWindowNavBar.add(new JButton(this.forwardAction));
        this.bottomPanel = new JPanel(new BorderLayout());
        border = new AbstractBorder(){

            public Insets getBorderInsets(Component component) {
                return new Insets(1, 0, 0, 0);
            }

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                graphics.setColor(UIManager.getColor("controlDkShadow"));
                graphics.drawLine(n, n2, n + n3 - 1, n2);
            }
        };
        this.bottomPanel.setBorder(border);
        SizeGrip sizeGrip = new SizeGrip();
        this.bottomPanel.add((Component)this.descWindowNavBar, "Before");
        this.bottomPanel.add((Component)sizeGrip, "After");
        jPanel.add((Component)this.bottomPanel, "South");
        this.setContentPane(jPanel);
        this.applyComponentOrientation(componentOrientation);
        this.setFocusableWindowState(false);
        if (Util.getShouldAllowDecoratingMainAutoCompleteWindows() && (popupWindowDecorator = PopupWindowDecorator.get()) != null) {
            popupWindowDecorator.decorate((JWindow)this);
        }
        this.history = new ArrayList(1);
        this.historyPos = -1;
        this.timerAction = new TimerAction();
        this.timer = new Timer(120, this.timerAction);
        this.timer.setRepeats(false);
    }

    private void addToHistory(String string) {
        this.history.add(++this.historyPos, string);
        this.clearHistoryAfterCurrentPos();
        this.setActionStates();
    }

    private void clearHistory() {
        this.history.clear();
        this.historyPos = -1;
        if (this.descWindowNavBar != null) {
            this.setActionStates();
        }
    }

    private void clearHistoryAfterCurrentPos() {
        for (int i = this.history.size() - 1; i > this.historyPos; --i) {
            this.history.remove(i);
        }
        this.setActionStates();
    }

    public boolean copy() {
        if (this.isVisible() && this.descArea.getSelectionStart() != this.descArea.getSelectionEnd()) {
            this.descArea.copy();
            return true;
        }
        return false;
    }

    private String getString(String string) {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle(MSG);
        }
        return this.bundle.getString(string);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
        if (eventType.equals(HyperlinkEvent.EventType.ACTIVATED)) {
            URL uRL = hyperlinkEvent.getURL();
            if (uRL != null) {
                ExternalURLHandler externalURLHandler = this.ac.getExternalURLHandler();
                if (externalURLHandler != null) {
                    externalURLHandler.urlClicked(uRL);
                    return;
                }
                try {
                    Util.browse(new URI(uRL.toString()));
                }
                catch (URISyntaxException uRISyntaxException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(this.descArea);
                    uRISyntaxException.printStackTrace();
                }
            } else {
                AutoCompletePopupWindow autoCompletePopupWindow = (AutoCompletePopupWindow)this.getParent();
                CompletionProvider completionProvider = autoCompletePopupWindow.getSelection().getProvider();
                if (completionProvider instanceof AbstractCompletionProvider) {
                    String string = hyperlinkEvent.getDescription();
                    List list = ((AbstractCompletionProvider)completionProvider).getCompletionByInputText(string);
                    if (list != null && !list.isEmpty()) {
                        Completion completion = (Completion)list.get(0);
                        this.setDescriptionFor(completion, true);
                    } else {
                        UIManager.getLookAndFeel().provideErrorFeedback(this.descArea);
                    }
                }
            }
        }
    }

    private void setActionStates() {
        this.backAction.setEnabled(this.historyPos > 0);
        this.forwardAction.setEnabled(this.historyPos > -1 && this.historyPos < this.history.size() - 1);
    }

    public void setDescriptionFor(Completion completion) {
        this.setDescriptionFor(completion, false);
    }

    protected void setDescriptionFor(Completion completion, boolean bl) {
        this.timer.stop();
        this.timerAction.setCompletion(completion, bl);
        this.timer.start();
    }

    private void setDisplayedDesc(String string, boolean bl) {
        if (string == null) {
            string = "<html><em>" + this.getString("NoDescAvailable") + "</em>";
        }
        this.descArea.setText(string);
        this.descArea.setCaretPosition(0);
        if (!bl) {
            this.clearHistory();
        }
        this.addToHistory(string);
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            this.clearHistory();
        }
        super.setVisible(bl);
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this);
        TipUtil.tweakTipEditorPane(this.descArea);
        this.scrollPane.setBackground(this.descArea.getBackground());
        this.scrollPane.getViewport().setBackground(this.descArea.getBackground());
        ((JPanel)this.getContentPane()).setBorder(TipUtil.getToolTipBorder());
    }

    class ToolBarForwardAction
    extends AbstractAction {
        public ToolBarForwardAction(boolean bl) {
            String string = "org/fife/ui/autocomplete/arrow_" + (bl ? "right.png" : "left.png");
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL uRL = classLoader.getResource(string);
            try {
                ImageIcon imageIcon = new ImageIcon(ImageIO.read(uRL));
                this.putValue("SmallIcon", imageIcon);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.putValue("ShortDescription", "Forward");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompleteDescWindow.this.history != null && AutoCompleteDescWindow.this.historyPos < AutoCompleteDescWindow.this.history.size() - 1) {
                AutoCompleteDescWindow.this.descArea.setText((String)AutoCompleteDescWindow.this.history.get(++AutoCompleteDescWindow.this.historyPos));
                AutoCompleteDescWindow.this.descArea.setCaretPosition(0);
                AutoCompleteDescWindow.this.setActionStates();
            }
        }
    }

    class ToolBarBackAction
    extends AbstractAction {
        public ToolBarBackAction(boolean bl) {
            String string = "org/fife/ui/autocomplete/arrow_" + (bl ? "left.png" : "right.png");
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL uRL = classLoader.getResource(string);
            try {
                ImageIcon imageIcon = new ImageIcon(ImageIO.read(uRL));
                this.putValue("SmallIcon", imageIcon);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.putValue("ShortDescription", "Back");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompleteDescWindow.this.historyPos > 0) {
                AutoCompleteDescWindow.this.descArea.setText((String)AutoCompleteDescWindow.this.history.get(--AutoCompleteDescWindow.this.historyPos));
                AutoCompleteDescWindow.this.descArea.setCaretPosition(0);
                AutoCompleteDescWindow.this.setActionStates();
            }
        }
    }

    private class TimerAction
    extends AbstractAction {
        private Completion completion;
        private boolean addToHistory;

        private TimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.completion == null ? null : this.completion.getSummary();
            AutoCompleteDescWindow.this.setDisplayedDesc(string, this.addToHistory);
        }

        public void setCompletion(Completion completion, boolean bl) {
            this.completion = completion;
            this.addToHistory = bl;
        }
    }
}

