/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.common;

import com.baselet.control.basics.XValues;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.control.enums.ElementStyle;
import com.baselet.control.enums.Priority;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.TextSplitter;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.gui.AutocompletionText;
import java.util.Collections;
import java.util.List;

public class TextPrintFacet
extends Facet {
    public static final TextPrintFacet INSTANCE = new TextPrintFacet();

    private TextPrintFacet() {
    }

    @Override
    public boolean checkStart(String string, PropertiesParserState propertiesParserState) {
        return !string.startsWith("//");
    }

    @Override
    public void handleLine(String string, PropertiesParserState propertiesParserState) {
        DrawHandler drawHandler = propertiesParserState.getDrawer();
        drawHandler.setLayer(DrawHandler.Layer.Foreground);
        TextPrintFacet.setupAtFirstLine(string, drawHandler, propertiesParserState);
        if (propertiesParserState.getElementStyle() == ElementStyle.WORDWRAP && !string.trim().isEmpty()) {
            TextPrintFacet.printLineWithWordWrap(string, drawHandler, propertiesParserState);
        } else {
            TextPrintFacet.printLine(string, drawHandler, propertiesParserState);
        }
        drawHandler.setLayer(DrawHandler.Layer.Background);
    }

    private static void printLineWithWordWrap(String string, DrawHandler drawHandler, PropertiesParserState propertiesParserState) {
        while (propertiesParserState.getTextPrintPosition() < (double)propertiesParserState.getGridElementSize().height && !string.trim().isEmpty()) {
            double d = propertiesParserState.getXLimitsForArea(propertiesParserState.getTextPrintPosition(), drawHandler.textHeightMax(), false).getSpace() - drawHandler.getDistanceBorderToText() * 2.0;
            String string2 = TextSplitter.splitString(string, d, drawHandler);
            TextPrintFacet.printLine(string2, drawHandler, propertiesParserState);
            string = string.substring(string2.length()).trim();
        }
    }

    private static void printLine(String string, DrawHandler drawHandler, PropertiesParserState propertiesParserState) {
        XValues xValues = propertiesParserState.getXLimitsForArea(propertiesParserState.getTextPrintPosition(), drawHandler.textHeightMax(), false);
        Double d = (double)propertiesParserState.getGridElementSize().width - xValues.getSpace();
        if (!d.equals(Double.NaN)) {
            propertiesParserState.updateMinimumWidth(d + drawHandler.textWidth(string));
        }
        AlignHorizontal alignHorizontal = propertiesParserState.getAlignment().getHorizontal();
        drawHandler.print(string, TextPrintFacet.calcHorizontalTextBoundaries(xValues, drawHandler.getDistanceBorderToText(), alignHorizontal), propertiesParserState.getTextPrintPosition(), alignHorizontal);
        propertiesParserState.increaseTextPrintPosition(drawHandler.textHeightMaxWithSpace());
    }

    private static void setupAtFirstLine(String string, DrawHandler drawHandler, PropertiesParserState propertiesParserState) {
        boolean bl = propertiesParserState.getFacetResponse(TextPrintFacet.class, true);
        if (bl) {
            propertiesParserState.getBuffer().setTopMin(TextPrintFacet.calcStartPointFromVAlign(drawHandler, propertiesParserState));
            propertiesParserState.getBuffer().setTopMin(TextPrintFacet.calcTopDisplacementToFitLine(string, propertiesParserState, drawHandler));
            propertiesParserState.setFacetResponse(TextPrintFacet.class, false);
        }
    }

    private static double calcStartPointFromVAlign(DrawHandler drawHandler, PropertiesParserState propertiesParserState) {
        double d = drawHandler.textHeightMax();
        d = propertiesParserState.getAlignment().getVertical() == AlignVertical.TOP ? (d += drawHandler.getDistanceBorderToText() + propertiesParserState.getBuffer().getTop()) : (propertiesParserState.getAlignment().getVertical() == AlignVertical.CENTER ? (d += ((double)propertiesParserState.getGridElementSize().height - propertiesParserState.getTotalTextBlockHeight()) / 2.0 + propertiesParserState.getBuffer().getTop() / 2.0) : (d += (double)propertiesParserState.getGridElementSize().height - propertiesParserState.getTotalTextBlockHeight() - drawHandler.textHeightMax() / 4.0));
        return d;
    }

    private static double calcTopDisplacementToFitLine(String string, PropertiesParserState propertiesParserState, DrawHandler drawHandler) {
        boolean bl;
        double d = propertiesParserState.getTextPrintPosition();
        boolean bl2 = bl = propertiesParserState.getElementStyle() == ElementStyle.WORDWRAP;
        if (!bl) {
            int n = 2;
            double d2 = drawHandler.textHeightMax();
            double d3 = d2 / 2.0;
            double d4 = propertiesParserState.getXLimitsForArea(d, d2, true).getSpace() - (double)n;
            int n2 = 1000;
            for (double d5 = d; d5 < (double)propertiesParserState.getGridElementSize().height && !TextSplitter.checkifStringFits(string, d4, drawHandler); d5 += d3) {
                if (n2-- < 0) {
                    throw new RuntimeException("Endless loop during calculation of top displacement");
                }
                double d6 = d4;
                d4 = propertiesParserState.getXLimitsForArea(d5, d2, true).getSpace() - (double)n;
                if (!(d4 > d6)) continue;
                d = d5;
            }
        }
        return d;
    }

    private static double calcHorizontalTextBoundaries(XValues xValues, double d, AlignHorizontal alignHorizontal) {
        double d2 = alignHorizontal == AlignHorizontal.LEFT ? xValues.getLeft() + d : (alignHorizontal == AlignHorizontal.CENTER ? xValues.getSpace() / 2.0 + xValues.getLeft() : xValues.getRight() - d);
        return d2;
    }

    @Override
    public List<AutocompletionText> getAutocompletionStrings() {
        return Collections.emptyList();
    }

    @Override
    public Priority getPriority() {
        return Priority.LOWEST;
    }
}

