/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.util.Hashtable;
import javax.accessibility.AccessibleContext;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;
import org.GNOME.Accessibility.Accessible;
import org.GNOME.Accessibility.AccessibleHelper;
import org.GNOME.Accessibility.AccessibleImpl;
import org.GNOME.Accessibility.Application;
import org.GNOME.Accessibility.ApplicationHelper;
import org.GNOME.Accessibility.ApplicationImpl;
import org.GNOME.Accessibility.JavaBridge;

public class AccessibleFactory
implements ObjectFactory {
    static Name[] typeNames = new Name[3];
    static int ACCESSIBLE_TYPE = 0;
    static int TOPLEVEL_TYPE = 1;
    static int APPLICATION_TYPE = 2;

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) {
        AccessibleContext accessibleContext = (AccessibleContext)object;
        Object object2 = hashtable.get(accessibleContext);
        if (object2 == null) {
            object2 = name == typeNames[APPLICATION_TYPE] ? new ApplicationImpl(accessibleContext) : new AccessibleImpl(accessibleContext);
            ((AccessibleImpl)object2).tie().ref();
            hashtable.put(accessibleContext, object2);
        } else {
            ((AccessibleImpl)object2).tie().ref();
        }
        return object2;
    }

    public Accessible getAccessible(AccessibleContext accessibleContext) {
        Accessible accessible = null;
        try {
            AccessibleImpl accessibleImpl = (AccessibleImpl)JavaBridge.getAccessibleObjectFactory().getObjectInstance((Object)accessibleContext, typeNames[ACCESSIBLE_TYPE], (Context)null, JavaBridge.getAccessibleObjectTable());
            accessible = AccessibleHelper.narrow(accessibleImpl.tie());
        }
        catch (Exception exception) {
            System.out.println("Error getting accessible object: " + exception);
        }
        return accessible;
    }

    public Application getApplication(AccessibleContext accessibleContext) {
        Application application = null;
        try {
            ApplicationImpl applicationImpl = (ApplicationImpl)JavaBridge.getAccessibleObjectFactory().getObjectInstance((Object)accessibleContext, typeNames[APPLICATION_TYPE], (Context)null, JavaBridge.getAccessibleObjectTable());
            application = ApplicationHelper.narrow(applicationImpl.tie());
        }
        catch (Exception exception) {
            System.out.println("Error getting application object: " + exception);
        }
        return application;
    }

    static {
        try {
            AccessibleFactory.typeNames[AccessibleFactory.ACCESSIBLE_TYPE] = new CompositeName("Accessible");
            AccessibleFactory.typeNames[AccessibleFactory.TOPLEVEL_TYPE] = new CompositeName("Toplevel");
            AccessibleFactory.typeNames[AccessibleFactory.APPLICATION_TYPE] = new CompositeName("Application");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

