/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.Serializable;
import org.tigris.subversion.javahl.Revision;

public class RevisionRange
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Revision from;
    private Revision to;

    private RevisionRange(long l, long l2) {
        this.from = Revision.getInstance(l);
        this.to = Revision.getInstance(l2);
    }

    public RevisionRange(Revision revision, Revision revision2) {
        this.from = revision;
        this.to = revision2;
    }

    public RevisionRange(org.apache.subversion.javahl.types.RevisionRange revisionRange) {
        this(Revision.createFromApache(revisionRange.getFromRevision()), Revision.createFromApache(revisionRange.getToRevision()));
    }

    public RevisionRange(String string) {
        if (string == null) {
            return;
        }
        int n = string.indexOf(45);
        if (n > 0) {
            try {
                long l = Long.parseLong(string.substring(0, n));
                long l2 = Long.parseLong(string.substring(n + 1));
                this.from = new Revision.Number(l);
                this.to = new Revision.Number(l2);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        try {
            long l = Long.parseLong(string.trim());
            this.to = this.from = new Revision.Number(l);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    public org.apache.subversion.javahl.types.RevisionRange toApache() {
        return new org.apache.subversion.javahl.types.RevisionRange(this.from == null ? null : this.from.toApache(), this.to == null ? null : this.to.toApache());
    }

    public Revision getFromRevision() {
        return this.from;
    }

    public Revision getToRevision() {
        return this.to;
    }

    public String toString() {
        if (this.from != null && this.to != null) {
            if (this.from.equals(this.to)) {
                return this.from.toString();
            }
            return this.from.toString() + '-' + this.to.toString();
        }
        return super.toString();
    }

    public static Long getRevisionAsLong(Revision revision) {
        long l = 0L;
        if (revision != null && revision instanceof Revision.Number) {
            l = ((Revision.Number)revision).getNumber();
        }
        return new Long(l);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.from == null ? 0 : this.from.hashCode());
        n = 31 * n + (this.to == null ? 0 : this.to.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RevisionRange revisionRange = (RevisionRange)object;
        if (this.from == null ? revisionRange.from != null : !this.from.equals(revisionRange.from)) {
            return false;
        }
        return !(this.to == null ? revisionRange.to != null : !this.to.equals(revisionRange.to));
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        Revision revision = ((RevisionRange)object).getFromRevision();
        return RevisionRange.getRevisionAsLong(this.getFromRevision()).compareTo(RevisionRange.getRevisionAsLong(revision));
    }
}

