/*
 * Decompiled with CFR 0.152.
 */
package dguitar.players.sound.midi;

import dguitar.adaptors.song.Tempo;
import dguitar.players.sound.EventSoundPlayer;
import dguitar.players.sound.Performance;
import dguitar.players.sound.PerformanceEventListener;
import dguitar.players.sound.PerformanceTimerListener;
import dguitar.players.sound.RealtimeSoundPlayer;
import dguitar.players.sound.SoundPlayer;
import dguitar.players.sound.midi.MetaPerformer;
import dguitar.players.sound.midi.MidiPerformanceEventListenerProxy;
import dguitar.players.sound.midi.MidiPerformanceTimerListenerProxy;
import dguitar.players.sound.midi.PerformanceLive;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;

public class MidiPlayer
implements SoundPlayer,
RealtimeSoundPlayer,
EventSoundPlayer {
    private String className;
    private Logger logger;
    Sequencer sequencer;
    PerformanceLive live;
    List listeners;
    private int timerFrequency;
    private boolean noteEventsEnabled;
    static /* synthetic */ Class class$0;

    public MidiPlayer() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("dguitar.players.sound.midi.MidiPlayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.className = clazz.toString();
        this.logger = Logger.getLogger(this.className);
        this.sequencer = null;
        this.listeners = new LinkedList();
    }

    public Performance createPerformance(int tracks, Tempo tempo, int resolution) {
        try {
            PerformanceLive alive = new PerformanceLive(tracks, tempo, resolution);
            alive.enableNoteEvents(this.noteEventsEnabled);
            alive.setTimerFrequency(this.timerFrequency);
            return alive;
        }
        catch (InvalidMidiDataException e) {
            this.logger.severe("Could not create a performance object");
            return null;
        }
    }

    public void start() {
        if (this.sequencer != null) {
            this.sequencer.close();
        }
        try {
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.open();
        }
        catch (MidiUnavailableException e) {
            this.sequencer = null;
        }
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            MetaPerformer mp = (MetaPerformer)it.next();
            mp.setContainer(this.live);
            this.sequencer.addMetaEventListener((MetaEventListener)((Object)mp));
        }
        try {
            this.sequencer.setSequence(this.live);
        }
        catch (InvalidMidiDataException e1) {
            this.sequencer = null;
        }
        this.sequencer.start();
    }

    public void stop() {
        if (this.sequencer.isOpen()) {
            this.sequencer.stop();
        }
    }

    public void waitForCompletion() {
        while (this.sequencer.isRunning()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setPerformance(Performance performance) {
        this.live = (PerformanceLive)performance;
    }

    public void close() {
        if (this.sequencer != null) {
            this.sequencer.close();
        }
    }

    public void addTimerListener(PerformanceTimerListener listener) {
        MidiPerformanceTimerListenerProxy proxy = new MidiPerformanceTimerListenerProxy(listener);
        this.listeners.add(proxy);
    }

    public void addEventListener(PerformanceEventListener listener) {
        MidiPerformanceEventListenerProxy proxy = new MidiPerformanceEventListenerProxy(listener);
        this.listeners.add(proxy);
    }

    public void setTimerFrequency(int ppq) {
        this.timerFrequency = ppq;
    }

    public void enableNoteEvents(boolean enable) {
        this.noteEventsEnabled = enable;
    }
}

