/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.GeoUtils;

public class GeoHashUtils {
    public static final char[] BASE_32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final String BASE_32_STRING = new String(BASE_32);
    public static final int PRECISION = 12;
    private static final short MORTON_OFFSET = 4;

    public static final long longEncode(double lon, double lat, int level) {
        short msf = (short)((12 - level) * 5 + 4);
        return BitUtil.flipFlop((long)GeoUtils.mortonHash(lon, lat)) >>> msf << 4 | (long)level;
    }

    public static final long longEncode(String hash) {
        int level = hash.length() - 1;
        long l = 0L;
        for (char c : hash.toCharArray()) {
            long b = BASE_32_STRING.indexOf(c);
            l |= b << level-- * 5;
        }
        return l << 4 | (long)hash.length();
    }

    public static final String stringEncode(long geoHashLong) {
        int level = (int)geoHashLong & 0xF;
        geoHashLong >>>= 4;
        char[] chars = new char[level];
        do {
            chars[--level] = BASE_32[(int)(geoHashLong & 0x1FL)];
            geoHashLong >>>= 5;
        } while (level > 0);
        return new String(chars);
    }

    public static final String stringEncode(double lon, double lat) {
        return GeoHashUtils.stringEncode(lon, lat, 12);
    }

    public static final String stringEncode(double lon, double lat, int level) {
        long hashedVal = BitUtil.flipFlop((long)GeoUtils.mortonHash(lon, lat));
        StringBuilder geoHash = new StringBuilder();
        int precision = 0;
        int msf = 59;
        long mask = -576460752303423488L;
        do {
            geoHash.append(BASE_32[(int)((mask & hashedVal) >>> 59 - precision * 5)]);
            mask >>>= 5;
        } while ((precision = (int)((short)(precision + 1))) < level);
        return geoHash.toString();
    }

    public static final String stringEncodeFromMortonLong(long hashedVal) throws Exception {
        return GeoHashUtils.stringEncode(hashedVal, 12.0);
    }

    public static final String stringEncodeFromMortonLong(long hashedVal, int level) {
        hashedVal = BitUtil.flipFlop((long)hashedVal);
        StringBuilder geoHash = new StringBuilder();
        int precision = 0;
        int msf = 59;
        long mask = -576460752303423488L;
        do {
            geoHash.append(BASE_32[(int)((mask & hashedVal) >>> 59 - precision * 5)]);
            mask >>>= 5;
        } while ((precision = (int)((short)(precision + 1))) < level);
        return geoHash.toString();
    }

    public static final long mortonEncode(String hash) {
        int level = 11;
        long l = 0L;
        for (char c : hash.toCharArray()) {
            long b = BASE_32_STRING.indexOf(c);
            l |= b << level-- * 5 + 4;
        }
        return BitUtil.flipFlop((long)l);
    }

    public static final long mortonEncode(long geoHashLong) {
        int level = (int)(geoHashLong & 0xFL);
        short odd = (short)(level & 1);
        return BitUtil.flipFlop((long)(geoHashLong >>> 4 << odd)) << (12 - level) * 5 + (4 - odd);
    }
}

