/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.URIParameter;
import org.elasticsearch.common.SuppressForbidden;

final class ESPolicy
extends Policy {
    static final String POLICY_RESOURCE = "security.policy";
    static final String GROOVY_RESOURCE = "groovy.policy";
    final Policy template;
    final Policy groovy;
    final Policy system;
    final PermissionCollection dynamic;
    static final Permission BAD_DEFAULT_NUMBER_ONE = new RuntimePermission("stopThread");

    public ESPolicy(PermissionCollection dynamic, boolean filterBadDefaults) throws Exception {
        URI policyUri = this.getClass().getResource(POLICY_RESOURCE).toURI();
        URI groovyUri = this.getClass().getResource(GROOVY_RESOURCE).toURI();
        this.template = Policy.getInstance("JavaPolicy", new URIParameter(policyUri));
        this.groovy = Policy.getInstance("JavaPolicy", new URIParameter(groovyUri));
        this.system = filterBadDefaults ? new SystemPolicy(Policy.getPolicy()) : Policy.getPolicy();
        this.dynamic = dynamic;
    }

    @Override
    @SuppressForbidden(reason="fast equals check is desired")
    public boolean implies(ProtectionDomain domain, Permission permission) {
        URL location;
        CodeSource codeSource = domain.getCodeSource();
        if (codeSource != null && (location = codeSource.getLocation()) != null && "/groovy/script".equals(location.getFile())) {
            return this.groovy.implies(domain, permission);
        }
        return this.template.implies(domain, permission) || this.dynamic.implies(permission) || this.system.implies(domain, permission);
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!"sun.rmi.server.LoaderHandler".equals(element.getClassName()) || !"loadClass".equals(element.getMethodName())) continue;
            return new Permissions();
        }
        return super.getPermissions(codesource);
    }

    static class SystemPolicy
    extends Policy {
        final Policy delegate;

        SystemPolicy(Policy delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean implies(ProtectionDomain domain, Permission permission) {
            if (BAD_DEFAULT_NUMBER_ONE.equals(permission)) {
                return false;
            }
            return this.delegate.implies(domain, permission);
        }
    }
}

