/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.elasticsearch.common.collect.CopyOnWriteHashMap;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MappedFieldTypeReference;

class FieldTypeLookup
implements Iterable<MappedFieldType> {
    private static final Function<MappedFieldTypeReference, MappedFieldType> UNWRAPPER = new Function<MappedFieldTypeReference, MappedFieldType>(){

        public MappedFieldType apply(MappedFieldTypeReference ref) {
            return ref.get();
        }
    };
    private final CopyOnWriteHashMap<String, MappedFieldTypeReference> fullNameToFieldType;
    private final CopyOnWriteHashMap<String, MappedFieldTypeReference> indexNameToFieldType;

    public FieldTypeLookup() {
        this.fullNameToFieldType = new CopyOnWriteHashMap();
        this.indexNameToFieldType = new CopyOnWriteHashMap();
    }

    private FieldTypeLookup(CopyOnWriteHashMap<String, MappedFieldTypeReference> fullName, CopyOnWriteHashMap<String, MappedFieldTypeReference> indexName) {
        this.fullNameToFieldType = fullName;
        this.indexNameToFieldType = indexName;
    }

    public FieldTypeLookup copyAndAddAll(Collection<FieldMapper> newFieldMappers) {
        CopyOnWriteHashMap<String, MappedFieldTypeReference> fullName = this.fullNameToFieldType;
        CopyOnWriteHashMap<String, MappedFieldTypeReference> indexName = this.indexNameToFieldType;
        for (FieldMapper fieldMapper : newFieldMappers) {
            MappedFieldType fieldType = fieldMapper.fieldType();
            MappedFieldTypeReference fullNameRef = fullName.get(fieldType.names().fullName());
            MappedFieldTypeReference indexNameRef = indexName.get(fieldType.names().indexName());
            if (fullNameRef == null && indexNameRef == null) {
                fullName = fullName.copyAndPut(fieldType.names().fullName(), fieldMapper.fieldTypeReference());
                indexName = indexName.copyAndPut(fieldType.names().indexName(), fieldMapper.fieldTypeReference());
                continue;
            }
            if (fullNameRef == null) {
                fullName = fullName.copyAndPut(fieldType.names().fullName(), indexNameRef);
                indexNameRef.set(fieldMapper.fieldType());
                fieldMapper.setFieldTypeReference(indexNameRef);
                continue;
            }
            if (indexNameRef == null) {
                indexName = indexName.copyAndPut(fieldType.names().indexName(), fullNameRef);
                fullNameRef.set(fieldMapper.fieldType());
                fieldMapper.setFieldTypeReference(fullNameRef);
                continue;
            }
            if (fullNameRef == indexNameRef) {
                fullNameRef.set(fieldMapper.fieldType());
                fieldMapper.setFieldTypeReference(fullNameRef);
                continue;
            }
            throw new IllegalStateException("insane mappings found. field " + fieldType.names().fullName() + " maps across types to field " + fieldType.names().indexName());
        }
        return new FieldTypeLookup(fullName, indexName);
    }

    public void checkCompatibility(Collection<FieldMapper> newFieldMappers, boolean updateAllTypes) {
        for (FieldMapper fieldMapper : newFieldMappers) {
            MappedFieldTypeReference indexNameRef;
            MappedFieldTypeReference ref = this.fullNameToFieldType.get(fieldMapper.fieldType().names().fullName());
            if (ref != null) {
                ArrayList<String> conflicts = new ArrayList<String>();
                ref.get().checkTypeName(fieldMapper.fieldType(), conflicts);
                if (conflicts.isEmpty()) {
                    boolean strict = !updateAllTypes;
                    ref.get().checkCompatibility(fieldMapper.fieldType(), conflicts, strict);
                }
                if (!conflicts.isEmpty()) {
                    throw new IllegalArgumentException("Mapper for [" + fieldMapper.fieldType().names().fullName() + "] conflicts with existing mapping in other types:\n" + ((Object)conflicts).toString());
                }
            }
            if ((indexNameRef = this.indexNameToFieldType.get(fieldMapper.fieldType().names().indexName())) == null) continue;
            ArrayList<String> conflicts = new ArrayList<String>();
            indexNameRef.get().checkTypeName(fieldMapper.fieldType(), conflicts);
            if (conflicts.isEmpty()) {
                boolean strict = !updateAllTypes;
                indexNameRef.get().checkCompatibility(fieldMapper.fieldType(), conflicts, strict);
            }
            if (conflicts.isEmpty()) continue;
            throw new IllegalArgumentException("Mapper for [" + fieldMapper.fieldType().names().fullName() + "] conflicts with mapping with the same index name in other types" + ((Object)conflicts).toString());
        }
    }

    public MappedFieldType get(String field) {
        MappedFieldTypeReference ref = this.fullNameToFieldType.get(field);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    public MappedFieldType getByIndexName(String field) {
        MappedFieldTypeReference ref = this.indexNameToFieldType.get(field);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    public Collection<String> simpleMatchToIndexNames(String pattern) {
        HashSet fields = Sets.newHashSet();
        for (MappedFieldType fieldType : this) {
            if (Regex.simpleMatch(pattern, fieldType.names().fullName())) {
                fields.add(fieldType.names().indexName());
                continue;
            }
            if (!Regex.simpleMatch(pattern, fieldType.names().indexName())) continue;
            fields.add(fieldType.names().indexName());
        }
        return fields;
    }

    public Collection<String> simpleMatchToFullName(String pattern) {
        HashSet fields = Sets.newHashSet();
        for (MappedFieldType fieldType : this) {
            if (Regex.simpleMatch(pattern, fieldType.names().fullName())) {
                fields.add(fieldType.names().fullName());
                continue;
            }
            if (!Regex.simpleMatch(pattern, fieldType.names().indexName())) continue;
            fields.add(fieldType.names().fullName());
        }
        return fields;
    }

    @Override
    public Iterator<MappedFieldType> iterator() {
        return Iterators.transform(this.fullNameToFieldType.values().iterator(), UNWRAPPER);
    }
}

