/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexOptions;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.StringFieldMapper;

public class TypeParsers {
    public static final String MULTI_FIELD_CONTENT_TYPE = "multi_field";
    public static final Mapper.TypeParser multiFieldConverterTypeParser = new Mapper.TypeParser(){

        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            ContentPath.Type pathType = null;
            FieldMapper.Builder mainFieldBuilder = null;
            ArrayList<FieldMapper.Builder> fields = null;
            String firstType = null;
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("path") && parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) {
                    pathType = TypeParsers.parsePathType(name, fieldNode.toString());
                    iterator.remove();
                    continue;
                }
                if (!fieldName.equals("fields")) continue;
                Map fieldsNode = (Map)fieldNode;
                Iterator fieldsIterator = fieldsNode.entrySet().iterator();
                while (fieldsIterator.hasNext()) {
                    String type;
                    Map.Entry entry1 = fieldsIterator.next();
                    String propName = (String)entry1.getKey();
                    Map propNode = (Map)entry1.getValue();
                    Object typeNode = propNode.get("type");
                    if (typeNode != null) {
                        type = typeNode.toString();
                        if (firstType == null) {
                            firstType = type;
                        }
                    } else {
                        throw new MapperParsingException("no type specified for property [" + propName + "]");
                    }
                    Mapper.TypeParser typeParser = parserContext.typeParser(type);
                    if (typeParser == null) {
                        throw new MapperParsingException("no handler for type [" + type + "] declared on field [" + fieldName + "]");
                    }
                    if (propName.equals(name)) {
                        mainFieldBuilder = (FieldMapper.Builder)typeParser.parse(propName, propNode, parserContext);
                        fieldsIterator.remove();
                        continue;
                    }
                    if (fields == null) {
                        fields = new ArrayList<FieldMapper.Builder>(2);
                    }
                    fields.add((FieldMapper.Builder)typeParser.parse(propName, propNode, parserContext));
                    fieldsIterator.remove();
                }
                fieldsNode.remove("type");
                DocumentMapperParser.checkNoRemainingFields(fieldName, fieldsNode, parserContext.indexVersionCreated());
                iterator.remove();
            }
            if (mainFieldBuilder == null) {
                Mapper.Builder<?, ?> builder;
                if (fields == null) {
                    return new StringFieldMapper.Builder(name).index(false);
                }
                Mapper.TypeParser typeParser = parserContext.typeParser(firstType);
                mainFieldBuilder = typeParser == null ? new StringFieldMapper.Builder(name).index(false) : ((builder = typeParser.parse(name, Collections.emptyMap(), parserContext)) instanceof FieldMapper.Builder ? ((FieldMapper.Builder)builder).index(false) : new StringFieldMapper.Builder(name).index(false));
            }
            if (fields != null && pathType != null) {
                for (Mapper.Builder builder : fields) {
                    mainFieldBuilder.addMultiField(builder);
                }
                mainFieldBuilder.multiFieldPathType(pathType);
            } else if (fields != null) {
                for (Mapper.Builder builder : fields) {
                    mainFieldBuilder.addMultiField(builder);
                }
            } else if (pathType != null) {
                mainFieldBuilder.multiFieldPathType(pathType);
            }
            return mainFieldBuilder;
        }
    };
    public static final String DOC_VALUES = "doc_values";
    public static final String INDEX_OPTIONS_DOCS = "docs";
    public static final String INDEX_OPTIONS_FREQS = "freqs";
    public static final String INDEX_OPTIONS_POSITIONS = "positions";
    public static final String INDEX_OPTIONS_OFFSETS = "offsets";

    public static void parseNumberField(NumberFieldMapper.Builder builder, String name, Map<String, Object> numberNode, Mapper.TypeParser.ParserContext parserContext) {
        TypeParsers.parseField(builder, name, numberNode, parserContext);
        Iterator<Map.Entry<String, Object>> iterator = numberNode.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String propName = Strings.toUnderscoreCase(entry.getKey());
            Object propNode = entry.getValue();
            if (propName.equals("precision_step")) {
                builder.precisionStep(XContentMapValues.nodeIntegerValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("ignore_malformed")) {
                builder.ignoreMalformed(XContentMapValues.nodeBooleanValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("coerce")) {
                builder.coerce(XContentMapValues.nodeBooleanValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("omit_norms")) {
                builder.omitNorms(XContentMapValues.nodeBooleanValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("similarity")) {
                builder.similarity(parserContext.similarityLookupService().similarity(propNode.toString()));
                iterator.remove();
                continue;
            }
            if (!TypeParsers.parseMultiField(builder, name, parserContext, propName, propNode)) continue;
            iterator.remove();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parseField(FieldMapper.Builder builder, String name, Map<String, Object> fieldNode, Mapper.TypeParser.ParserContext parserContext) {
        NamedAnalyzer indexAnalyzer = builder.fieldType().indexAnalyzer();
        NamedAnalyzer searchAnalyzer = builder.fieldType().searchAnalyzer();
        Version indexVersionCreated = parserContext.indexVersionCreated();
        Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
        while (iterator.hasNext()) {
            NamedAnalyzer analyzer;
            Map.Entry<String, Object> entry = iterator.next();
            String propName = Strings.toUnderscoreCase(entry.getKey());
            Object propNode = entry.getValue();
            if (propName.equals("index_name") && indexVersionCreated.before(Version.V_2_0_0_beta1)) {
                builder.indexName(propNode.toString());
                iterator.remove();
                continue;
            }
            if (propName.equals("store")) {
                builder.store(TypeParsers.parseStore(name, propNode.toString()));
                iterator.remove();
                continue;
            }
            if (propName.equals("index")) {
                TypeParsers.parseIndex(name, propNode.toString(), builder);
                iterator.remove();
                continue;
            }
            if (propName.equals("tokenized")) {
                builder.tokenized(XContentMapValues.nodeBooleanValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals(DOC_VALUES)) {
                builder.docValues(XContentMapValues.nodeBooleanValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("term_vector")) {
                TypeParsers.parseTermVector(name, propNode.toString(), builder);
                iterator.remove();
                continue;
            }
            if (propName.equals("boost")) {
                builder.boost(XContentMapValues.nodeFloatValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("store_term_vectors")) {
                builder.storeTermVectors(XContentMapValues.nodeBooleanValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("store_term_vector_offsets")) {
                builder.storeTermVectorOffsets(XContentMapValues.nodeBooleanValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("store_term_vector_positions")) {
                builder.storeTermVectorPositions(XContentMapValues.nodeBooleanValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("store_term_vector_payloads")) {
                builder.storeTermVectorPayloads(XContentMapValues.nodeBooleanValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("omit_norms")) {
                builder.omitNorms(XContentMapValues.nodeBooleanValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("norms")) {
                Map<String, Object> properties = XContentMapValues.nodeMapValue(propNode, "norms");
                Iterator<Map.Entry<String, Object>> propsIterator = properties.entrySet().iterator();
                while (propsIterator.hasNext()) {
                    Map.Entry<String, Object> entry2 = propsIterator.next();
                    String propName2 = Strings.toUnderscoreCase(entry2.getKey());
                    Object propNode2 = entry2.getValue();
                    if (propName2.equals("enabled")) {
                        builder.omitNorms(!XContentMapValues.nodeBooleanValue(propNode2));
                        propsIterator.remove();
                        continue;
                    }
                    if (!propName2.equals("loading")) continue;
                    builder.normsLoading(MappedFieldType.Loading.parse(XContentMapValues.nodeStringValue(propNode2, null), null));
                    propsIterator.remove();
                }
                DocumentMapperParser.checkNoRemainingFields(propName, properties, parserContext.indexVersionCreated());
                iterator.remove();
                continue;
            }
            if (propName.equals("omit_term_freq_and_positions")) {
                IndexOptions op;
                IndexOptions indexOptions = op = XContentMapValues.nodeBooleanValue(propNode) ? IndexOptions.DOCS : IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
                if (indexVersionCreated.onOrAfter(Version.V_1_0_0_RC2)) {
                    throw new ElasticsearchParseException("'omit_term_freq_and_positions' is not supported anymore - use ['index_options' : 'docs']  instead", new Object[0]);
                }
                builder.indexOptions(op);
                iterator.remove();
                continue;
            }
            if (propName.equals("index_options")) {
                builder.indexOptions(TypeParsers.nodeIndexOptionValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("analyzer") || propName.equals("index_analyzer") && indexVersionCreated.before(Version.V_2_0_0_beta1)) {
                analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                indexAnalyzer = analyzer;
                iterator.remove();
                continue;
            }
            if (propName.equals("search_analyzer")) {
                analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                searchAnalyzer = analyzer;
                iterator.remove();
                continue;
            }
            if (propName.equals("include_in_all")) {
                builder.includeInAll(XContentMapValues.nodeBooleanValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("postings_format") && indexVersionCreated.before(Version.V_2_0_0_beta1)) {
                iterator.remove();
                continue;
            }
            if (propName.equals("doc_values_format") && indexVersionCreated.before(Version.V_2_0_0_beta1)) {
                iterator.remove();
                continue;
            }
            if (propName.equals("similarity")) {
                builder.similarity(parserContext.similarityLookupService().similarity(propNode.toString()));
                iterator.remove();
                continue;
            }
            if (propName.equals("fielddata")) {
                Settings settings = Settings.builder().put(SettingsLoader.Helper.loadNestedFromMap(XContentMapValues.nodeMapValue(propNode, "fielddata"))).build();
                builder.fieldDataSettings(settings);
                iterator.remove();
                continue;
            }
            if (!propName.equals("copy_to")) continue;
            if (parserContext.isWithinMultiField()) {
                if (indexVersionCreated.after(Version.V_2_1_0) || indexVersionCreated.after(Version.V_2_0_1) && indexVersionCreated.before(Version.V_2_1_0)) {
                    throw new MapperParsingException("copy_to in multi fields is not allowed. Found the copy_to in field [" + name + "] which is within a multi field.");
                }
                ESLoggerFactory.getLogger("mapping [" + parserContext.type() + "]").warn("Found a copy_to in field [" + name + "] which is within a multi field. This feature has been removed and the copy_to will be ignored.", new Object[0]);
            }
            TypeParsers.parseCopyFields(propNode, builder);
            iterator.remove();
        }
        if (indexAnalyzer == null) {
            if (searchAnalyzer != null) {
                if (!parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) throw new MapperParsingException("analyzer on field [" + name + "] must be set when search_analyzer is set");
                indexAnalyzer = parserContext.analysisService().defaultIndexAnalyzer();
            }
        } else if (searchAnalyzer == null) {
            searchAnalyzer = indexAnalyzer;
        }
        builder.indexAnalyzer(indexAnalyzer);
        builder.searchAnalyzer(searchAnalyzer);
    }

    public static boolean parseMultiField(FieldMapper.Builder builder, String name, Mapper.TypeParser.ParserContext parserContext, String propName, Object propNode) {
        parserContext = parserContext.createMultiFieldContext(parserContext);
        if (propName.equals("path") && parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) {
            builder.multiFieldPathType(TypeParsers.parsePathType(name, propNode.toString()));
            return true;
        }
        if (propName.equals("fields")) {
            Map multiFieldsPropNodes;
            if (propNode instanceof List && ((List)propNode).isEmpty()) {
                multiFieldsPropNodes = Collections.emptyMap();
            } else if (propNode instanceof Map) {
                multiFieldsPropNodes = (Map)propNode;
            } else {
                throw new MapperParsingException("expected map for property [fields] on field [" + propNode + "] or " + "[" + propName + "] but got a " + propNode.getClass());
            }
            for (Map.Entry multiFieldEntry : multiFieldsPropNodes.entrySet()) {
                String multiFieldName = (String)multiFieldEntry.getKey();
                if (multiFieldName.contains(".")) {
                    throw new MapperParsingException("Field name [" + multiFieldName + "] which is a multi field of [" + name + "] cannot contain '.'");
                }
                if (!(multiFieldEntry.getValue() instanceof Map)) {
                    throw new MapperParsingException("illegal field [" + multiFieldName + "], only fields can be specified inside fields");
                }
                Map multiFieldNodes = (Map)multiFieldEntry.getValue();
                Object typeNode = multiFieldNodes.get("type");
                if (typeNode == null) {
                    throw new MapperParsingException("no type specified for property [" + multiFieldName + "]");
                }
                String type = typeNode.toString();
                if (type.equals("object") || type.equals("nested")) {
                    throw new MapperParsingException("Type [" + type + "] cannot be used in multi field");
                }
                Mapper.TypeParser typeParser = parserContext.typeParser(type);
                if (typeParser == null) {
                    throw new MapperParsingException("no handler for type [" + type + "] declared on field [" + multiFieldName + "]");
                }
                builder.addMultiField(typeParser.parse(multiFieldName, multiFieldNodes, parserContext));
                multiFieldNodes.remove("type");
                DocumentMapperParser.checkNoRemainingFields(propName, multiFieldNodes, parserContext.indexVersionCreated());
            }
            return true;
        }
        return false;
    }

    private static IndexOptions nodeIndexOptionValue(Object propNode) {
        String value = propNode.toString();
        if (INDEX_OPTIONS_OFFSETS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
        }
        if (INDEX_OPTIONS_POSITIONS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        }
        if (INDEX_OPTIONS_FREQS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS_AND_FREQS;
        }
        if (INDEX_OPTIONS_DOCS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS;
        }
        throw new ElasticsearchParseException("failed to parse index option [{}]", value);
    }

    public static FormatDateTimeFormatter parseDateTimeFormatter(Object node) {
        return Joda.forPattern(node.toString());
    }

    public static void parseTermVector(String fieldName, String termVector, FieldMapper.Builder builder) throws MapperParsingException {
        if ("no".equals(termVector = Strings.toUnderscoreCase(termVector))) {
            builder.storeTermVectors(false);
        } else if ("yes".equals(termVector)) {
            builder.storeTermVectors(true);
        } else if ("with_offsets".equals(termVector)) {
            builder.storeTermVectorOffsets(true);
        } else if ("with_positions".equals(termVector)) {
            builder.storeTermVectorPositions(true);
        } else if ("with_positions_offsets".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorOffsets(true);
        } else if ("with_positions_payloads".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorPayloads(true);
        } else if ("with_positions_offsets_payloads".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorOffsets(true);
            builder.storeTermVectorPayloads(true);
        } else {
            throw new MapperParsingException("wrong value for termVector [" + termVector + "] for field [" + fieldName + "]");
        }
    }

    public static void parseIndex(String fieldName, String index, FieldMapper.Builder builder) throws MapperParsingException {
        if ("no".equals(index = Strings.toUnderscoreCase(index))) {
            builder.index(false);
        } else if ("not_analyzed".equals(index)) {
            builder.index(true);
            builder.tokenized(false);
        } else if ("analyzed".equals(index)) {
            builder.index(true);
            builder.tokenized(true);
        } else {
            throw new MapperParsingException("wrong value for index [" + index + "] for field [" + fieldName + "]");
        }
    }

    public static boolean parseStore(String fieldName, String store) throws MapperParsingException {
        if ("no".equals(store)) {
            return false;
        }
        if ("yes".equals(store)) {
            return true;
        }
        return XContentMapValues.nodeBooleanValue(store);
    }

    public static ContentPath.Type parsePathType(String name, String path) throws MapperParsingException {
        if ("just_name".equals(path = Strings.toUnderscoreCase(path))) {
            return ContentPath.Type.JUST_NAME;
        }
        if ("full".equals(path)) {
            return ContentPath.Type.FULL;
        }
        throw new MapperParsingException("wrong value for pathType [" + path + "] for object [" + name + "]");
    }

    public static void parseCopyFields(Object propNode, FieldMapper.Builder builder) {
        FieldMapper.CopyTo.Builder copyToBuilder = new FieldMapper.CopyTo.Builder();
        if (XContentMapValues.isArray(propNode)) {
            for (Object node : (List)propNode) {
                copyToBuilder.add(XContentMapValues.nodeStringValue(node, null));
            }
        } else {
            copyToBuilder.add(XContentMapValues.nodeStringValue(propNode, null));
        }
        builder.copyTo(copyToBuilder.build());
    }
}

