/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.node.settings.NodeSettingsService;

public class NodeModule
extends AbstractModule {
    private final Node node;
    Class<? extends PageCacheRecycler> pageCacheRecyclerImpl = PageCacheRecycler.class;
    Class<? extends BigArrays> bigArraysImpl = BigArrays.class;

    public NodeModule(Node node) {
        this.node = node;
    }

    @Override
    protected void configure() {
        if (this.pageCacheRecyclerImpl == PageCacheRecycler.class) {
            this.bind(PageCacheRecycler.class).asEagerSingleton();
        } else {
            this.bind(PageCacheRecycler.class).to(this.pageCacheRecyclerImpl).asEagerSingleton();
        }
        if (this.bigArraysImpl == BigArrays.class) {
            this.bind(BigArrays.class).asEagerSingleton();
        } else {
            this.bind(BigArrays.class).to(this.bigArraysImpl).asEagerSingleton();
        }
        this.bind(Node.class).toInstance(this.node);
        this.bind(NodeSettingsService.class).asEagerSingleton();
        this.bind(NodeService.class).asEagerSingleton();
    }
}

