/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.scilab.forge.jlatexmath.Box;

public class GraphicsBox
extends Box {
    public static final int BILINEAR = 0;
    public static final int NEAREST_NEIGHBOR = 1;
    public static final int BICUBIC = 2;
    private BufferedImage image;
    private float scl;
    private Object interp;

    public GraphicsBox(BufferedImage bufferedImage, float f, float f2, float f3, int n) {
        this.image = bufferedImage;
        this.width = f;
        this.height = f2;
        this.scl = 1.0f / f3;
        this.depth = 0.0f;
        this.shift = 0.0f;
        switch (n) {
            case 0: {
                this.interp = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
                break;
            }
            case 1: {
                this.interp = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                break;
            }
            case 2: {
                this.interp = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
                break;
            }
            default: {
                this.interp = null;
            }
        }
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        AffineTransform affineTransform = graphics2D.getTransform();
        Object object = null;
        if (this.interp != null) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interp);
        }
        graphics2D.translate(f, f2 - this.height);
        graphics2D.scale(this.scl, this.scl);
        graphics2D.drawImage((Image)this.image, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
        }
    }

    public int getLastFontId() {
        return 0;
    }
}

