/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.testng.IClass;
import org.testng.IModuleFactory;
import org.testng.ISuite;
import org.testng.ITest;
import org.testng.ITestContext;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.annotations.Guice;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.ClassHelper;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassImpl
implements IClass {
    private static final long serialVersionUID = 1118178273317520344L;
    private transient Class m_class = null;
    private transient Object m_defaultInstance = null;
    private XmlTest m_xmlTest = null;
    private transient IAnnotationFinder m_annotationFinder = null;
    private transient List<Object> m_instances = Lists.newArrayList();
    private transient Map<Class, IClass> m_classes = null;
    private int m_instanceCount;
    private long[] m_instanceHashCodes;
    private transient Object m_instance;
    private ITestObjectFactory m_objectFactory;
    private String m_testName = null;
    private XmlClass m_xmlClass;
    private ITestContext m_testContext;
    private final boolean m_hasParentModule;

    public ClassImpl(ITestContext context, Class cls, XmlClass xmlClass, Object instance, Map<Class, IClass> classes, XmlTest xmlTest, IAnnotationFinder annotationFinder, ITestObjectFactory objectFactory) {
        this.m_testContext = context;
        this.m_class = cls;
        this.m_classes = classes;
        this.m_xmlClass = xmlClass;
        this.m_xmlTest = xmlTest;
        this.m_annotationFinder = annotationFinder;
        this.m_instance = instance;
        this.m_objectFactory = objectFactory;
        if (instance instanceof ITest) {
            this.m_testName = ((ITest)instance).getTestName();
        }
        this.m_hasParentModule = Utils.isStringNotEmpty(this.m_testContext.getSuite().getParentModule());
    }

    private static void ppp(String s) {
        System.out.println("[ClassImpl] " + s);
    }

    @Override
    public String getTestName() {
        return this.m_testName;
    }

    @Override
    public String getName() {
        return this.m_class.getName();
    }

    @Override
    public Class getRealClass() {
        return this.m_class;
    }

    @Override
    public int getInstanceCount() {
        return this.m_instanceCount;
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.m_instanceHashCodes;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.m_xmlTest;
    }

    @Override
    public XmlClass getXmlClass() {
        return this.m_xmlClass;
    }

    private Object getDefaultInstance() {
        if (this.m_defaultInstance == null) {
            Object instance;
            this.m_defaultInstance = this.m_instance != null ? this.m_instance : ((instance = this.getInstanceFromGuice()) != null ? instance : ClassHelper.createInstance(this.m_class, this.m_classes, this.m_xmlTest, this.m_annotationFinder, this.m_objectFactory));
        }
        return this.m_defaultInstance;
    }

    private Object getInstanceFromGuice() {
        Annotation annotation = AnnotationHelper.findAnnotationSuperClasses(Guice.class, this.m_class);
        if (annotation == null) {
            return null;
        }
        Guice guice = (Guice)annotation;
        Injector parentInjector = this.getParentInjector();
        List<Module> moduleInstances = Lists.newArrayList(this.getModules(guice, parentInjector, this.m_class));
        Injector injector = this.m_testContext.getInjector(moduleInstances);
        if (injector == null) {
            injector = parentInjector.createChildInjector(moduleInstances);
            this.m_testContext.addInjector(moduleInstances, injector);
        }
        return injector.getInstance(this.m_class);
    }

    public Injector getParentInjector() {
        ISuite suite = this.m_testContext.getSuite();
        Injector injector = suite.getParentInjector();
        if (injector == null) {
            if (this.m_hasParentModule) {
                Class<?> parentModule = ClassHelper.forName(suite.getParentModule());
                if (parentModule == null) {
                    throw new TestNGException("Cannot load parent Guice module class: " + parentModule);
                }
                Module module = (Module)ClassHelper.newInstance(parentModule);
                injector = com.google.inject.Guice.createInjector((Module[])new Module[]{module});
            } else {
                injector = com.google.inject.Guice.createInjector((Module[])new Module[0]);
            }
            suite.setParentInjector(injector);
        }
        return injector;
    }

    private Module[] getModules(Guice guice, Injector parentInejctor, Class<?> testClass) {
        IModuleFactory factoryInstance;
        Module moduleClass;
        List result = Lists.newArrayList();
        for (Class<? extends Module> moduleClass2 : guice.modules()) {
            List<Module> modules = this.m_testContext.getGuiceModules(moduleClass2);
            if (modules != null && modules.size() > 0) {
                result.addAll(modules);
                continue;
            }
            Module instance = (Module)parentInejctor.getInstance(moduleClass2);
            result.add(instance);
            this.m_testContext.addGuiceModule(moduleClass2, instance);
        }
        Class<? extends IModuleFactory> factory = guice.moduleFactory();
        if (factory != IModuleFactory.class && (moduleClass = (factoryInstance = (IModuleFactory)parentInejctor.getInstance(factory)).createModule(this.m_testContext, testClass)) != null) {
            result.add(moduleClass);
        }
        return result.toArray(new Module[result.size()]);
    }

    @Override
    public Object[] getInstances(boolean create) {
        Object[] result = new Object[]{};
        if (this.m_xmlTest.isJUnit()) {
            if (create) {
                result = new Object[]{ClassHelper.createInstance(this.m_class, this.m_classes, this.m_xmlTest, this.m_annotationFinder, this.m_objectFactory)};
            }
        } else {
            result = new Object[]{this.getDefaultInstance()};
        }
        if (this.m_instances.size() > 0) {
            result = this.m_instances.toArray(new Object[this.m_instances.size()]);
        }
        this.m_instanceCount = this.m_instances.size();
        this.m_instanceHashCodes = new long[this.m_instanceCount];
        for (int i = 0; i < this.m_instanceCount; ++i) {
            this.m_instanceHashCodes[i] = this.m_instances.get(i).hashCode();
        }
        return result;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("class", this.m_class.getName()).toString();
    }

    @Override
    public void addInstance(Object instance) {
        this.m_instances.add(instance);
    }
}

