// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var ArgumentParser, Base, Command, add_option_dict, certs, env, log, version_info,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  Base = require('./base').Base;

  log = require('../log');

  ArgumentParser = require('argparse').ArgumentParser;

  add_option_dict = require('./argparse').add_option_dict;

  version_info = require('../version').version_info;

  certs = require('../ca').certs;

  env = require('../env').env;

  exports.Command = Command = (function(_super) {
    __extends(Command, _super);

    function Command() {
      return Command.__super__.constructor.apply(this, arguments);
    }

    Command.prototype.OPTS = {
      a: {
        alias: 'all',
        action: 'storeTrue',
        help: "list all possible certs in JSON form"
      }
    };

    Command.prototype.add_subcommand_parser = function(scp) {
      var name, opts, sub;
      opts = {
        help: "print out the CA cert the client uses to authorize HTTPS connections"
      };
      name = "cert";
      sub = scp.addParser(name, opts);
      add_option_dict(sub, this.OPTS);
      sub.addArgument(["host"], {
        nargs: '?',
        help: "which host to authorize"
      });
      return [name];
    };

    Command.prototype.run = function(cb) {
      var h;
      if (this.argv.all) {
        log.console.log(JSON.stringify(certs, null, "   "));
      } else {
        if ((h = this.argv.host) == null) {
          h = env().get_host();
          log.info("Cert for " + h + " ->");
        }
        log.console.log(certs[h]);
      }
      return cb(null);
    };

    return Command;

  })(Base);

}).call(this);
