// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var ArgumentParser, Base, Command, E, PackageJson, SERVICES, User, add_option_dict, env, format_fingerprint, iced, log, make_esc, req, session, util, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  Base = require('./base').Base;

  log = require('../log');

  ArgumentParser = require('argparse').ArgumentParser;

  add_option_dict = require('./argparse').add_option_dict;

  PackageJson = require('../package').PackageJson;

  session = require('../session').session;

  make_esc = require('iced-error').make_esc;

  env = require('../env').env;

  log = require('../log');

  User = require('../user').User;

  format_fingerprint = require('pgp-utils').util.format_fingerprint;

  util = require('util');

  E = require('../err').E;

  req = require('../req');

  SERVICES = ["github", "twitter", "reddit", "hackernews"];

  exports.Command = Command = (function(_super) {
    __extends(Command, _super);

    function Command() {
      return Command.__super__.constructor.apply(this, arguments);
    }

    Command.prototype.OPTS = {
      v: {
        alias: 'verbose',
        action: 'storeTrue',
        help: 'a full dump, with more gory details'
      },
      j: {
        alias: 'json',
        action: 'storeTrue',
        help: 'output in json format; default is simple text list'
      }
    };

    Command.prototype.use_session = function() {
      return true;
    };

    Command.prototype.needs_configuration = function() {
      return false;
    };

    Command.prototype.add_subcommand_parser = function(scp) {
      var name, opts, sub;
      opts = {
        help: "search all users",
        aliases: []
      };
      name = "search";
      sub = scp.addParser(name, opts);
      sub.addArgument(["query"], {
        nargs: 1,
        help: "a substring to find"
      });
      add_option_dict(sub, this.OPTS);
      return [name].concat(opts.aliases);
    };

    Command.prototype.search = function(cb) {
      var args, body, err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      args = {
        endpoint: "user/autocomplete",
        args: {
          q: this.argv.query[0]
        }
      };
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/command/search.iced",
            funcname: "Command.search"
          });
          req.get(args, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return body = arguments[1];
              };
            })(),
            lineno: 59
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, body);
        };
      })(this));
    };

    Command.prototype.reformat_results = function(list) {
      var c, entry, n, obj, ret, svc, v, _i, _j, _len, _len1, _ref, _ref1;
      ret = [];
      for (_i = 0, _len = list.length; _i < _len; _i++) {
        entry = list[_i];
        if (!((c = entry.components) != null)) {
          continue;
        }
        obj = {
          username: c.username.val,
          key: (_ref = c.key_fingerprint) != null ? _ref.val.replace(/\s+/g, "") : void 0
        };
        for (_j = 0, _len1 = SERVICES.length; _j < _len1; _j++) {
          svc = SERVICES[_j];
          if ((n = c[svc]) != null) {
            obj[svc] = n.val;
          }
        }
        if ((_ref1 = c.websites) != null ? _ref1.length : void 0) {
          obj.websites = (function() {
            var _k, _len2, _ref2, _results;
            _ref2 = c.websites;
            _results = [];
            for (_k = 0, _len2 = _ref2.length; _k < _len2; _k++) {
              v = _ref2[_k];
              _results.push("" + v.protocol + "//" + v.val);
            }
            return _results;
          })();
        }
        obj.score = entry.total_score;
        if (this.logged_in) {
          obj.is_followee = entry.is_followee;
        }
        ret.push(obj);
      }
      return ret;
    };

    Command.prototype.display = function(v) {
      if (this.argv.json) {
        return this.display_json(v);
      } else {
        return this.display_text(v);
      }
    };

    Command.prototype.display_text = function(v) {
      var fields, line, lines, n, rec, svc, tmp, _i, _j, _len, _len1;
      lines = [];
      for (_i = 0, _len = v.length; _i < _len; _i++) {
        rec = v[_i];
        fields = [];
        if (this.logged_in) {
          fields.push(rec.is_followee ? '*' : '-');
        }
        fields.push(rec.username, rec.key);
        for (_j = 0, _len1 = SERVICES.length; _j < _len1; _j++) {
          svc = SERVICES[_j];
          if ((n = rec[svc])) {
            fields.push("" + svc + ":" + n);
          }
        }
        if ((tmp = rec.websites) != null) {
          fields = fields.concat(tmp);
        }
        line = fields.join("\t");
        lines.push(line);
      }
      return lines.join("\n");
    };

    Command.prototype.display_json = function(v) {
      return JSON.stringify(v, null, "  ");
    };

    Command.prototype.run = function(cb) {
      var d, esc, list, v, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Command::run");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/command/search.iced",
            funcname: "Command.run"
          });
          _this.search(esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return list = arguments[0];
              };
            })(),
            lineno: 113
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if ((v = typeof list !== "undefined" && list !== null ? list.completions : void 0) && v.length) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/max/src/keybase/node-client/src/command/search.iced",
                  funcname: "Command.run"
                });
                session.load_and_check(esc(__iced_deferrals.defer({
                  assign_fn: (function(__slot_1) {
                    return function() {
                      return __slot_1.logged_in = arguments[0];
                    };
                  })(_this),
                  lineno: 115
                })));
                __iced_deferrals._fulfill();
              })(function() {
                return __iced_k(v = _this.reformat_results(v));
              });
            } else {
              return __iced_k(v = []);
            }
          })(function() {
            if ((d = _this.display(v)).length) {
              log.console.log(d);
            }
            return cb(null, (v.length === 0 ? 1 : 0));
          });
        };
      })(this));
    };

    return Command;

  })(Base);

}).call(this);
