// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var E, GPG, StatusParser, env, iced, log, util, __iced_k, __iced_k_noop;

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  GPG = require('gpg-wrapper').GPG;

  env = require('./env').env;

  log = require('./log');

  util = require('util');

  E = require('./err').E;

  exports.gpg = function(inargs, cb) {
    var err, gpg, out, ___iced_passed_deferral, __iced_deferrals, __iced_k;
    __iced_k = __iced_k_noop;
    ___iced_passed_deferral = iced.findDeferral(arguments);
    log.debug("| Call to gpg: " + (util.inspect(inargs)));
    if (inargs.quiet && env().get_debug()) {
      inargs.quiet = false;
    }
    gpg = new GPG;
    (function(_this) {
      return (function(__iced_k) {
        __iced_deferrals = new iced.Deferrals(__iced_k, {
          parent: ___iced_passed_deferral,
          filename: "/Users/max/src/keybase/node-client/src/gpg.iced",
          funcname: "gpg"
        });
        gpg.run(inargs, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              return out = arguments[1];
            };
          })(),
          lineno: 13
        }));
        __iced_deferrals._fulfill();
      });
    })(this)((function(_this) {
      return function() {
        return cb(err, out);
      };
    })(this));
  };

  exports.StatusParser = StatusParser = (function() {
    function StatusParser() {
      this._all = [];
      this._table = [];
    }

    StatusParser.prototype.parse = function(_arg) {
      var buf, line, lines, words, _i, _len;
      buf = _arg.buf;
      lines = buf.toString('utf8').split(/\r?\n/);
      for (_i = 0, _len = lines.length; _i < _len; _i++) {
        line = lines[_i];
        words = line.split(/\s+/);
        if (words[0] === '[GNUPG:]') {
          this._all.push(words.slice(1));
          this._table[words[1]] = words.slice(2);
        }
      }
      return this;
    };

    StatusParser.prototype.lookup = function(key) {
      return this._table[key];
    };

    return StatusParser;

  })();

  exports.parse_signature = function(buf) {
    var d, err, key, status_parser, timestamp, validsig;
    status_parser = (new StatusParser()).parse({
      buf: buf
    });
    err = key = timestamp = null;
    d = null;
    if ((validsig = status_parser.lookup("VALIDSIG")) == null) {
      err = new E.NotFoundError("no valid signature found");
    } else if (validsig.length < 9 || isNaN(d = parseInt(validsig[2]))) {
      err = new E.VerifyError("didn't find a valid signature");
    } else {
      if (validsig.length === 10) {
        key = {
          primary: validsig[9],
          subkey: validsig[0]
        };
      } else {
        key = {
          primary: validsig[0]
        };
      }
      timestamp = new Date(d * 1000);
    }
    return [err, key, timestamp];
  };

}).call(this);
