// Generated by IcedCoffeeScript 1.8.0-d
(function() {
  var Base, GenericBinding, SHA256, Verifier, WordArray, add_ids, akatch, base64_extract, base64u, bufeq_secure, cieq, constants, hash_sig, iced, json_stringify_sorted, katch, kbpgp, make_esc, make_ids, pgp_utils, proof_text_check_to_med_id, proof_type_to_string, sig_id_to_med_id, sig_id_to_short_id, streq_secure, trim, triplesec, unix_time, util, __iced_k, __iced_k_noop, _ref, _ref1,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; },
    __slice = [].slice,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime');
  __iced_k = __iced_k_noop = function() {};

  _ref = require('./constants'), proof_type_to_string = _ref.proof_type_to_string, constants = _ref.constants;

  pgp_utils = require('pgp-utils');

  _ref1 = pgp_utils.util, trim = _ref1.trim, katch = _ref1.katch, akatch = _ref1.akatch, bufeq_secure = _ref1.bufeq_secure, json_stringify_sorted = _ref1.json_stringify_sorted, unix_time = _ref1.unix_time, base64u = _ref1.base64u, streq_secure = _ref1.streq_secure;

  triplesec = require('triplesec');

  WordArray = triplesec.WordArray;

  SHA256 = triplesec.hash.SHA256;

  kbpgp = require('kbpgp');

  make_esc = require('iced-error').make_esc;

  util = require('util');

  base64_extract = require('./b64extract').base64_extract;

  exports.hash_sig = hash_sig = function(sig_body) {
    return (new SHA256).bufhash(sig_body);
  };

  add_ids = function(sig_body, out) {
    var hash, id, short_id;
    hash = hash_sig(sig_body);
    id = hash.toString('hex');
    short_id = sig_id_to_short_id(hash);
    out.id = id;
    out.med_id = sig_id_to_med_id(hash);
    return out.short_id = short_id;
  };

  make_ids = function(sig_body) {
    var out;
    out = {};
    add_ids(sig_body, out);
    return out;
  };

  sig_id_to_med_id = function(sig_id) {
    return base64u.encode(sig_id);
  };

  sig_id_to_short_id = function(sig_id) {
    return base64u.encode(sig_id.slice(0, constants.short_id_bytes));
  };

  proof_text_check_to_med_id = function(proof_text_check) {
    var med_id;
    med_id = make_ids(new Buffer(proof_text_check, 'base64')).med_id;
    return med_id;
  };

  exports.cieq = cieq = function(a, b) {
    return (a != null) && (b != null) && (a.toLowerCase() === b.toLowerCase());
  };

  Verifier = (function() {
    function Verifier(_arg, sig_eng, base) {
      this.armored = _arg.armored, this.id = _arg.id, this.short_id = _arg.short_id, this.skip_ids = _arg.skip_ids, this.make_ids = _arg.make_ids, this.strict = _arg.strict;
      this.sig_eng = sig_eng;
      this.base = base;
    }

    Verifier.prototype.km = function() {
      return this.sig_eng.get_km();
    };

    Verifier.prototype.get_etime = function() {
      if ((this.json.ctime != null) && this.json.expire_in) {
        return this.json.ctime + this.json.expire_in;
      } else {
        return null;
      }
    };

    Verifier.prototype.verify = function(cb) {
      var esc, json_obj, json_str, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Verifier::verfiy");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/proofs/src/base.iced",
            funcname: "Verifier.verify"
          });
          _this._parse_and_process(esc(__iced_deferrals.defer({
            lineno: 72
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/proofs/src/base.iced",
              funcname: "Verifier.verify"
            });
            _this._check_json(esc(__iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  json_obj = arguments[0];
                  return json_str = arguments[1];
                };
              })(),
              lineno: 73
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/proofs/src/base.iced",
                funcname: "Verifier.verify"
              });
              _this._check_expired(esc(__iced_deferrals.defer({
                lineno: 74
              })));
              __iced_deferrals._fulfill();
            })(function() {
              return cb(null, json_obj, json_str);
            });
          });
        };
      })(this));
    };

    Verifier.prototype._check_ids = function(body, cb) {
      var err, id, short_id, _ref2;
      _ref2 = make_ids(body), short_id = _ref2.short_id, id = _ref2.id;
      err = !((this.id != null) && streq_secure(id, this.id)) ? new Error("Long IDs aren't equal; wanted " + id + " but got " + this.id) : !((this.short_id != null) && streq_secure(short_id, this.short_id)) ? new Error("Short IDs aren't equal: wanted " + short_id + " but got " + this.short_id) : null;
      return cb(err);
    };

    Verifier.prototype._check_expired = function(cb) {
      var err, expired, now;
      err = null;
      now = unix_time();
      if (this.json.ctime == null) {
        err = new Error("No `ctime` in signature");
      } else if (this.json.expire_in == null) {
        err = new Error("No `expire_in` in signature");
      } else if (!this.json.expire_in) {
        this.etime = null;
      } else if ((expired = now - this.json.ctime - this.json.expire_in) > 0) {
        err = new Error("Expired " + expired + "s ago");
      } else {
        this.etime = this.json.ctime + this.json.expire_in;
      }
      return cb(err);
    };

    Verifier.prototype._parse_and_process = function(cb) {
      var body, err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/proofs/src/base.iced",
            funcname: "Verifier._parse_and_process"
          });
          _this.sig_eng.unbox(_this.armored, __iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                __slot_1.payload = arguments[1];
                return body = arguments[2];
              };
            })(_this),
            lineno: 106
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if ((err == null) && !_this.skip_ids) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/proofs/src/base.iced",
                  funcname: "Verifier._parse_and_process"
                });
                _this._check_ids(body, __iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return err = arguments[0];
                    };
                  })(),
                  lineno: 108
                }));
                __iced_deferrals._fulfill();
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            var _ref2;
            if ((err == null) && _this.make_ids) {
              _ref2 = make_ids(body), _this.short_id = _ref2.short_id, _this.id = _ref2.id;
            }
            return cb(err);
          });
        };
      })(this));
    };

    Verifier.prototype._check_json = function(cb) {
      var e, err, json_str_buf, json_str_utf8, json_str_utf8_trimmed, ours, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      json_str_buf = this.payload;
      json_str_utf8 = json_str_buf.toString('utf8');
      json_str_utf8_trimmed = trim(json_str_utf8);
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          var _ref2;
          if (!/^[\x20-\x7e]+$/.test(json_str_utf8_trimmed)) {
            return __iced_k(err = new Error("All JSON proof characters must be in the visible ASCII set (properly escaped UTF8 is permissible)"));
          } else {
            _ref2 = katch((function() {
              return JSON.parse(json_str_buf);
            })), e = _ref2[0], _this.json = _ref2[1];
            if (e != null) {
              err = new Error("Couldn't parse JSON signed message: " + e.message);
            }
            (function(__iced_k) {
              if (err == null) {
                (function(__iced_k) {
                  if (_this.strict && ((ours = trim(json_stringify_sorted(_this.json))) !== json_str_utf8_trimmed)) {
                    return __iced_k(err = new Error("non-canonlical JSON found in strict mode (" + ours + " v " + json_str_utf8_trimmed + ")"));
                  } else {
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/Users/max/src/keybase/proofs/src/base.iced",
                        funcname: "Verifier._check_json"
                      });
                      _this.base._v_check({
                        json: _this.json
                      }, __iced_deferrals.defer({
                        assign_fn: (function() {
                          return function() {
                            return err = arguments[0];
                          };
                        })(),
                        lineno: 132
                      }));
                      __iced_deferrals._fulfill();
                    })(__iced_k);
                  }
                })(__iced_k);
              } else {
                return __iced_k();
              }
            })(__iced_k);
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, _this.json, json_str_utf8);
        };
      })(this));
    };

    return Verifier;

  })();

  Base = (function() {
    function Base(_arg) {
      this.sig_eng = _arg.sig_eng, this.seqno = _arg.seqno, this.user = _arg.user, this.host = _arg.host, this.prev = _arg.prev, this.client = _arg.client, this.merkle_root = _arg.merkle_root, this.revoke = _arg.revoke, this.seq_type = _arg.seq_type, this.eldest_kid = _arg.eldest_kid, this.expire_in = _arg.expire_in, this.ctime = _arg.ctime;
    }

    Base.prototype.proof_type_str = function() {
      var t;
      if ((t = this.proof_type()) != null) {
        return proof_type_to_string[t];
      } else {
        return null;
      }
    };

    Base.prototype._v_check_key = function(key) {
      var checks, err;
      checks = 0;
      if ((key != null ? key.kid : void 0) != null) {
        checks++;
        err = this._v_check_kid(key.kid);
      }
      if ((err == null) && ((key != null ? key.fingerprint : void 0) != null)) {
        checks++;
        err = this._v_check_fingerprint(key);
      }
      if ((err == null) && checks === 0) {
        err = new Error("need either a 'body.key.kid' or a 'body.key.fingerprint'");
      }
      return err;
    };

    Base.prototype._v_check_kid = function(kid) {
      var a, err;
      if (!bufeq_secure((a = this.km().get_ekid()), new Buffer(kid, "hex"))) {
        return err = new Error("Verification key doesn't match packet (via kid): " + (a.toString('hex')) + " != " + kid);
      } else {
        return null;
      }
    };

    Base.prototype._v_check_fingerprint = function(key) {
      var a, fp, key_id;
      if ((key_id = key != null ? key.key_id : void 0) == null) {
        return new Error("Needed a body.key.key_id but none given");
      } else if (!bufeq_secure((a = this.km().get_pgp_key_id()), new Buffer(key_id, "hex"))) {
        return new Error("Verification key doesn't match packet (via key ID): " + (a.toString('hex')) + " != " + key_id);
      } else if ((fp = key != null ? key.fingerprint : void 0) == null) {
        return new Error("Needed a body.key.fingerprint but none given");
      } else if (!bufeq_secure(this.km().get_pgp_fingerprint(), new Buffer(fp, "hex"))) {
        return new Error("Verifiation key doesn't match packet (via fingerprint)");
      } else {
        return null;
      }
    };

    Base.prototype._v_include_pgp_details = function() {
      return false;
    };

    Base.prototype._v_require_pgp_details = function() {
      return false;
    };

    Base.prototype._v_pgp_details_dest = function(body) {
      return body.key;
    };

    Base.prototype._v_pgp_km = function() {
      return null;
    };

    Base.prototype.full_pgp_hash = function(opts, cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          if (_this._full_pgp_hash === void 0) {
            esc = make_esc(cb);
            (function(__iced_k) {
              var _ref2;
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/proofs/src/base.iced",
                funcname: "Base.full_pgp_hash"
              });
              if ((_ref2 = _this._v_pgp_km()) != null) {
                _ref2.pgp_full_hash({}, esc(__iced_deferrals.defer({
                  assign_fn: (function(__slot_1) {
                    return function() {
                      return __slot_1._full_pgp_hash = arguments[0];
                    };
                  })(_this),
                  lineno: 204
                })));
              }
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(null, _this._full_pgp_hash);
        };
      })(this));
    };

    Base.prototype._add_pgp_details = function(_arg, cb) {
      var body, dest, err, full_hash, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      body = _arg.body;
      if (!this._v_include_pgp_details()) {
        return cb(null);
      }
      dest = this._v_pgp_details_dest(body);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/proofs/src/base.iced",
            funcname: "Base._add_pgp_details"
          });
          _this.full_pgp_hash({}, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return full_hash = arguments[1];
              };
            })(),
            lineno: 213
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (err) {

          } else if (typeof full_hash !== "undefined" && full_hash !== null) {
            dest.full_hash = full_hash;
            if (dest.fingerprint == null) {
              dest.fingerprint = _this._v_pgp_km().get_pgp_fingerprint().toString('hex');
            }
          } else if (_this._v_require_pgp_details()) {
            err = new Error("" + (_this.proof_type_str()) + " proofs require a PGP key");
          }
          return cb(err);
        };
      })(this));
    };

    Base.prototype._check_pgp_details = function(_arg, cb) {
      var details, err, fp_in, fp_real, hash_in, hash_real, json, kid_in, kid_real, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      json = _arg.json;
      err = null;
      details = this._v_pgp_details_dest(json.body);
      (function(_this) {
        return (function(__iced_k) {
          if (((hash_in = details != null ? details.full_hash : void 0) == null) || ((fp_in = details != null ? details.fingerprint : void 0) == null) || ((kid_in = details != null ? details.kid : void 0) == null)) {
            return __iced_k(_this._v_require_pgp_details() ? err = new Error("" + (_this.proof_type_str()) + " proofs require a PGP key's KID, fingerprint, and full_hash but one or more were missing.") : void 0);
          } else {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/proofs/src/base.iced",
                funcname: "Base._check_pgp_details"
              });
              _this.full_pgp_hash({}, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return hash_real = arguments[1];
                  };
                })(),
                lineno: 231
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(err != null ? void 0 : typeof hash_real === "undefined" || hash_real === null ? err = new Error("A PGP key hash (" + hash_in + ") was in the sig body but no key was provided") : hash_in !== hash_real ? err = new Error("New PGP key's hash (" + hash_real + ") doesn't match hash in signature (" + hash_in + ")") : fp_in !== (fp_real = _this._v_pgp_km().get_pgp_fingerprint().toString('hex')) ? err = new Error("New PGP key's fingerprint (" + fp_real + ") doesn't match fingerprint in signature (" + fp_in + ")") : kid_in !== (kid_real = _this._v_pgp_km().get_ekid().toString('hex')) ? err = new Error("New PGP key's KID (" + kid_real + ") doesn't match KID in signature (" + kid_in + ")") : void 0);
            });
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    Base.prototype._v_check = function(_arg, cb) {
      var a, b, err, json, key, section_error, seq_type, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref2, _ref3, _ref4, _ref5, _ref6, _ref7, _ref8, _ref9;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      json = _arg.json;
      seq_type = function(v) {
        if (v != null) {
          return v;
        } else {
          return constants.seq_types.PUBLIC;
        }
      };
      err = !cieq((a = json != null ? (_ref2 = json.body) != null ? (_ref3 = _ref2.key) != null ? _ref3.username : void 0 : void 0 : void 0), (b = this.user.local.username)) ? new Error("Wrong local user: got '" + a + "' but wanted '" + b + "'") : (a = json != null ? (_ref4 = json.body) != null ? (_ref5 = _ref4.key) != null ? _ref5.uid : void 0 : void 0 : void 0) !== (b = this.user.local.uid) ? new Error("Wrong local uid: got '" + a + "' but wanted '" + b + "'") : !cieq((a = json != null ? (_ref6 = json.body) != null ? (_ref7 = _ref6.key) != null ? _ref7.host : void 0 : void 0 : void 0), (b = this.host)) ? new Error("Wrong host: got '" + a + "' but wanted '" + b + "'") : ((a = this._type()) != null) && ((b = json != null ? (_ref8 = json.body) != null ? _ref8.type : void 0 : void 0) !== a) ? new Error("Wrong signature type; got '" + a + "' but wanted '" + b + "'") : (a = this.prev) && (a !== (b = json != null ? json.prev : void 0)) ? new Error("Wrong previous hash; wanted '" + a + "' but got '" + b + "'") : (a = this.seqno) && (a !== (b = json != null ? json.seqno : void 0)) ? new Error("Wrong seqno; wanted '" + a + "' but got '" + b) : this.seqno && (a = seq_type(json != null ? json.seq_type : void 0)) !== (b = seq_type(this.seq_type)) ? new Error("Wrong seq_type: wanted '" + a + "' but got '" + b + "'") : (key = json != null ? (_ref9 = json.body) != null ? _ref9.key : void 0 : void 0) == null ? new Error("no 'body.key' block in signature") : (section_error = this._check_sections(json)) != null ? section_error : this._v_check_key(key);
      (function(_this) {
        return (function(__iced_k) {
          if (err == null) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/proofs/src/base.iced",
                funcname: "Base._v_check"
              });
              _this._check_pgp_details({
                json: json
              }, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 276
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    Base.prototype._required_sections = function() {
      return ["key", "type", "version"];
    };

    Base.prototype._optional_sections = function() {
      return ["client", "merkle_root"];
    };

    Base.prototype._is_wildcard_link = function() {
      return false;
    };

    Base.prototype._check_sections = function(json) {
      var section, _, _i, _len, _ref2, _ref3, _ref4;
      _ref2 = this._required_sections();
      for (_i = 0, _len = _ref2.length; _i < _len; _i++) {
        section = _ref2[_i];
        if (!(json != null ? (_ref3 = json.body) != null ? _ref3[section] : void 0 : void 0)) {
          return new Error("Missing '" + section + "' section " + (json.seqno != null ? "in seqno " + json.seqno : "") + ", required for " + json.body.type + " signatures");
        }
      }
      if (!this._is_wildcard_link()) {
        _ref4 = json != null ? json.body : void 0;
        for (section in _ref4) {
          _ = _ref4[section];
          if (!((__indexOf.call(this._required_sections(), section) >= 0) || (__indexOf.call(this._optional_sections(), section) >= 0))) {
            return new Error("'" + section + "' section " + (json.seqno != null ? "in seqno " + json.seqno : "") + " is not allowed for " + json.body.type + " signatures");
          }
        }
      }
      return null;
    };

    Base.prototype.is_remote_proof = function() {
      return false;
    };

    Base.prototype.has_revoke = function() {
      var _ref2, _ref3;
      if (this.revoke == null) {
        return false;
      } else if (this.revoke.sig_id != null) {
        return true;
      } else if (((_ref2 = this.revoke.sig_ids) != null ? _ref2.length : void 0) > 0) {
        return true;
      } else if (this.revoke.kid != null) {
        return true;
      } else if (((_ref3 = this.revoke.kids) != null ? _ref3.length : void 0) > 0) {
        return true;
      } else {
        return false;
      }
    };

    Base.prototype._v_customize_json = function(ret) {};

    Base.prototype.generate_json = function(_arg, cb) {
      var ctime, ekid, err, expire_in, fp, pick, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      expire_in = (_arg != null ? _arg : {}).expire_in;
      err = null;
      ctime = this.ctime != null ? this.ctime : (this.ctime = unix_time());
      pick = function() {
        var e, v, _i, _len;
        v = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
        for (_i = 0, _len = v.length; _i < _len; _i++) {
          e = v[_i];
          if (e != null) {
            return e;
          }
        }
        return null;
      };
      ret = {
        seqno: this.seqno,
        prev: this.prev,
        ctime: ctime,
        tag: constants.tags.sig,
        expire_in: pick(expire_in, this.expire_in, constants.expire_in),
        body: {
          version: constants.versions.sig,
          type: this._type(),
          key: {
            host: this.host,
            username: this.user.local.username,
            uid: this.user.local.uid
          }
        }
      };
      if ((ekid = this.km().get_ekid()) != null) {
        ret.body.key.kid = ekid.toString('hex');
      }
      if ((fp = this.km().get_pgp_fingerprint()) != null) {
        ret.body.key.fingerprint = fp.toString('hex');
        ret.body.key.key_id = this.km().get_pgp_key_id().toString('hex');
      }
      if (this.eldest_kid != null) {
        ret.body.key.eldest_kid = this.eldest_kid;
      }
      if (this.seq_type != null) {
        ret.seq_type = this.seq_type;
      }
      if (this.client != null) {
        ret.body.client = this.client;
      }
      if (this.merkle_root != null) {
        ret.body.merkle_root = this.merkle_root;
      }
      if (this.has_revoke()) {
        ret.body.revoke = this.revoke;
      }
      this._v_customize_json(ret);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/proofs/src/base.iced",
            funcname: "Base.generate_json"
          });
          _this._add_pgp_details({
            body: ret.body
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 378
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, json_stringify_sorted(ret));
        };
      })(this));
    };

    Base.prototype._v_generate = function(opts, cb) {
      return cb(null);
    };

    Base.prototype.generate = function(cb) {
      var armored, esc, id, json, out, pgp, raw, short_id, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "generate");
      out = null;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/proofs/src/base.iced",
            funcname: "Base.generate"
          });
          _this._v_generate({}, esc(__iced_deferrals.defer({
            lineno: 391
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/proofs/src/base.iced",
              funcname: "Base.generate"
            });
            _this.generate_json({}, esc(__iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  return json = arguments[0];
                };
              })(),
              lineno: 392
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/proofs/src/base.iced",
                funcname: "Base.generate"
              });
              _this.sig_eng.box(json, esc(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    pgp = arguments[0].pgp;
                    raw = arguments[0].raw;
                    return armored = arguments[0].armored;
                  };
                })(),
                lineno: 393
              })));
              __iced_deferrals._fulfill();
            })(function() {
              var _ref2;
              _ref2 = make_ids(raw), short_id = _ref2.short_id, id = _ref2.id;
              out = {
                pgp: pgp,
                json: json,
                id: id,
                short_id: short_id,
                raw: raw,
                armored: armored
              };
              return cb(null, out);
            });
          });
        };
      })(this));
    };

    Base.prototype.verify = function(obj, cb) {
      var err, id, json_obj, json_str, out, short_id, verifier, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      verifier = new Verifier(obj, this.sig_eng, this);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/proofs/src/base.iced",
            funcname: "Base.verify"
          });
          verifier.verify(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                json_obj = arguments[1];
                return json_str = arguments[2];
              };
            })(),
            lineno: 409
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          id = short_id = null;
          if (obj.make_ids) {
            id = obj.id = verifier.id;
            short_id = obj.short_id = verifier.short_id;
          }
          out = typeof err !== "undefined" && err !== null ? {} : {
            json_obj: json_obj,
            json_str: json_str,
            id: id,
            short_id: short_id,
            etime: verifier.get_etime(),
            reverse_sig_kid: _this.reverse_sig_kid
          };
          return cb(err, out);
        };
      })(this));
    };

    Base.prototype.km = function() {
      return this.sig_eng.get_km();
    };

    Base.prototype.check_inputs = function() {
      return null;
    };

    Base.prototype.check_existing = function() {
      return null;
    };

    Base.prototype.is_short = function() {
      return false;
    };

    Base.prototype.sanity_check_proof_text = function(_arg, cb) {
      var args, b, b64s, check_for, err, len_floor, msg, proof_text, s, slack, _i, _len, _ref2;
      args = _arg.args, proof_text = _arg.proof_text;
      if (this.is_short()) {
        check_for = args.sig_id_short;
        len_floor = constants.short_id_bytes;
        slack = 3;
      } else {
        _ref2 = kbpgp.ukm.decode_sig({
          armored: args.sig
        }), err = _ref2[0], msg = _ref2[1];
        if ((err == null) && (msg.type !== kbpgp["const"].openpgp.message_types.generic)) {
          err = new Error("wrong message type; expected a generic message; got " + msg.type);
        }
        if (err == null) {
          check_for = msg.body.toString('base64');
          len_floor = constants.shortest_pgp_signature;
          slack = 30;
        }
      }
      if (err == null) {
        b64s = base64_extract(proof_text);
        for (_i = 0, _len = b64s.length; _i < _len; _i++) {
          b = b64s[_i];
          if (b.length >= len_floor) {
            if (b.indexOf(check_for) < 0 || (s = b.length - check_for.length) > slack) {
              err = new Error("Found a bad signature in proof text: " + b.slice(0, 60) + " != " + check_for.slice(0, 60) + " (slack=" + s + ")");
              break;
            }
          }
        }
      }
      return cb(err);
    };

    return Base;

  })();

  GenericBinding = (function(_super) {
    __extends(GenericBinding, _super);

    function GenericBinding() {
      return GenericBinding.__super__.constructor.apply(this, arguments);
    }

    GenericBinding.prototype._type = function() {
      return null;
    };

    GenericBinding.prototype.resource_id = function() {
      return "";
    };

    GenericBinding.prototype._service_obj_check = function() {
      return true;
    };

    GenericBinding.prototype._is_wildcard_link = function() {
      return true;
    };

    return GenericBinding;

  })(Base);

  exports.Base = Base;

  exports.GenericBinding = GenericBinding;

  exports.sig_id_to_short_id = sig_id_to_short_id;

  exports.sig_id_to_med_id = sig_id_to_med_id;

  exports.make_ids = make_ids;

  exports.add_ids = add_ids;

  exports.proof_text_check_to_med_id = proof_text_check_to_med_id;

}).call(this);
