/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.Plugin;
import org.zaproxy.zap.control.CoreFunctionality;
import org.zaproxy.zap.control.ExtensionFactory;

public class PluginFactory {
    private static Logger log = Logger.getLogger(PluginFactory.class);
    private static List<AbstractPlugin> loadedPlugins = null;
    private List<Plugin> listAllPlugin = new ArrayList<Plugin>();
    private LinkedHashMap<Integer, Plugin> mapAllPlugin = new LinkedHashMap();
    private LinkedHashMap<String, Plugin> mapAllPluginOrderCodeName = new LinkedHashMap();
    private List<Plugin> listPending = new ArrayList<Plugin>();
    private List<Plugin> listRunning = new ArrayList<Plugin>();
    private List<Plugin> listCompleted = new ArrayList<Plugin>();
    private int totalPluginToRun = 0;
    private boolean init = false;
    private Configuration config = new HierarchicalConfiguration();
    private static final Comparator<AbstractPlugin> riskComparator = new Comparator<AbstractPlugin>(){

        @Override
        public int compare(AbstractPlugin abstractPlugin, AbstractPlugin abstractPlugin2) {
            if (abstractPlugin.getStatus().ordinal() > abstractPlugin2.getStatus().ordinal()) {
                return -1;
            }
            if (abstractPlugin.getStatus().ordinal() < abstractPlugin2.getStatus().ordinal()) {
                return 1;
            }
            if (abstractPlugin.getRisk() > abstractPlugin2.getRisk()) {
                return -1;
            }
            if (abstractPlugin.getRisk() < abstractPlugin2.getRisk()) {
                return 1;
            }
            if (abstractPlugin.getId() < abstractPlugin2.getId()) {
                return -1;
            }
            if (abstractPlugin.getId() > abstractPlugin2.getId()) {
                return 1;
            }
            return 0;
        }
    };

    private static List<AbstractPlugin> getLoadedPlugins() {
        if (loadedPlugins == null) {
            loadedPlugins = new ArrayList<AbstractPlugin>(CoreFunctionality.getBuiltInActiveScanRules());
            loadedPlugins.addAll(ExtensionFactory.getAddOnLoader().getActiveScanRules());
            Collections.sort(loadedPlugins, riskComparator);
        }
        return loadedPlugins;
    }

    public static void loadedPlugin(AbstractPlugin abstractPlugin) {
        PluginFactory.getLoadedPlugins().add(abstractPlugin);
        Collections.sort(loadedPlugins, riskComparator);
    }

    public static boolean loadedPlugin(String string) {
        try {
            Class<?> clazz = ExtensionFactory.getAddOnLoader().loadClass(string);
            PluginFactory.loadedPlugin((AbstractPlugin)clazz.newInstance());
            return true;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public static void unloadedPlugin(AbstractPlugin abstractPlugin) {
        PluginFactory.getLoadedPlugins().remove(abstractPlugin);
    }

    public static boolean unloadedPlugin(String string) {
        if (loadedPlugins == null) {
            return true;
        }
        for (AbstractPlugin abstractPlugin : loadedPlugins) {
            if (!abstractPlugin.getClass().getName().equals(string)) continue;
            loadedPlugins.remove(abstractPlugin);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        LinkedHashMap<Integer, Plugin> linkedHashMap = this.mapAllPlugin;
        synchronized (linkedHashMap) {
            this.listPending.clear();
            this.listRunning.clear();
            this.listCompleted.clear();
            for (Plugin plugin : this.mapAllPlugin.values()) {
                if (!plugin.isEnabled()) continue;
                this.enableDependency(plugin);
            }
            for (Plugin plugin : this.mapAllPlugin.values()) {
                if (!plugin.isEnabled()) continue;
                this.listPending.add(plugin);
            }
            this.totalPluginToRun = this.listPending.size();
        }
        this.init = true;
    }

    private void enableDependency(Plugin plugin) {
        String[] stringArray = plugin.getDependency();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>(stringArray.length);
        if (this.addAllDependencies(plugin, arrayList)) {
            for (Plugin plugin2 : arrayList) {
                if (plugin2.isEnabled()) continue;
                plugin2.setEnabled(true);
            }
        } else {
            plugin.setEnabled(false);
            plugin.setAlertThreshold(Plugin.AlertThreshold.OFF);
            log.warn((Object)("Disabled scanner '" + plugin.getName() + "' because of unfulfilled dependencies."));
        }
    }

    public boolean hasAllDependenciesAvailable(Plugin plugin) {
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        return this.addAllDependencies(plugin, arrayList);
    }

    public boolean addAllDependencies(Plugin plugin, List<Plugin> list) {
        String[] stringArray = plugin.getDependency();
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        for (String string : arrayList) {
            Plugin plugin2 = this.mapAllPluginOrderCodeName.get(string);
            if (plugin2 == null) {
                bl = false;
                continue;
            }
            if (list.contains(plugin2)) continue;
            list.add(plugin2);
            bl &= this.addAllDependencies(plugin2, list);
        }
        return bl;
    }

    public List<Plugin> getDependentPlugins(Plugin plugin) {
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        this.addDependentPlugins(plugin.getCodeName(), arrayList);
        return arrayList;
    }

    private void addDependentPlugins(String string, List<Plugin> list) {
        for (Plugin plugin : this.listAllPlugin) {
            String[] stringArray = plugin.getDependency();
            if (stringArray == null || stringArray.length == 0 || !Arrays.asList(stringArray).contains(string) || list.contains(plugin)) continue;
            list.add(plugin);
            this.addDependentPlugins(plugin.getCodeName(), list);
        }
    }

    public List<Plugin> getDependencies(Plugin plugin) {
        String[] stringArray = plugin.getDependency();
        if (stringArray == null || stringArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        ArrayList<Plugin> arrayList2 = new ArrayList<Plugin>(arrayList.size());
        for (String string : arrayList) {
            Plugin plugin2 = this.mapAllPluginOrderCodeName.get(string);
            if (plugin2 == null) continue;
            arrayList2.add(plugin2);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadAllPlugin(Configuration configuration) {
        log.debug((Object)"loadAllPlugin");
        this.config = configuration;
        LinkedHashMap<Integer, Plugin> linkedHashMap = this.mapAllPlugin;
        synchronized (linkedHashMap) {
            this.mapAllPlugin.clear();
            this.listAllPlugin.clear();
            this.mapAllPluginOrderCodeName.clear();
            for (int i = 0; i < PluginFactory.getLoadedPlugins().size(); ++i) {
                try {
                    Plugin plugin = PluginFactory.getLoadedPlugins().get(i);
                    plugin.setConfig(configuration);
                    plugin.createParamIfNotExist();
                    if (!plugin.isVisible()) {
                        log.info((Object)("Plugin " + plugin.getName() + " not visible"));
                        continue;
                    }
                    if (plugin.isDepreciated()) {
                        log.info((Object)("Plugin " + plugin.getName() + " depricated"));
                        continue;
                    }
                    log.info((Object)("loaded plugin " + plugin.getName()));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Theshold=" + plugin.getAlertThreshold().name() + " Strength=" + plugin.getAttackStrength().toString()));
                    }
                    if (!PluginFactory.canAddPlugin(this.mapAllPlugin, plugin)) continue;
                    this.mapAllPlugin.put(plugin.getId(), plugin);
                    this.mapAllPluginOrderCodeName.put(plugin.getCodeName(), plugin);
                    continue;
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            Iterator<Plugin> iterator = this.mapAllPlugin.values().iterator();
            while (iterator.hasNext()) {
                this.listAllPlugin.add(iterator.next());
            }
        }
    }

    private static boolean canAddPlugin(Map<Integer, Plugin> map, Plugin plugin) {
        Plugin plugin2 = map.get(plugin.getId());
        if (plugin2 == null) {
            return true;
        }
        if (plugin2.getName().equals(plugin.getName())) {
            if (plugin2.getStatus().compareTo(plugin.getStatus()) > 0) {
                log.info((Object)("Ignoring (apparently) less stable scanner version, id=" + plugin.getId() + ", ExistingPlugin[Status=" + (Object)((Object)plugin2.getStatus()) + ", Class=" + plugin2.getClass().getCanonicalName() + "], LessStablePlugin[Status=" + (Object)((Object)plugin.getStatus()) + ", Class=" + plugin.getClass().getCanonicalName() + "]"));
                return false;
            }
            if (plugin2.getStatus() != plugin.getStatus()) {
                log.info((Object)("Replacing existing scanner with (apparently) stabler version, id=" + plugin.getId() + ", ExistingPlugin[Status=" + (Object)((Object)plugin2.getStatus()) + ", Class=" + plugin2.getClass().getCanonicalName() + "], StablerPlugin[Status=" + (Object)((Object)plugin.getStatus()) + ", Class=" + plugin.getClass().getCanonicalName() + "]"));
                return true;
            }
        }
        log.error((Object)("Duplicate id " + plugin.getId() + " " + plugin.getClass().getCanonicalName() + " " + plugin2.getClass().getCanonicalName()));
        return true;
    }

    public synchronized void loadFrom(PluginFactory pluginFactory) {
        log.debug((Object)("loadFrom " + pluginFactory.listAllPlugin.size()));
        for (Plugin plugin : pluginFactory.listAllPlugin) {
            Plugin plugin2 = this.mapAllPlugin.get(plugin.getId());
            if (plugin2 == null) continue;
            plugin.cloneInto(plugin2);
        }
    }

    public List<Plugin> getAllPlugin() {
        return this.listAllPlugin;
    }

    public PluginFactory clone() {
        PluginFactory pluginFactory = new PluginFactory();
        for (Plugin plugin : this.listAllPlugin) {
            try {
                Plugin plugin2 = (Plugin)plugin.getClass().newInstance();
                plugin2.setConfig(pluginFactory.config);
                plugin.cloneInto(plugin2);
                pluginFactory.addPlugin(plugin2);
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        return pluginFactory;
    }

    public boolean addPlugin(String string) {
        try {
            Class<?> clazz = ExtensionFactory.getAddOnLoader().loadClass(string);
            return this.addPlugin((AbstractPlugin)clazz.newInstance());
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    private boolean addPlugin(Plugin plugin) {
        this.listAllPlugin.add(plugin);
        plugin.setConfig(this.config);
        plugin.createParamIfNotExist();
        if (!plugin.isVisible()) {
            log.info((Object)("Plugin " + plugin.getName() + " not visible"));
            return false;
        }
        if (plugin.isDepreciated()) {
            log.info((Object)("Plugin " + plugin.getName() + " depricated"));
            return false;
        }
        log.info((Object)("loaded plugin " + plugin.getName()));
        if (this.mapAllPlugin.get(plugin.getId()) != null) {
            log.error((Object)("Duplicate id " + plugin.getName() + " " + this.mapAllPlugin.get(plugin.getId()).getName()));
        }
        this.mapAllPlugin.put(plugin.getId(), plugin);
        this.mapAllPluginOrderCodeName.put(plugin.getCodeName(), plugin);
        return true;
    }

    public boolean removePlugin(String string) {
        for (int i = 0; i < this.listAllPlugin.size(); ++i) {
            Plugin plugin = this.listAllPlugin.get(i);
            if (!plugin.getClass().getName().equals(string)) continue;
            this.listAllPlugin.remove(plugin);
            this.mapAllPlugin.remove(plugin.getId());
            this.mapAllPluginOrderCodeName.remove(plugin.getCodeName());
            return true;
        }
        return false;
    }

    public Plugin getPlugin(int n) {
        return this.mapAllPlugin.get(n);
    }

    public void setAllPluginEnabled(boolean bl) {
        for (int i = 0; i < this.listAllPlugin.size(); ++i) {
            Plugin plugin = this.listAllPlugin.get(i);
            plugin.setEnabled(bl);
        }
    }

    synchronized boolean existPluginToRun() {
        if (!this.init) {
            this.reset();
        }
        if (this.probeNextPlugin() != null) {
            return true;
        }
        return !this.listPending.isEmpty() || !this.listRunning.isEmpty();
    }

    private Plugin probeNextPlugin() {
        Plugin plugin = null;
        for (int i = 0; i < this.listPending.size(); ++i) {
            plugin = this.listPending.get(i);
            if (!this.isAllDependencyCompleted(plugin)) continue;
            return plugin;
        }
        return null;
    }

    synchronized Plugin nextPlugin() {
        Plugin plugin;
        if (!this.init) {
            this.reset();
        }
        if ((plugin = this.probeNextPlugin()) == null) {
            return null;
        }
        this.listPending.remove(plugin);
        plugin.setTimeStarted();
        this.listRunning.add(plugin);
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAllDependencyCompleted(Plugin plugin) {
        String[] stringArray = plugin.getDependency();
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        List<Plugin> list = this.listCompleted;
        synchronized (list) {
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = false;
                for (int j = 0; j < this.listCompleted.size() && !bl; ++j) {
                    Plugin plugin2 = this.listCompleted.get(j);
                    if (!plugin2.getCodeName().equalsIgnoreCase(stringArray[i])) continue;
                    bl = true;
                }
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    public void saveTo(Configuration configuration) throws ConfigurationException {
        for (Plugin plugin : this.listAllPlugin) {
            plugin.saveTo(configuration);
        }
    }

    public void loadFrom(Configuration configuration) throws ConfigurationException {
        for (Plugin plugin : this.listAllPlugin) {
            plugin.loadFrom(configuration);
        }
    }

    synchronized void setRunningPluginCompleted(Plugin plugin) {
        this.listRunning.remove(plugin);
        this.listCompleted.add(plugin);
        plugin.setTimeFinished();
    }

    boolean isRunning(Plugin plugin) {
        return this.listRunning.contains(plugin);
    }

    int totalPluginToRun() {
        return this.totalPluginToRun;
    }

    int totalPluginCompleted() {
        return this.listCompleted.size();
    }

    List<Plugin> getPending() {
        return this.listPending;
    }

    List<Plugin> getRunning() {
        return this.listRunning;
    }

    List<Plugin> getCompleted() {
        return this.listCompleted;
    }

    public int getEnabledPluginCount() {
        int n = 0;
        for (Plugin plugin : this.listAllPlugin) {
            if (!plugin.isEnabled()) continue;
            ++n;
        }
        return n;
    }
}

