/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.apache.commons.codec.binary.Base64;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.core.scanner.VariantScript;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class VariantCustom
implements Variant {
    ExtensionScript extension = null;
    private ScriptWrapper wrapper = null;
    private VariantScript script = null;
    private final List<NameValuePair> params = new ArrayList<NameValuePair>();
    private static final Pattern BASE64_PATTERN = Pattern.compile("^[a-zA-Z0-9/+]+={0,2}$");

    public VariantCustom(ScriptWrapper scriptWrapper, ExtensionScript extensionScript) {
        this.wrapper = scriptWrapper;
        this.extension = extensionScript;
        if (scriptWrapper != null && extensionScript != null && scriptWrapper.isEnabled()) {
            try {
                this.script = extensionScript.getInterface(scriptWrapper, VariantScript.class);
            }
            catch (IOException | ScriptException exception) {
                this.extension.setError(scriptWrapper, exception);
                this.extension.setEnabled(scriptWrapper, false);
                this.script = null;
            }
        }
    }

    @Override
    public void setMessage(HttpMessage httpMessage) {
        try {
            if (this.script != null) {
                this.script.parseParameters(this, httpMessage);
            }
        }
        catch (ScriptException scriptException) {
            this.extension.setError(this.wrapper, scriptException);
            this.extension.setEnabled(this.wrapper, false);
        }
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.params;
    }

    public String getParamName(int n) {
        return n < this.params.size() ? this.params.get(n).getName() : null;
    }

    public String getParamValue(int n) {
        return n < this.params.size() ? this.params.get(n).getValue() : null;
    }

    public int getParamNumber() {
        return this.params.size();
    }

    public void addParam(String string, String string2, int n) {
        this.params.add(new NameValuePair(n, string, string2, this.params.size()));
    }

    public void addParamQuery(String string, String string2) {
        this.addParam(string, string2, 1);
    }

    public void addParamPost(String string, String string2) {
        this.addParam(string, string2, 2);
    }

    public void addParamHeader(String string, String string2) {
        this.addParam(string, string2, 8);
    }

    public String encodeBase64(String string) {
        return Base64.encodeBase64String((byte[])string.getBytes());
    }

    public String decodeBase64(String string) {
        return new String(Base64.decodeBase64((String)string));
    }

    public boolean isBase64(String string) {
        return BASE64_PATTERN.matcher(string).matches() && string.length() % 4 == 0;
    }

    @Override
    public String setParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        return this.setParameter(httpMessage, string, string2, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        return this.setParameter(httpMessage, string, string2, true);
    }

    private String setParameter(HttpMessage httpMessage, String string, String string2, boolean bl) {
        try {
            if (this.script != null) {
                this.script.setParameter(this, httpMessage, string, string2, bl);
            }
        }
        catch (ScriptException scriptException) {
            this.extension.setError(this.wrapper, scriptException);
            this.extension.setEnabled(this.wrapper, false);
        }
        return string2;
    }
}

