/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.manualrequest.http.impl;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.extension.manualrequest.MessageSender;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.PersistentConnectionListener;
import org.zaproxy.zap.ZapGetMethod;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.extension.httppanel.HttpPanelRequest;
import org.zaproxy.zap.extension.httppanel.HttpPanelResponse;
import org.zaproxy.zap.extension.httppanel.Message;

public class HttpPanelSender
implements MessageSender {
    private static final Logger logger = Logger.getLogger(HttpPanelSender.class);
    private final HttpPanelResponse responsePanel;
    private ExtensionHistory extension;
    private HttpSender delegate;
    private JToggleButton followRedirect = null;
    private JToggleButton useTrackingSessionState = null;
    private List<PersistentConnectionListener> persistentConnectionListener = new ArrayList<PersistentConnectionListener>();

    public HttpPanelSender(HttpPanelRequest httpPanelRequest, HttpPanelResponse httpPanelResponse) {
        this.responsePanel = httpPanelResponse;
        httpPanelRequest.addOptions(this.getButtonUseTrackingSessionState(), HttpPanel.OptionsLocation.AFTER_COMPONENTS);
        httpPanelRequest.addOptions(this.getButtonFollowRedirects(), HttpPanel.OptionsLocation.AFTER_COMPONENTS);
        boolean bl = Model.getSingleton().getOptionsParam().getConnectionParam().isHttpStateEnabled();
        this.getButtonUseTrackingSessionState().setEnabled(bl);
    }

    @Override
    public void handleSendMessage(Message message) throws IllegalArgumentException, IOException {
        final HttpMessage httpMessage = (HttpMessage)message;
        try {
            this.getDelegate().sendAndReceive(httpMessage, this.getButtonFollowRedirects().isSelected());
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (!httpMessage.getResponseHeader().isEmpty()) {
                        HttpPanelSender.this.responsePanel.updateContent();
                        Thread thread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                ExtensionHistory extensionHistory = HttpPanelSender.this.getHistoryExtension();
                                if (extensionHistory != null) {
                                    extensionHistory.addHistory(httpMessage, 15);
                                }
                            }
                        });
                        thread.start();
                    }
                }
            });
            ZapGetMethod zapGetMethod = (ZapGetMethod)((Object)httpMessage.getUserObject());
            this.notifyPersistentConnectionListener(httpMessage, null, zapGetMethod);
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            throw new IllegalArgumentException("Malformed header error.", httpMalformedHeaderException);
        }
        catch (IOException iOException) {
            throw new IOException("IO error in sending request.", iOException);
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyPersistentConnectionListener(HttpMessage httpMessage, Socket socket, ZapGetMethod zapGetMethod) {
        boolean bl = false;
        PersistentConnectionListener persistentConnectionListener = null;
        List<PersistentConnectionListener> list = this.persistentConnectionListener;
        synchronized (list) {
            for (int i = 0; i < this.persistentConnectionListener.size(); ++i) {
                persistentConnectionListener = this.persistentConnectionListener.get(i);
                try {
                    if (!persistentConnectionListener.onHandshakeResponse(httpMessage, socket, zapGetMethod)) continue;
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    logger.warn((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        return bl;
    }

    protected ExtensionHistory getHistoryExtension() {
        if (this.extension == null) {
            this.extension = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
        }
        return this.extension;
    }

    @Override
    public void cleanup() {
        if (this.delegate != null) {
            this.delegate.shutdown();
            this.delegate = null;
        }
        boolean bl = Model.getSingleton().getOptionsParam().getConnectionParam().isHttpStateEnabled();
        this.getButtonUseTrackingSessionState().setEnabled(bl);
    }

    private HttpSender getDelegate() {
        if (this.delegate == null) {
            this.delegate = new HttpSender(Model.getSingleton().getOptionsParam().getConnectionParam(), this.getButtonUseTrackingSessionState().isSelected(), 6);
        }
        return this.delegate;
    }

    private JToggleButton getButtonFollowRedirects() {
        if (this.followRedirect == null) {
            this.followRedirect = new JToggleButton(new ImageIcon(HttpPanelSender.class.getResource("/resource/icon/16/118.png")));
            this.followRedirect.setToolTipText(Constant.messages.getString("manReq.checkBox.followRedirect"));
            this.followRedirect.setSelected(true);
        }
        return this.followRedirect;
    }

    private JToggleButton getButtonUseTrackingSessionState() {
        if (this.useTrackingSessionState == null) {
            this.useTrackingSessionState = new JToggleButton(new ImageIcon(HttpPanelSender.class.getResource("/resource/icon/fugue/cookie.png")));
            this.useTrackingSessionState.setToolTipText(Constant.messages.getString("manReq.checkBox.useSession"));
        }
        return this.useTrackingSessionState;
    }

    public void addPersistentConnectionListener(PersistentConnectionListener persistentConnectionListener) {
        this.persistentConnectionListener.add(persistentConnectionListener);
    }

    public void removePersistentConnectionListener(PersistentConnectionListener persistentConnectionListener) {
        this.persistentConnectionListener.remove(persistentConnectionListener);
    }
}

