/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.awt.EventQueue;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteMapEventPublisher;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.view.SiteTreeFilter;

public class SiteMap
extends DefaultTreeModel {
    private static final long serialVersionUID = 2311091007687218751L;
    private static Map<Integer, SiteNode> hrefMap = new HashMap<Integer, SiteNode>();
    private Model model = null;
    private SiteTreeFilter filter = null;
    private static Logger log = Logger.getLogger(SiteMap.class);

    public static SiteMap createTree(Model model) {
        SiteMap siteMap = new SiteMap(null, model);
        SiteNode siteNode = new SiteNode(siteMap, -1, Constant.messages.getString("tab.sites"));
        siteMap.setRoot(siteNode);
        hrefMap = new HashMap<Integer, SiteNode>();
        return siteMap;
    }

    public SiteMap(SiteNode siteNode, Model model) {
        super(siteNode);
        this.model = model;
    }

    public synchronized HttpMessage pollPath(HttpMessage httpMessage) {
        Object object;
        SiteNode siteNode = null;
        URI uRI = httpMessage.getRequestHeader().getURI();
        SiteNode siteNode2 = (SiteNode)this.getRoot();
        try {
            object = this.getHostName(uRI);
            siteNode2 = this.findChild(siteNode2, (String)object);
            if (siteNode2 == null) {
                return null;
            }
            List<String> list = this.model.getSession().getTreePath(uRI);
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                if (string == null || string.equals("")) continue;
                if (i == list.size() - 1) {
                    String string2 = this.getLeafName(string, httpMessage);
                    siteNode = this.findChild(siteNode2, string2);
                    continue;
                }
                if ((siteNode2 = this.findChild(siteNode2, string)) != null) continue;
                return null;
            }
        }
        catch (URIException uRIException) {
            log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
        }
        if (siteNode == null || siteNode.getHistoryReference() == null) {
            return null;
        }
        object = null;
        try {
            object = siteNode.getHistoryReference().getHttpMessage();
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return object;
    }

    public SiteNode findNode(HttpMessage httpMessage) {
        return this.findNode(httpMessage, false);
    }

    public synchronized SiteNode findNode(HttpMessage httpMessage, boolean bl) {
        if (Constant.isLowMemoryOptionSet()) {
            throw new InvalidParameterException("SiteMap should not be accessed when the low memory option is set");
        }
        if (httpMessage == null || httpMessage.getRequestHeader() == null) {
            return null;
        }
        SiteNode siteNode = null;
        URI uRI = httpMessage.getRequestHeader().getURI();
        SiteNode siteNode2 = (SiteNode)this.getRoot();
        String string = "";
        try {
            String string2 = this.getHostName(uRI);
            siteNode2 = this.findChild(siteNode2, string2);
            if (siteNode2 == null) {
                return null;
            }
            List<String> list = this.model.getSession().getTreePath(httpMessage);
            for (int i = 0; i < list.size(); ++i) {
                string = list.get(i);
                if (string == null || string.equals("")) continue;
                if (i == list.size() - 1) {
                    if (bl) {
                        siteNode = this.findChild(siteNode2, string);
                        continue;
                    }
                    String string3 = this.getLeafName(string, httpMessage);
                    siteNode = this.findChild(siteNode2, string3);
                    continue;
                }
                if ((siteNode2 = this.findChild(siteNode2, string)) != null) continue;
                return null;
            }
        }
        catch (URIException uRIException) {
            log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
        }
        return siteNode;
    }

    public synchronized SiteNode findNode(URI uRI) {
        SiteNode siteNode = this.findNode(uRI, null, null);
        if (siteNode != null) {
            return siteNode;
        }
        return this.findNode(uRI, "GET", null);
    }

    public synchronized SiteNode findNode(URI uRI, String string, String string2) {
        if (Constant.isLowMemoryOptionSet()) {
            throw new InvalidParameterException("SiteMap should not be accessed when the low memory option is set");
        }
        SiteNode siteNode = null;
        String string3 = "";
        try {
            String string4 = this.getHostName(uRI);
            siteNode = this.findChild((SiteNode)this.getRoot(), string4);
            if (siteNode == null) {
                return null;
            }
            List<String> list = this.model.getSession().getTreePath(uRI);
            for (int i = 0; i < list.size(); ++i) {
                string3 = list.get(i);
                if (string3 == null || string3.equals("")) continue;
                if (i == list.size() - 1) {
                    String string5 = this.getLeafName(string3, uRI, string, string2);
                    siteNode = this.findChild(siteNode, string5);
                    continue;
                }
                if ((siteNode = this.findChild(siteNode, string3)) != null) continue;
                return null;
            }
        }
        catch (URIException uRIException) {
            log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
        }
        return siteNode;
    }

    public synchronized SiteNode findClosestParent(HttpMessage httpMessage) {
        if (httpMessage == null || httpMessage.getRequestHeader() == null) {
            return null;
        }
        return this.findClosestParent(httpMessage.getRequestHeader().getURI());
    }

    public synchronized SiteNode findClosestParent(URI uRI) {
        if (uRI == null) {
            return null;
        }
        SiteNode siteNode = null;
        SiteNode siteNode2 = (SiteNode)this.getRoot();
        String string = "";
        try {
            String string2 = this.getHostName(uRI);
            siteNode2 = this.findChild(siteNode2, string2);
            if (siteNode2 == null) {
                return null;
            }
            siteNode = siteNode2;
            List<String> list = this.model.getSession().getTreePath(uRI);
            for (int i = 0; i < list.size(); ++i) {
                string = list.get(i);
                if (string == null || string.equals("")) continue;
                if (i == list.size() - 1) {
                    siteNode = siteNode2;
                    continue;
                }
                if ((siteNode2 = this.findChild(siteNode2, string)) != null) {
                    siteNode = siteNode2;
                    continue;
                }
                break;
            }
        }
        catch (URIException uRIException) {
            log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
        }
        return siteNode;
    }

    public synchronized SiteNode addPath(HistoryReference historyReference) {
        if (Constant.isLowMemoryOptionSet()) {
            throw new InvalidParameterException("SiteMap should not be accessed when the low memory option is set");
        }
        HttpMessage httpMessage = null;
        try {
            httpMessage = historyReference.getHttpMessage();
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
        return this.addPath(historyReference, httpMessage);
    }

    public SiteNode addPath(HistoryReference historyReference, HttpMessage httpMessage) {
        if (Constant.isLowMemoryOptionSet()) {
            throw new InvalidParameterException("SiteMap should not be accessed when the low memory option is set");
        }
        if (View.isInitialised() && Constant.isDevBuild() && !EventQueue.isDispatchThread()) {
            log.error((Object)("SiteMap.addPath not on EDT " + Thread.currentThread().getName()), (Throwable)new Exception());
        }
        URI uRI = httpMessage.getRequestHeader().getURI();
        log.debug((Object)("addPath " + uRI.toString()));
        SiteNode siteNode = (SiteNode)this.getRoot();
        SiteNode siteNode2 = null;
        String string = "";
        try {
            String string2 = this.getHostName(uRI);
            siteNode = this.findAndAddChild(siteNode, string2, historyReference, httpMessage);
            List<String> list = this.model.getSession().getTreePath(httpMessage);
            for (int i = 0; i < list.size(); ++i) {
                string = list.get(i);
                if (string == null || string.equals("")) continue;
                if (i == list.size() - 1) {
                    siteNode2 = this.findAndAddLeaf(siteNode, string, historyReference, httpMessage);
                    historyReference.setSiteNode(siteNode2);
                    continue;
                }
                siteNode = this.findAndAddChild(siteNode, string, historyReference, httpMessage);
            }
            if (siteNode2 == null) {
                siteNode.setHistoryReference(historyReference);
                siteNode2 = siteNode;
            }
        }
        catch (Exception exception) {
            log.error((Object)("Exception adding " + uRI.toString() + " " + exception.getMessage()), (Throwable)exception);
        }
        if (hrefMap.get(historyReference.getHistoryId()) == null) {
            hrefMap.put(historyReference.getHistoryId(), siteNode2);
        }
        return siteNode2;
    }

    private SiteNode findAndAddChild(SiteNode siteNode, String string, HistoryReference historyReference, HttpMessage httpMessage) throws URIException, HttpMalformedHeaderException, NullPointerException, DatabaseException {
        log.debug((Object)("findAndAddChild " + siteNode.getNodeName() + " / " + string));
        SiteNode siteNode2 = this.findChild(siteNode, string);
        if (siteNode2 == null) {
            SiteNode siteNode3 = null;
            if (!historyReference.getCustomIcons().isEmpty()) {
                siteNode3 = new SiteNode(this, historyReference.getHistoryType(), string);
                siteNode3.setCustomIcons(historyReference.getCustomIcons(), historyReference.getClearIfManual());
            } else {
                siteNode3 = new SiteNode(this, historyReference.getHistoryType(), string);
            }
            int n = siteNode.getChildCount();
            for (int i = 0; i < siteNode.getChildCount(); ++i) {
                if (!((SiteNode)siteNode.getChildAt(i)).isParentOf(string)) continue;
                n = i;
                break;
            }
            this.insertNodeInto(siteNode3, siteNode, n);
            siteNode2 = siteNode3;
            siteNode2.setHistoryReference(this.createReference(siteNode2, historyReference, httpMessage));
            siteNode3.setIncludedInScope(this.model.getSession().isIncludedInScope(siteNode3), true);
            siteNode3.setExcludedFromScope(this.model.getSession().isExcludedFromScope(siteNode3), true);
            hrefMap.put(siteNode2.getHistoryReference().getHistoryId(), siteNode2);
            this.applyFilter(siteNode3);
            ZAP.getEventBus().publishSyncEvent(SiteMapEventPublisher.getPublisher(), new Event(SiteMapEventPublisher.getPublisher(), "siteNode.added", new Target(siteNode2)));
        }
        if (historyReference.getSiteNode() == null) {
            historyReference.setSiteNode(siteNode2);
        }
        return siteNode2;
    }

    private SiteNode findChild(SiteNode siteNode, String string) {
        log.debug((Object)("findChild " + siteNode.getNodeName() + " / " + string));
        for (int i = 0; i < siteNode.getChildCount(); ++i) {
            SiteNode siteNode2 = (SiteNode)siteNode.getChildAt(i);
            if (!siteNode2.getNodeName().equals(string)) continue;
            return siteNode2;
        }
        return null;
    }

    private SiteNode findAndAddLeaf(SiteNode siteNode, String string, HistoryReference historyReference, HttpMessage httpMessage) {
        log.debug((Object)("findAndAddLeaf " + siteNode.getNodeName() + " / " + string));
        String string2 = this.getLeafName(string, httpMessage);
        SiteNode siteNode2 = this.findChild(siteNode, string2);
        if (siteNode2 == null) {
            if (!historyReference.getCustomIcons().isEmpty()) {
                siteNode2 = new SiteNode(this, historyReference.getHistoryType(), string2);
                siteNode2.setCustomIcons(historyReference.getCustomIcons(), historyReference.getClearIfManual());
            } else {
                siteNode2 = new SiteNode(this, historyReference.getHistoryType(), string2);
            }
            siteNode2.setHistoryReference(historyReference);
            hrefMap.put(historyReference.getHistoryId(), siteNode2);
            int n = siteNode.getChildCount();
            for (int i = 0; i < siteNode.getChildCount(); ++i) {
                if (!((SiteNode)siteNode.getChildAt(i)).isParentOf(string)) continue;
                n = i;
                break;
            }
            if (historyReference.getSiteNode() == null) {
                historyReference.setSiteNode(siteNode2);
            }
            this.insertNodeInto(siteNode2, siteNode, n);
            siteNode2.setIncludedInScope(this.model.getSession().isIncludedInScope(siteNode2), true);
            siteNode2.setExcludedFromScope(this.model.getSession().isExcludedFromScope(siteNode2), true);
            this.applyFilter(siteNode2);
            ZAP.getEventBus().publishSyncEvent(SiteMapEventPublisher.getPublisher(), new Event(SiteMapEventPublisher.getPublisher(), "siteNode.added", new Target(siteNode2)));
        } else {
            if (httpMessage.getResponseHeader().getStatusCode() == 200) {
                siteNode2.setHistoryReference(historyReference);
                historyReference.setSiteNode(siteNode2);
            } else {
                siteNode2.getPastHistoryReference().add(historyReference);
                historyReference.setSiteNode(siteNode2);
            }
            hrefMap.put(historyReference.getHistoryId(), siteNode2);
        }
        return siteNode2;
    }

    private String getLeafName(String string, HttpMessage httpMessage) {
        String string2 = httpMessage.getRequestHeader().getMethod() + ":" + string;
        string2 = string2 + this.getQueryParamString(httpMessage.getParamNameSet(HtmlParameter.Type.url));
        if (httpMessage.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
            String string3 = httpMessage.getRequestHeader().getHeader("Content-Type");
            string2 = string3 != null && string3.startsWith("multipart/form-data") ? string2 + "(multipart/form-data)" : string2 + this.getQueryParamString(httpMessage.getParamNameSet(HtmlParameter.Type.form));
        }
        return string2;
    }

    private String getLeafName(String string, URI uRI, String string2, String string3) {
        String string4 = string2 != null ? string2 + ":" + string : string;
        try {
            string4 = string4 + this.getQueryParamString(this.model.getSession().getUrlParams(uRI));
            if (string2 != null && string2.equalsIgnoreCase("POST")) {
                string4 = string4 + this.getQueryParamString(this.model.getSession().getFormParams(uRI, string3));
            }
        }
        catch (URIException uRIException) {
            log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
        }
        return string4;
    }

    private String getQueryParamString(Map<String, String> map) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            treeSet.add(entry.getKey());
        }
        return this.getQueryParamString(treeSet);
    }

    private String getQueryParamString(SortedSet<String> sortedSet) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = sortedSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string != null) {
                if (n > 0) {
                    stringBuilder.append(',');
                }
                if (string.length() > 40) {
                    string = string.substring(0, 40);
                }
                stringBuilder.append(string);
            }
            ++n;
        }
        String string = "";
        if (stringBuilder.length() > 0) {
            string = stringBuilder.insert(0, '(').append(')').toString();
        }
        return string;
    }

    private HistoryReference createReference(SiteNode siteNode, HistoryReference historyReference, HttpMessage httpMessage) throws HttpMalformedHeaderException, DatabaseException, URIException, NullPointerException {
        TreeNode[] treeNodeArray = siteNode.getPath();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < treeNodeArray.length; ++i) {
            String string = ((SiteNode)treeNodeArray[i]).getNodeName();
            stringBuilder.append(string);
            if (i >= treeNodeArray.length - 1) continue;
            stringBuilder.append('/');
        }
        HttpMessage httpMessage2 = httpMessage.cloneRequest();
        URI uRI = new URI(stringBuilder.toString(), false);
        httpMessage2.getRequestHeader().setURI(uRI);
        httpMessage2.getRequestHeader().setMethod("GET");
        httpMessage2.getRequestBody().setBody("");
        httpMessage2.getRequestHeader().setHeader("Content-Type", null);
        httpMessage2.getRequestHeader().setHeader("Content-Length", null);
        HistoryReference historyReference2 = new HistoryReference(this.model.getSession(), 0, httpMessage2);
        return historyReference2;
    }

    public SiteNode getSiteNode(int n) {
        return hrefMap.get(n);
    }

    public void removeHistoryReference(int n) {
        hrefMap.remove(n);
    }

    private String getHostName(URI uRI) throws URIException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = uRI.getScheme();
        string = string == null ? "http" : string.toLowerCase();
        stringBuilder.append(string).append("://").append(uRI.getHost());
        int n = uRI.getPort();
        if (n != -1 && (n == 80 && !"http".equals(string) || n == 443 && !"https".equals(string) || n != 80 && n != 443)) {
            stringBuilder.append(":").append(n);
        }
        return stringBuilder.toString();
    }

    public void setFilter(SiteTreeFilter siteTreeFilter) {
        this.filter = siteTreeFilter;
        SiteNode siteNode = (SiteNode)this.getRoot();
        this.setFilter(siteTreeFilter, siteNode);
        siteNode.setFiltered(false);
    }

    private boolean setFilter(SiteTreeFilter siteTreeFilter, SiteNode siteNode) {
        boolean bl = !siteTreeFilter.matches(siteNode);
        for (int i = 0; i < siteNode.getChildCount(); ++i) {
            if (this.setFilter(siteTreeFilter, (SiteNode)siteNode.getChildAt(i))) continue;
            bl = false;
        }
        siteNode.setFiltered(bl);
        return bl;
    }

    public void clearFilter() {
        this.filter = null;
        this.clearFilter((SiteNode)this.getRoot());
    }

    private void clearFilter(SiteNode siteNode) {
        siteNode.setFiltered(false);
        for (int i = 0; i < siteNode.getChildCount(); ++i) {
            this.clearFilter((SiteNode)siteNode.getChildAt(i));
        }
    }

    protected void applyFilter(SiteNode siteNode) {
        if (this.filter != null) {
            boolean bl = this.setFilter(this.filter, siteNode);
            SiteNode siteNode2 = (SiteNode)siteNode.getParent();
            if (siteNode2 != null && !bl && siteNode2.isFiltered()) {
                this.clearParentFilter(siteNode2);
            }
        } else {
            siteNode.setFiltered(false);
        }
    }

    private void clearParentFilter(SiteNode siteNode) {
        if (siteNode != null) {
            siteNode.setFiltered(false);
            this.clearParentFilter((SiteNode)siteNode.getParent());
        }
    }
}

