/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptContext;

public class ScriptVars {
    private static int MAX_KEY_SIZE = 30;
    private static int MAX_VALUE_SIZE = 1024;
    private static int MAX_SCRIPT_VARS = 20;
    private static int MAX_GLOBAL_VARS = 50;
    private static Map<String, String> globalVars = new HashMap<String, String>();
    private static Map<String, Map<String, String>> scriptVars = new HashMap<String, Map<String, String>>();

    public static void setGlobalVar(String string, String string2) {
        if (string == null || string.length() > MAX_KEY_SIZE) {
            throw new InvalidParameterException("Invalid key - must be non null and have a length less than " + MAX_KEY_SIZE);
        }
        if (string2 == null) {
            globalVars.remove(string);
        } else {
            if (string2.length() > MAX_VALUE_SIZE) {
                throw new InvalidParameterException("Invalid value - must have a length less than " + MAX_VALUE_SIZE);
            }
            if (globalVars.size() > MAX_GLOBAL_VARS) {
                throw new InvalidParameterException("Maximum number of global variables reached: " + MAX_GLOBAL_VARS);
            }
            globalVars.put(string, string2);
        }
    }

    public static String getGlobalVar(String string) {
        return globalVars.get(string);
    }

    public static void setScriptVar(ScriptContext scriptContext, String string, String string2) {
        if (scriptContext == null) {
            throw new InvalidParameterException("Invalid context - must be non null");
        }
        if (string == null || string.length() > MAX_KEY_SIZE) {
            throw new InvalidParameterException("Invalid key - must be non null and have a length less than " + MAX_KEY_SIZE);
        }
        String string3 = (String)scriptContext.getAttribute("zap.script.name");
        if (string3 == null) {
            throw new InvalidParameterException("Failed to find script name");
        }
        Map<String, String> map = scriptVars.get(string3);
        if (map == null) {
            map = new HashMap<String, String>();
            scriptVars.put(string3, map);
        }
        if (string2 == null) {
            map.remove(string);
        } else {
            if (string2.length() > MAX_VALUE_SIZE) {
                throw new InvalidParameterException("Invalid value - must have a length less than " + MAX_VALUE_SIZE);
            }
            if (map.size() > MAX_SCRIPT_VARS) {
                throw new InvalidParameterException("Maximum number of script variables reached: " + MAX_SCRIPT_VARS);
            }
            map.put(string, string2);
        }
    }

    public static String getScriptVar(ScriptContext scriptContext, String string) {
        if (scriptContext == null) {
            throw new InvalidParameterException("Invalid context - must be non null");
        }
        String string2 = (String)scriptContext.getAttribute("zap.script.name");
        if (string2 == null) {
            throw new InvalidParameterException("Failed to find script name");
        }
        Map<String, String> map = scriptVars.get(string2);
        if (map == null) {
            return null;
        }
        return map.get(string);
    }
}

