/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.users;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SortOrder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.users.ContextUserAuthManager;
import org.zaproxy.zap.extension.users.DialogAddUser;
import org.zaproxy.zap.extension.users.DialogModifyUser;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.extension.users.UsersTableModel;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.AbstractMultipleOptionsTablePanel;
import org.zaproxy.zap.view.LayoutHelper;

public class ContextUsersPanel
extends AbstractContextPropertiesPanel {
    private UsersMultipleOptionsPanel usersOptionsPanel;
    private ContextUserAuthManager contextManager;
    private ExtensionUserManagement extension;
    private UsersTableModel usersTableModel;
    private static final long serialVersionUID = -3920598166129639573L;
    private static final String PANEL_NAME = Constant.messages.getString("users.panel.title");

    public ContextUsersPanel(ExtensionUserManagement extensionUserManagement, int n) {
        super(n);
        this.contextManager = extensionUserManagement.getContextUserAuthManager(n);
        this.extension = extensionUserManagement;
        this.initialize();
    }

    public static String getPanelName(int n) {
        return n + ": " + PANEL_NAME;
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(ContextUsersPanel.getPanelName(this.getContextIndex()));
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(Constant.messages.getString("users.panel.description")), LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0));
        this.usersTableModel = new UsersTableModel();
        this.usersOptionsPanel = new UsersMultipleOptionsPanel(this.extension, this.usersTableModel, this.getContextIndex());
        this.add((Component)this.usersOptionsPanel, LayoutHelper.getGBC(0, 1, 1, 1.0, 1.0));
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.contexts";
    }

    @Override
    public void initContextData(Session session, Context context) {
        this.usersOptionsPanel.setWorkingContext(context);
        this.usersTableModel.setUsers(this.contextManager.getUsers());
    }

    @Override
    public void validateContextData(Session session) throws Exception {
    }

    @Override
    public void saveContextData(Session session) throws Exception {
        this.contextManager.setUsers(this.usersTableModel.getUsers());
    }

    @Override
    public void saveTemporaryContextData(Context context) {
    }

    protected UsersTableModel getUsersTableModel() {
        return this.usersTableModel;
    }

    public static class UsersMultipleOptionsPanel
    extends AbstractMultipleOptionsTablePanel<User> {
        private static final long serialVersionUID = -7216673905642941770L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("users.dialog.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("users.dialog.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("users.dialog.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("users.dialog.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("users.dialog.remove.checkbox.label");
        private DialogAddUser addDialog = null;
        private DialogModifyUser modifyDialog = null;
        private ExtensionUserManagement extension;
        private Context uiSharedContext;

        public UsersMultipleOptionsPanel(ExtensionUserManagement extensionUserManagement, UsersTableModel usersTableModel, int n) {
            super(usersTableModel);
            this.extension = extensionUserManagement;
            this.getTable().getColumnExt(0).setPreferredWidth(40);
            this.getTable().getColumnExt(1).setPreferredWidth(30);
            this.getTable().getColumnExt(1).setMaxWidth(50);
            this.getTable().setSortOrder(2, SortOrder.ASCENDING);
        }

        @Override
        public User showAddDialogue() {
            if (this.addDialog == null) {
                this.addDialog = new DialogAddUser((Dialog)View.getSingleton().getOptionsDialog(null), this.extension);
                this.addDialog.pack();
            }
            this.addDialog.setWorkingContext(this.uiSharedContext);
            this.addDialog.setVisible(true);
            User user = this.addDialog.getUser();
            this.addDialog.clear();
            return user;
        }

        @Override
        public User showModifyDialogue(User user) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogModifyUser((Dialog)View.getSingleton().getOptionsDialog(null), this.extension);
                this.modifyDialog.pack();
            }
            this.modifyDialog.setWorkingContext(this.uiSharedContext);
            this.modifyDialog.setUser(user);
            this.modifyDialog.setVisible(true);
            user = this.modifyDialog.getUser();
            this.modifyDialog.clear();
            return user;
        }

        @Override
        public boolean showRemoveDialogue(User user) {
            JCheckBox jCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] objectArray = new Object[]{REMOVE_DIALOG_TEXT, " ", jCheckBox};
            int n = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), objectArray, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (n == 0) {
                this.setRemoveWithoutConfirmation(jCheckBox.isSelected());
                return true;
            }
            return false;
        }

        protected void setWorkingContext(Context context) {
            this.uiSharedContext = context;
        }
    }
}

