/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.util.ArrayList;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.model.StandardParameterParser;

@RunWith(value=MockitoJUnitRunner.class)
public class StandardParameterParserUnitTest {
    Session session;
    private StandardParameterParser spp;

    @Before
    public void setUp() throws Exception {
        this.spp = new StandardParameterParser();
    }

    @Test
    public void defaultValues() {
        Assert.assertEquals((Object)this.spp.getDefaultKeyValuePairSeparator(), (Object)"&");
        Assert.assertEquals((Object)this.spp.getDefaultKeyValueSeparator(), (Object)"=");
    }

    @Test
    public void defaultParser() {
        Assert.assertEquals((Object)this.spp.getKeyValuePairSeparators(), (Object)"&");
        Assert.assertEquals((Object)this.spp.getKeyValueSeparators(), (Object)"=");
        Assert.assertEquals((long)this.spp.getStructuralParameters().size(), (long)0L);
        Map<String, String> map = this.spp.parse("a=b&b=c&d=f");
        Assert.assertEquals((long)map.size(), (long)3L);
        Assert.assertEquals((Object)map.get("a"), (Object)"b");
        Assert.assertEquals((Object)map.get("b"), (Object)"c");
        Assert.assertEquals((Object)map.get("d"), (Object)"f");
    }

    @Test
    public void nonDefaultParser() {
        this.spp.setKeyValuePairSeparators(";");
        this.spp.setKeyValueSeparators(":=");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("page");
        this.spp.setStructuralParameters(arrayList);
        Map<String, String> map = this.spp.parse("a=b&c;b:c");
        Assert.assertEquals((Object)this.spp.getKeyValuePairSeparators(), (Object)";");
        Assert.assertEquals((Object)this.spp.getKeyValueSeparators(), (Object)":=");
        Assert.assertEquals((long)this.spp.getStructuralParameters().size(), (long)1L);
        Assert.assertEquals((Object)this.spp.getStructuralParameters().get(0), (Object)"page");
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertEquals((Object)map.get("a"), (Object)"b&c");
        Assert.assertEquals((Object)map.get("b"), (Object)"c");
    }

    @Test
    public void saveAndLoad() {
        this.spp.setKeyValuePairSeparators(";");
        this.spp.setKeyValueSeparators(":=");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("page");
        this.spp.setStructuralParameters(arrayList);
        StandardParameterParser standardParameterParser = new StandardParameterParser();
        standardParameterParser.init(this.spp.getConfig());
        Map<String, String> map = standardParameterParser.parse("a=b&c;b:c");
        Assert.assertEquals((Object)standardParameterParser.getKeyValuePairSeparators(), (Object)";");
        Assert.assertEquals((Object)standardParameterParser.getKeyValueSeparators(), (Object)":=");
        Assert.assertEquals((long)standardParameterParser.getStructuralParameters().size(), (long)1L);
        Assert.assertEquals((Object)standardParameterParser.getStructuralParameters().get(0), (Object)"page");
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertEquals((Object)map.get("a"), (Object)"b&c");
        Assert.assertEquals((Object)map.get("b"), (Object)"c");
    }
}

