/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.StructuralSiteNode;

public class Target {
    private List<StructuralNode> startNodes;
    private Context context;
    private boolean inScopeOnly = false;
    private int maxChildren = -1;
    private int maxDepth = -1;
    private boolean recurse = false;

    public Target(boolean bl) {
        this.inScopeOnly = bl;
    }

    public Target(StructuralNode structuralNode) {
        this.startNodes = new ArrayList<StructuralNode>();
        this.startNodes.add(structuralNode);
    }

    public Target(List<StructuralNode> list) {
        this.startNodes = list;
    }

    public Target(SiteNode siteNode) {
        this.setStartNode(siteNode);
    }

    public Target(SiteNode siteNode, boolean bl) {
        this(siteNode);
        this.setRecurse(bl);
    }

    public Target(Context context) {
        this.context = context;
    }

    public Target(SiteNode siteNode, Context context, boolean bl, int n, int n2) {
        this(siteNode);
        this.context = context;
        this.inScopeOnly = bl;
        this.maxChildren = n;
        this.maxDepth = n2;
    }

    public Target(SiteNode siteNode, Context context, boolean bl, boolean bl2) {
        this(siteNode);
        this.context = context;
        this.inScopeOnly = bl;
        this.recurse = bl2;
    }

    public boolean isValid() {
        return this.startNodes != null && this.startNodes.size() > 0 || this.context != null || this.inScopeOnly;
    }

    public SiteNode getStartNode() {
        if (this.startNodes != null && this.startNodes.size() > 0 && this.startNodes.get(0) instanceof StructuralSiteNode) {
            return ((StructuralSiteNode)this.startNodes.get(0)).getSiteNode();
        }
        return null;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isInScopeOnly() {
        return this.inScopeOnly;
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setStartNode(SiteNode siteNode) {
        this.startNodes = new ArrayList<StructuralNode>();
        this.startNodes.add(new StructuralSiteNode(siteNode));
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public List<StructuralNode> getStartNodes() {
        return this.startNodes;
    }

    public void setInScopeOnly(boolean bl) {
        this.inScopeOnly = bl;
    }

    public void setMaxChildren(int n) {
        this.maxChildren = n;
    }

    public void setMaxDepth(int n) {
        this.maxDepth = n;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public String getDisplayName() {
        if (this.getStartNode() == null) {
            if (this.context != null) {
                return Constant.messages.getString("context.prefixName", this.context.getName());
            }
            if (this.inScopeOnly) {
                return Constant.messages.getString("target.allInScope");
            }
            return Constant.messages.getString("target.empty");
        }
        String string = this.getStartNode().getHierarchicNodeName();
        if (string.length() < 30) {
            return string;
        }
        return string.substring(0, 14) + ".." + string.substring(string.length() - 15, string.length());
    }
}

