/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.users;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.authentication.ExtensionAuthentication;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.users.User;

@RunWith(value=MockitoJUnitRunner.class)
public class UserUnitTest {
    private static final String USER_NAME = "username";
    private static int CONTEXT_ID = 23;
    private static ExtensionAuthentication mockedExtension;
    private static AuthenticationMethodType mockedType;
    private static AuthenticationMethod mockedAuthenticationMethod;
    private static Context mockedContext;
    private static AuthenticationCredentials mockedCredentials;
    private static SessionManagementMethod mockedSessionManagementMethod;

    @BeforeClass
    public static void classSetUp() {
        mockedCredentials = (AuthenticationCredentials)Mockito.mock(AuthenticationCredentials.class);
        Mockito.when((Object)mockedCredentials.encode(org.mockito.Matchers.anyString())).thenReturn((Object)"[credentials]");
        mockedType = (AuthenticationMethodType)Mockito.mock(AuthenticationMethodType.class);
        Mockito.when((Object)mockedType.getUniqueIdentifier()).thenReturn((Object)99);
        Mockito.when((Object)mockedType.createAuthenticationCredentials()).thenReturn((Object)mockedCredentials);
        mockedAuthenticationMethod = (AuthenticationMethod)Mockito.mock(AuthenticationMethod.class);
        Mockito.when((Object)mockedAuthenticationMethod.getType()).thenReturn((Object)mockedType);
        Mockito.when((Object)mockedAuthenticationMethod.authenticate((SessionManagementMethod)org.mockito.Matchers.anyObject(), (AuthenticationCredentials)org.mockito.Matchers.anyObject(), (User)org.mockito.Matchers.anyObject())).thenReturn(Mockito.mock(WebSession.class));
        mockedSessionManagementMethod = (SessionManagementMethod)Mockito.mock(SessionManagementMethod.class);
        ((SessionManagementMethod)Mockito.doNothing().when((Object)mockedSessionManagementMethod)).processMessageToMatchSession((HttpMessage)org.mockito.Matchers.anyObject(), (WebSession)org.mockito.Matchers.anyObject());
        mockedContext = (Context)Mockito.mock(Context.class);
        Mockito.when((Object)mockedContext.getAuthenticationMethod()).thenReturn((Object)mockedAuthenticationMethod);
        Mockito.when((Object)mockedContext.getSessionManagementMethod()).thenReturn((Object)mockedSessionManagementMethod);
        mockedExtension = (ExtensionAuthentication)Mockito.mock(ExtensionAuthentication.class);
        Mockito.when((Object)mockedExtension.getAuthenticationMethodTypeForIdentifier(org.mockito.Matchers.anyInt())).thenReturn((Object)mockedType);
    }

    @Test
    public void shouldEncodeAndDecodeProperly() {
        User user = (User)Mockito.spy((Object)new User(CONTEXT_ID, USER_NAME));
        user.setAuthenticationCredentials(mockedCredentials);
        ((User)Mockito.doReturn((Object)mockedContext).when((Object)user)).getContext();
        String string = User.encode(user);
        User user2 = User.decode(CONTEXT_ID, string, mockedExtension);
        Assert.assertEquals((Object)user.getName(), (Object)user2.getName());
        Assert.assertEquals((Object)user.isEnabled(), (Object)user2.isEnabled());
        Assert.assertEquals((long)user.getId(), (long)user2.getId());
        Assert.assertEquals((long)user.getContextId(), (long)user2.getContextId());
    }

    @Test
    public void shouldGenerateUniqueIds() {
        User user = new User(CONTEXT_ID, USER_NAME);
        User user2 = new User(CONTEXT_ID, USER_NAME);
        User user3 = new User(CONTEXT_ID, USER_NAME);
        User user4 = new User(CONTEXT_ID, USER_NAME);
        MatcherAssert.assertThat((Object)user.getId(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.is((Object)user2.getId()), CoreMatchers.is((Object)user3.getId()), CoreMatchers.is((Object)user4.getId())})));
        MatcherAssert.assertThat((Object)user2.getId(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.is((Object)user3.getId()), CoreMatchers.is((Object)user4.getId())})));
        MatcherAssert.assertThat((Object)user3.getId(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)user4.getId())));
        User user5 = new User(CONTEXT_ID, USER_NAME, user4.getId() + 5);
        User user6 = new User(CONTEXT_ID, USER_NAME);
        MatcherAssert.assertThat((Object)user6.getId(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(user5.getId())));
    }

    @Test
    public void shouldRequireAuthenticationAfterInitialization() {
        User user = new User(CONTEXT_ID, USER_NAME);
        Assert.assertTrue((boolean)user.requiresAuthentication());
    }

    @Test
    public void shouldRequireAuthenticationAfterAuthentication() {
        User user = new User(CONTEXT_ID, USER_NAME);
        user.setAuthenticatedSession((WebSession)Mockito.mock(WebSession.class));
        Assert.assertFalse((boolean)user.requiresAuthentication());
    }

    @Test
    public void shouldRequireAuthenticationAfterResetWithNewerMessage() {
        User user = (User)Mockito.spy((Object)new User(CONTEXT_ID, USER_NAME));
        user.setAuthenticatedSession((WebSession)Mockito.mock(WebSession.class));
        ((User)Mockito.doReturn((Object)3500L).when((Object)user)).getLastSuccessfulAuthTime();
        HttpMessage httpMessage = (HttpMessage)Mockito.mock(HttpMessage.class);
        Mockito.when((Object)httpMessage.getTimeSentMillis()).thenReturn((Object)5000L);
        user.queueAuthentication(httpMessage);
        Assert.assertTrue((boolean)user.requiresAuthentication());
    }

    @Test
    public void shouldRequireAuthenticationAfterResetWithOlderMessage() {
        User user = (User)Mockito.spy((Object)new User(CONTEXT_ID, USER_NAME));
        user.setAuthenticatedSession((WebSession)Mockito.mock(WebSession.class));
        ((User)Mockito.doReturn((Object)3500L).when((Object)user)).getLastSuccessfulAuthTime();
        HttpMessage httpMessage = (HttpMessage)Mockito.mock(HttpMessage.class);
        Mockito.when((Object)httpMessage.getTimeSentMillis()).thenReturn((Object)3200L);
        user.queueAuthentication(httpMessage);
        ((HttpMessage)Mockito.verify((Object)httpMessage)).getTimeSentMillis();
        Assert.assertFalse((boolean)user.requiresAuthentication());
    }

    @Test
    public void shouldAuthenticateWhenRequired() {
        User user = (User)Mockito.spy((Object)new User(CONTEXT_ID, USER_NAME));
        ((User)Mockito.doReturn((Object)mockedContext).when((Object)user)).getContext();
        ((User)Mockito.doReturn((Object)true).when((Object)user)).requiresAuthentication();
        ((User)Mockito.doNothing().when((Object)user)).authenticate();
        user.processMessageToMatchUser((HttpMessage)Mockito.mock(HttpMessage.class));
        ((User)Mockito.verify((Object)user)).authenticate();
    }

    @Test
    public void shouldNotAuthenticateIfNotRequired() {
        User user = (User)Mockito.spy((Object)new User(CONTEXT_ID, USER_NAME));
        ((User)Mockito.doReturn((Object)mockedContext).when((Object)user)).getContext();
        ((User)Mockito.doReturn((Object)false).when((Object)user)).requiresAuthentication();
        ((User)Mockito.doNothing().when((Object)user)).authenticate();
        user.processMessageToMatchUser((HttpMessage)Mockito.mock(HttpMessage.class));
        ((User)Mockito.verify((Object)user, (VerificationMode)Mockito.never())).authenticate();
    }

    @Test
    public void shouldNotRequireAuthenticationAfterAuthentication() {
        User user = (User)Mockito.spy((Object)new User(CONTEXT_ID, USER_NAME));
        ((User)Mockito.doReturn((Object)mockedContext).when((Object)user)).getContext();
        user.authenticate();
        Assert.assertFalse((boolean)user.requiresAuthentication());
    }
}

