/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.zaproxy.zap.utils.BoyerMooreMatcher;

public class BoyerMooreMatcherUnitTest {
    private static final String CONTENT = "The quick brown fox jumps over the lazy dog.";

    @Test(expected=NullPointerException.class)
    public void shouldFailToCreateMatcherIfPatternIsNull() {
        new BoyerMooreMatcher(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldFailToFindInNullContent() {
        BoyerMooreMatcher boyerMooreMatcher = new BoyerMooreMatcher("");
        boyerMooreMatcher.findInContent(null);
    }

    @Test
    public void shouldReturnPatternPassedInCronstructor() {
        String string = "pattern";
        BoyerMooreMatcher boyerMooreMatcher = new BoyerMooreMatcher(string);
        String string2 = boyerMooreMatcher.getPattern();
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)string)));
    }

    @Test
    public void shouldFindPatternAtBeginOfContent() {
        String string = "The quick";
        BoyerMooreMatcher boyerMooreMatcher = new BoyerMooreMatcher(string);
        int n = boyerMooreMatcher.findInContent(CONTENT);
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void shouldFindPatternInMiddleOfContent() {
        String string = "jumps";
        BoyerMooreMatcher boyerMooreMatcher = new BoyerMooreMatcher(string);
        int n = boyerMooreMatcher.findInContent(CONTENT);
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)20)));
    }

    @Test
    public void shouldFindPatternAtEndOfContent() {
        String string = "lazy dog.";
        BoyerMooreMatcher boyerMooreMatcher = new BoyerMooreMatcher(string);
        int n = boyerMooreMatcher.findInContent(CONTENT);
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)35)));
    }

    @Test
    public void shouldFindPatternEqualToContent() {
        String string = CONTENT;
        BoyerMooreMatcher boyerMooreMatcher = new BoyerMooreMatcher(string);
        int n = boyerMooreMatcher.findInContent(CONTENT);
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void shouldReturnIdxOfFirstOccurrenceIfPatternRepeated() {
        String string = "e";
        BoyerMooreMatcher boyerMooreMatcher = new BoyerMooreMatcher(string);
        int n = boyerMooreMatcher.findInContent("A e B e C e D");
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)2)));
    }

    @Test
    public void shouldFindEmptyPatternAtIdxZero() {
        String string = "";
        BoyerMooreMatcher boyerMooreMatcher = new BoyerMooreMatcher(string);
        int n = boyerMooreMatcher.findInContent(CONTENT);
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void shouldNotFindAnInexistentPattern() {
        String string = "not in content";
        BoyerMooreMatcher boyerMooreMatcher = new BoyerMooreMatcher(string);
        int n = boyerMooreMatcher.findInContent(CONTENT);
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)-1)));
    }
}

