/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.put;

import com.carrotsearch.hppc.ObjectHashSet;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;

public class PutMappingRequest
extends AcknowledgedRequest<PutMappingRequest>
implements IndicesRequest.Replaceable {
    private static ObjectHashSet<String> RESERVED_FIELDS = ObjectHashSet.from((Object[])new String[]{"_uid", "_id", "_type", "_source", "_all", "_analyzer", "_parent", "_routing", "_index", "_size", "_timestamp", "_ttl"});
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, true);
    private String type;
    private String source;
    private boolean updateAllTypes = false;

    PutMappingRequest() {
    }

    public PutMappingRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("mapping type is missing", validationException);
        } else if (this.type.isEmpty()) {
            validationException = ValidateActions.addValidationError("mapping type is empty", validationException);
        }
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("mapping source is missing", validationException);
        } else if (this.source.isEmpty()) {
            validationException = ValidateActions.addValidationError("mapping source is empty", validationException);
        }
        return validationException;
    }

    @Override
    public PutMappingRequest indices(String[] indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public PutMappingRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String type() {
        return this.type;
    }

    public PutMappingRequest type(String type) {
        this.type = type;
        return this;
    }

    public String source() {
        return this.source;
    }

    public PutMappingRequest source(Object ... source) {
        return this.source(PutMappingRequest.buildFromSimplifiedDef(this.type, source));
    }

    public static XContentBuilder buildFromSimplifiedDef(String type, Object ... source) {
        try {
            String[] s2;
            String[] s1;
            String fieldName;
            int i;
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            if (type != null) {
                builder.startObject(type);
            }
            for (i = 0; i < source.length; ++i) {
                if (!RESERVED_FIELDS.contains((Object)(fieldName = source[i++].toString()))) continue;
                builder.startObject(fieldName);
                for (String s : s1 = Strings.splitStringByCommaToArray(source[i].toString())) {
                    s2 = Strings.split(s, "=");
                    if (s2.length != 2) {
                        throw new IllegalArgumentException("malformed " + s);
                    }
                    builder.field(s2[0], s2[1]);
                }
                builder.endObject();
            }
            builder.startObject("properties");
            for (i = 0; i < source.length; ++i) {
                if (RESERVED_FIELDS.contains((Object)(fieldName = source[i++].toString()))) continue;
                builder.startObject(fieldName);
                for (String s : s1 = Strings.splitStringByCommaToArray(source[i].toString())) {
                    s2 = Strings.split(s, "=");
                    if (s2.length != 2) {
                        throw new IllegalArgumentException("malformed " + s);
                    }
                    builder.field(s2[0], s2[1]);
                }
                builder.endObject();
            }
            builder.endObject();
            if (type != null) {
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to generate simplified mapping definition", e);
        }
    }

    public PutMappingRequest source(XContentBuilder mappingBuilder) {
        try {
            return this.source(mappingBuilder.string());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to build json for mapping request", e);
        }
    }

    public PutMappingRequest source(Map mappingSource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(mappingSource);
            return this.source(builder.string());
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + mappingSource + "]", e);
        }
    }

    public PutMappingRequest source(String mappingSource) {
        this.source = mappingSource;
        return this;
    }

    public boolean updateAllTypes() {
        return this.updateAllTypes;
    }

    public PutMappingRequest updateAllTypes(boolean updateAllTypes) {
        this.updateAllTypes = updateAllTypes;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.type = in.readOptionalString();
        this.source = in.readString();
        this.updateAllTypes = in.readBoolean();
        this.readTimeout(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeOptionalString(this.type);
        out.writeString(this.source);
        out.writeBoolean(this.updateAllTypes);
        this.writeTimeout(out);
    }
}

