/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.nodes;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.NoSuchNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.NodeShouldNotConnectException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportNodesAction<NodesRequest extends BaseNodesRequest, NodesResponse extends BaseNodesResponse, NodeRequest extends BaseNodeRequest, NodeResponse extends BaseNodeResponse>
extends HandledTransportAction<NodesRequest, NodesResponse> {
    protected final ClusterName clusterName;
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    final String transportNodeAction;

    protected TransportNodesAction(Settings settings, String actionName, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Class<NodesRequest> request, Class<NodeRequest> nodeRequest, String nodeExecutor) {
        super(settings, actionName, threadPool, transportService, actionFilters, indexNameExpressionResolver, request);
        this.clusterName = clusterName;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.transportNodeAction = actionName + "[n]";
        transportService.registerRequestHandler(this.transportNodeAction, nodeRequest, nodeExecutor, new NodeTransportHandler());
    }

    @Override
    protected void doExecute(NodesRequest request, ActionListener<NodesResponse> listener) {
        new AsyncAction(this, (BaseNodesRequest)request, listener).start();
    }

    protected boolean transportCompress() {
        return false;
    }

    protected abstract NodesResponse newResponse(NodesRequest var1, AtomicReferenceArray var2);

    protected abstract NodeRequest newNodeRequest(String var1, NodesRequest var2);

    protected abstract NodeResponse newNodeResponse();

    protected abstract NodeResponse nodeOperation(NodeRequest var1);

    protected abstract boolean accumulateExceptions();

    protected String[] filterNodeIds(DiscoveryNodes nodes, String[] nodesIds) {
        return nodesIds;
    }

    protected String[] resolveNodes(NodesRequest request, ClusterState clusterState) {
        return clusterState.nodes().resolveNodesIds(((BaseNodesRequest)request).nodesIds());
    }

    class NodeTransportHandler
    implements TransportRequestHandler<NodeRequest> {
        NodeTransportHandler() {
        }

        @Override
        public void messageReceived(NodeRequest request, TransportChannel channel) throws Exception {
            channel.sendResponse((TransportResponse)TransportNodesAction.this.nodeOperation(request));
        }
    }

    private static class AsyncAction {
        private final NodesRequest request;
        private final String[] nodesIds;
        private final DiscoveryNode[] nodes;
        private final ActionListener<NodesResponse> listener;
        private final AtomicReferenceArray<Object> responses;
        private final AtomicInteger counter = new AtomicInteger();
        final /* synthetic */ TransportNodesAction this$0;

        private AsyncAction(NodesRequest request, ActionListener<NodesResponse> listener) {
            this.this$0 = var1_1;
            this.request = request;
            this.listener = listener;
            ClusterState clusterState = var1_1.clusterService.state();
            String[] nodesIds = var1_1.resolveNodes(request, clusterState);
            this.nodesIds = var1_1.filterNodeIds(clusterState.nodes(), nodesIds);
            ImmutableOpenMap<String, DiscoveryNode> nodes = clusterState.nodes().nodes();
            this.nodes = new DiscoveryNode[nodesIds.length];
            for (int i = 0; i < nodesIds.length; ++i) {
                this.nodes[i] = nodes.get(nodesIds[i]);
            }
            this.responses = new AtomicReferenceArray(this.nodesIds.length);
        }

        private void start() {
            if (this.nodesIds.length == 0) {
                this.this$0.threadPool.generic().execute(new Runnable(){

                    @Override
                    public void run() {
                        AsyncAction.this.listener.onResponse(AsyncAction.this.this$0.newResponse(AsyncAction.this.request, AsyncAction.this.responses));
                    }
                });
                return;
            }
            TransportRequestOptions transportRequestOptions = TransportRequestOptions.options();
            if (((BaseNodesRequest)this.request).timeout() != null) {
                transportRequestOptions.withTimeout(((BaseNodesRequest)this.request).timeout());
            }
            transportRequestOptions.withCompress(this.this$0.transportCompress());
            for (int i = 0; i < this.nodesIds.length; ++i) {
                String nodeId = this.nodesIds[i];
                final int idx = i;
                final DiscoveryNode node = this.nodes[i];
                try {
                    if (node == null) {
                        this.onFailure(idx, nodeId, new NoSuchNodeException(nodeId));
                        continue;
                    }
                    if (!this.this$0.clusterService.localNode().shouldConnectTo(node) && !this.this$0.clusterService.localNode().equals(node)) {
                        this.onFailure(idx, nodeId, new NodeShouldNotConnectException(this.this$0.clusterService.localNode(), node));
                        continue;
                    }
                    Object nodeRequest = this.this$0.newNodeRequest(nodeId, this.request);
                    this.this$0.transportService.sendRequest(node, this.this$0.transportNodeAction, (TransportRequest)nodeRequest, transportRequestOptions, new BaseTransportResponseHandler<NodeResponse>(){

                        @Override
                        public NodeResponse newInstance() {
                            return AsyncAction.this.this$0.newNodeResponse();
                        }

                        @Override
                        public void handleResponse(NodeResponse response) {
                            AsyncAction.this.onOperation(idx, response);
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            AsyncAction.this.onFailure(idx, node.id(), exp);
                        }

                        @Override
                        public String executor() {
                            return "same";
                        }
                    });
                    continue;
                }
                catch (Throwable t) {
                    this.onFailure(idx, nodeId, t);
                }
            }
        }

        private void onOperation(int idx, NodeResponse nodeResponse) {
            this.responses.set(idx, nodeResponse);
            if (this.counter.incrementAndGet() == this.responses.length()) {
                this.finishHim();
            }
        }

        private void onFailure(int idx, String nodeId, Throwable t) {
            if (this.this$0.logger.isDebugEnabled() && !(t instanceof NodeShouldNotConnectException)) {
                this.this$0.logger.debug("failed to execute on node [{}]", t, nodeId);
            }
            if (this.this$0.accumulateExceptions()) {
                this.responses.set(idx, new FailedNodeException(nodeId, "Failed node [" + nodeId + "]", t));
            }
            if (this.counter.incrementAndGet() == this.responses.length()) {
                this.finishHim();
            }
        }

        private void finishHim() {
            Object finalResponse;
            try {
                finalResponse = this.this$0.newResponse(this.request, this.responses);
            }
            catch (Throwable t) {
                this.this$0.logger.debug("failed to combine responses from nodes", t, new Object[0]);
                this.listener.onFailure(t);
                return;
            }
            this.listener.onResponse(finalResponse);
        }
    }
}

