/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.pattern.XPatternTokenizer;
import org.apache.lucene.analysis.util.CharArraySet;

public final class PatternAnalyzer
extends Analyzer {
    private final Pattern pattern;
    private final boolean lowercase;
    private final CharArraySet stopWords;

    public PatternAnalyzer(Pattern pattern, boolean lowercase, CharArraySet stopWords) {
        this.pattern = pattern;
        this.lowercase = lowercase;
        this.stopWords = stopWords;
    }

    protected Analyzer.TokenStreamComponents createComponents(String s) {
        XPatternTokenizer tokenizer;
        XPatternTokenizer stream = tokenizer = new XPatternTokenizer(this.pattern, -1);
        if (this.lowercase) {
            stream = new LowerCaseFilter((TokenStream)stream);
        }
        if (this.stopWords != null) {
            stream = new StopFilter((TokenStream)stream, this.stopWords);
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
    }
}

