/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractIndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointDoubleArrayAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.NonEstimatingEstimator;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

public class GeoPointDoubleArrayIndexFieldData
extends AbstractIndexGeoPointFieldData {
    private final CircuitBreakerService breakerService;

    public GeoPointDoubleArrayIndexFieldData(Index index, Settings indexSettings, MappedFieldType.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        this.breakerService = breakerService;
    }

    /*
     * Loose catch block
     */
    @Override
    public AtomicGeoPointFieldData loadDirect(LeafReaderContext context) throws Exception {
        LeafReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        AtomicGeoPointFieldData data = null;
        NonEstimatingEstimator estimator = new NonEstimatingEstimator(this.breakerService.getBreaker("fielddata"));
        if (terms == null) {
            data = AbstractAtomicGeoPointFieldData.empty(reader.maxDoc());
            estimator.afterLoad(null, data.ramBytesUsed());
            return data;
        }
        DoubleArray lat = BigArrays.NON_RECYCLING_INSTANCE.newDoubleArray(128L);
        DoubleArray lon = BigArrays.NON_RECYCLING_INSTANCE.newDoubleArray(128L);
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        boolean success = false;
        try {
            try (OrdinalsBuilder builder = new OrdinalsBuilder(terms.size(), reader.maxDoc(), acceptableTransientOverheadRatio);){
                GeoPoint point;
                AbstractIndexGeoPointFieldData.GeoPointEnum iter = new AbstractIndexGeoPointFieldData.GeoPointEnum(builder.buildFromTerms(terms.iterator()));
                long numTerms = 0L;
                while ((point = iter.next()) != null) {
                    lat = BigArrays.NON_RECYCLING_INSTANCE.resize(lat, numTerms + 1L);
                    lon = BigArrays.NON_RECYCLING_INSTANCE.resize(lon, numTerms + 1L);
                    lat.set(numTerms, point.getLat());
                    lon.set(numTerms, point.getLon());
                    ++numTerms;
                }
                lat = BigArrays.NON_RECYCLING_INSTANCE.resize(lat, numTerms);
                lon = BigArrays.NON_RECYCLING_INSTANCE.resize(lon, numTerms);
                Ordinals build = builder.build(this.fieldDataType.getSettings());
                RandomAccessOrds ordinals = build.ordinals();
                if (!FieldData.isMultiValued((SortedSetDocValues)ordinals) && IndexFieldData.CommonSettings.getMemoryStorageHint(this.fieldDataType) != IndexFieldData.CommonSettings.MemoryStorageFormat.ORDINALS) {
                    int maxDoc = reader.maxDoc();
                    DoubleArray sLat = BigArrays.NON_RECYCLING_INSTANCE.newDoubleArray(reader.maxDoc());
                    DoubleArray sLon = BigArrays.NON_RECYCLING_INSTANCE.newDoubleArray(reader.maxDoc());
                    for (int i = 0; i < maxDoc; ++i) {
                        ordinals.setDocument(i);
                        long nativeOrdinal = ordinals.nextOrd();
                        if (nativeOrdinal == -1L) continue;
                        sLat.set(i, lat.get(nativeOrdinal));
                        sLon.set(i, lon.get(nativeOrdinal));
                    }
                    BitSet set = builder.buildDocsWithValuesSet();
                    data = new GeoPointDoubleArrayAtomicFieldData.Single(sLon, sLat, set);
                } else {
                    data = new GeoPointDoubleArrayAtomicFieldData.WithOrdinals(lon, lat, build, reader.maxDoc());
                }
                success = true;
                AtomicGeoPointFieldData atomicGeoPointFieldData = data;
                return atomicGeoPointFieldData;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (success) {
                estimator.afterLoad(null, data.ramBytesUsed());
            }
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, Settings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            return new GeoPointDoubleArrayIndexFieldData(index, indexSettings, fieldType.names(), fieldType.fieldDataType(), cache, breakerService);
        }
    }
}

