/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.queries.TermsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.MergeResult;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.QueryParseContext;

public class ParentFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_parent";
    public static final String CONTENT_TYPE = "_parent";
    private final String parentType;
    private MappedFieldType childJoinFieldType;
    private final MappedFieldType parentJoinFieldType;

    private ParentFieldMapper(MappedFieldType fieldType, MappedFieldType parentJoinFieldType, MappedFieldType childJoinFieldType, String parentType, Settings indexSettings) {
        super("_parent", fieldType, Defaults.FIELD_TYPE, indexSettings);
        this.parentType = parentType;
        this.parentJoinFieldType = parentJoinFieldType;
        this.parentJoinFieldType.freeze();
        this.childJoinFieldType = childJoinFieldType;
        if (childJoinFieldType != null) {
            this.childJoinFieldType.freeze();
        }
    }

    private ParentFieldMapper(Settings indexSettings, MappedFieldType existing, String parentType) {
        this(existing == null ? Defaults.FIELD_TYPE.clone() : existing.clone(), ParentFieldMapper.joinFieldTypeForParentType(parentType, indexSettings), null, null, indexSettings);
    }

    private static MappedFieldType joinFieldTypeForParentType(String parentType, Settings indexSettings) {
        MappedFieldType parentJoinFieldType = Defaults.JOIN_FIELD_TYPE.clone();
        parentJoinFieldType.setNames(new MappedFieldType.Names(ParentFieldMapper.joinField(parentType)));
        Version indexCreated = Version.indexCreated(indexSettings);
        if (indexCreated.before(Version.V_2_0_0_beta1)) {
            parentJoinFieldType.setHasDocValues(false);
            parentJoinFieldType.setDocValuesType(DocValuesType.NONE);
        }
        parentJoinFieldType.freeze();
        return parentJoinFieldType;
    }

    public MappedFieldType getParentJoinFieldType() {
        return this.parentJoinFieldType;
    }

    public MappedFieldType getChildJoinFieldType() {
        return this.childJoinFieldType;
    }

    public String type() {
        return this.parentType;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        if (!context.sourceToParse().flyweight()) {
            this.parse(context);
        }
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        boolean parent = context.docMapper().isParent(context.type());
        if (parent) {
            this.addJoinFieldIfNeeded(fields, this.parentJoinFieldType, context.id());
        }
        if (!this.active()) {
            return;
        }
        if (context.parser().currentName() != null && context.parser().currentName().equals("_parent")) {
            String parentId = context.parser().text();
            context.sourceToParse().parent(parentId);
            fields.add(new Field(this.fieldType().names().indexName(), Uid.createUid(context.stringBuilder(), this.parentType, parentId), (FieldType)this.fieldType()));
            this.addJoinFieldIfNeeded(fields, this.childJoinFieldType, parentId);
        } else {
            String parsedParentId = context.doc().get("_parent");
            if (context.sourceToParse().parent() != null) {
                String parentId = context.sourceToParse().parent();
                if (parsedParentId == null) {
                    if (parentId == null) {
                        throw new MapperParsingException("No parent id provided, not within the document, and not externally");
                    }
                    fields.add(new Field(this.fieldType().names().indexName(), Uid.createUid(context.stringBuilder(), this.parentType, parentId), (FieldType)this.fieldType()));
                    this.addJoinFieldIfNeeded(fields, this.childJoinFieldType, parentId);
                } else if (parentId != null && !parsedParentId.equals(Uid.createUid(context.stringBuilder(), this.parentType, parentId))) {
                    throw new MapperParsingException("Parent id mismatch, document value is [" + Uid.createUid(parsedParentId).id() + "], while external value is [" + parentId + "]");
                }
            }
        }
    }

    private void addJoinFieldIfNeeded(List<Field> fields, MappedFieldType fieldType, String id) {
        if (fieldType.hasDocValues()) {
            fields.add((Field)new SortedDocValuesField(fieldType.names().indexName(), new BytesRef((CharSequence)id)));
        }
    }

    public static String joinField(String parentType) {
        return "_parent#" + parentType;
    }

    @Override
    protected String contentType() {
        return "_parent";
    }

    private boolean joinFieldHasCustomFieldDataSettings() {
        return this.childJoinFieldType != null && this.childJoinFieldType.fieldDataType() != null && !this.childJoinFieldType.fieldDataType().equals(Defaults.JOIN_FIELD_TYPE.fieldDataType());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.active()) {
            return builder;
        }
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        builder.startObject("_parent");
        builder.field("type", this.parentType);
        if (includeDefaults || this.joinFieldHasCustomFieldDataSettings()) {
            builder.field("fielddata", this.childJoinFieldType.fieldDataType().getSettings().getAsMap());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeResult mergeResult) throws MergeMappingException {
        super.merge(mergeWith, mergeResult);
        ParentFieldMapper fieldMergeWith = (ParentFieldMapper)mergeWith;
        if (!Objects.equals(this.parentType, fieldMergeWith.parentType)) {
            mergeResult.addConflict("The _parent field's type option can't be changed: [" + this.parentType + "]->[" + fieldMergeWith.parentType + "]");
        }
        ArrayList<String> conflicts = new ArrayList<String>();
        this.fieldType().checkCompatibility(fieldMergeWith.fieldType(), conflicts, true);
        this.parentJoinFieldType.checkCompatibility(fieldMergeWith.parentJoinFieldType, conflicts, true);
        if (this.childJoinFieldType != null) {
            this.childJoinFieldType.checkCompatibility(fieldMergeWith.childJoinFieldType, conflicts, !mergeResult.updateAllTypes());
        }
        for (String conflict : conflicts) {
            mergeResult.addConflict(conflict);
        }
        if (this.active() && !mergeResult.simulate() && !mergeResult.hasConflicts()) {
            this.childJoinFieldType = fieldMergeWith.childJoinFieldType.clone();
        }
    }

    public boolean active() {
        return this.parentType != null;
    }

    static final class ParentFieldType
    extends MappedFieldType {
        public ParentFieldType() {
            this.setFieldDataType(new FieldDataType("_parent", Settings.settingsBuilder().put("loading", "eager")));
        }

        protected ParentFieldType(ParentFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new ParentFieldType(this);
        }

        @Override
        public String typeName() {
            return "_parent";
        }

        @Override
        public Uid value(Object value) {
            if (value == null) {
                return null;
            }
            return Uid.createUid(value.toString());
        }

        @Override
        public Object valueForSearch(Object value) {
            if (value == null) {
                return null;
            }
            String sValue = value.toString();
            if (sValue == null) {
                return null;
            }
            int index = sValue.indexOf(35);
            if (index == -1) {
                return sValue;
            }
            return sValue.substring(index + 1);
        }

        @Override
        public boolean useTermQueryWithQueryString() {
            return true;
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryParseContext context) {
            return this.termsQuery(Collections.singletonList(value), context);
        }

        @Override
        public Query termsQuery(List values, @Nullable QueryParseContext context) {
            if (context == null) {
                return super.termsQuery(values, context);
            }
            ArrayList<String> types = new ArrayList<String>(context.mapperService().types().size());
            for (DocumentMapper documentMapper : context.mapperService().docMappers(false)) {
                if (documentMapper.parentFieldMapper().active()) continue;
                types.add(documentMapper.type());
            }
            ArrayList<BytesRef> bValues = new ArrayList<BytesRef>(values.size());
            for (Object value : values) {
                BytesRef bValue = BytesRefs.toBytesRef(value);
                if (Uid.hasDelimiter(bValue)) {
                    bValues.add(bValue);
                    continue;
                }
                for (String type : types) {
                    bValues.add(Uid.createUidAsBytes(type, bValue));
                }
            }
            return new TermsQuery(this.names().indexName(), bValues);
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(parserContext.type());
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("type")) {
                    builder.type(fieldNode.toString());
                    iterator.remove();
                    continue;
                }
                if (fieldName.equals("postings_format") && parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) {
                    iterator.remove();
                    continue;
                }
                if (!fieldName.equals("fielddata")) continue;
                Map<String, String> fieldDataSettings = SettingsLoader.Helper.loadNestedFromMap(XContentMapValues.nodeMapValue(fieldNode, "fielddata"));
                if (fieldDataSettings.containsKey("loading")) {
                    Settings settings = Settings.settingsBuilder().put("loading", fieldDataSettings.get("loading")).build();
                    builder.fieldDataSettings(settings);
                }
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(Settings indexSettings, MappedFieldType fieldType, String parentType) {
            return new ParentFieldMapper(indexSettings, fieldType, parentType);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, ParentFieldMapper> {
        private String parentType;
        protected String indexName;
        private final String documentType;
        private final MappedFieldType parentJoinFieldType = Defaults.JOIN_FIELD_TYPE.clone();
        private final MappedFieldType childJoinFieldType = Defaults.JOIN_FIELD_TYPE.clone();

        public Builder(String documentType) {
            super("_parent", Defaults.FIELD_TYPE);
            this.indexName = this.name;
            this.documentType = documentType;
            this.builder = this;
        }

        public Builder type(String type) {
            this.parentType = type;
            return (Builder)this.builder;
        }

        @Override
        public Builder fieldDataSettings(Settings fieldDataSettings) {
            Settings settings = Settings.builder().put(this.childJoinFieldType.fieldDataType().getSettings()).put(fieldDataSettings).build();
            this.childJoinFieldType.setFieldDataType(new FieldDataType(this.childJoinFieldType.fieldDataType().getType(), settings));
            return this;
        }

        @Override
        public ParentFieldMapper build(Mapper.BuilderContext context) {
            if (this.parentType == null) {
                throw new MapperParsingException("[_parent] field mapping must contain the [type] option");
            }
            this.parentJoinFieldType.setNames(new MappedFieldType.Names(ParentFieldMapper.joinField(this.documentType)));
            this.parentJoinFieldType.setFieldDataType(null);
            this.childJoinFieldType.setNames(new MappedFieldType.Names(ParentFieldMapper.joinField(this.parentType)));
            if (context.indexCreatedVersion().before(Version.V_2_0_0_beta1)) {
                this.childJoinFieldType.setHasDocValues(false);
                this.childJoinFieldType.setDocValuesType(DocValuesType.NONE);
                this.parentJoinFieldType.setHasDocValues(false);
                this.parentJoinFieldType.setDocValuesType(DocValuesType.NONE);
            }
            return new ParentFieldMapper(this.fieldType, this.parentJoinFieldType, this.childJoinFieldType, this.parentType, context.indexSettings());
        }
    }

    public static class Defaults {
        public static final String NAME = "_parent";
        public static final MappedFieldType FIELD_TYPE = new ParentFieldType();
        public static final MappedFieldType JOIN_FIELD_TYPE = new ParentFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setNames(new MappedFieldType.Names("_parent"));
            FIELD_TYPE.freeze();
            JOIN_FIELD_TYPE.setHasDocValues(true);
            JOIN_FIELD_TYPE.setDocValuesType(DocValuesType.SORTED);
            JOIN_FIELD_TYPE.freeze();
        }
    }
}

