/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.query.HasChildQueryParser;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.InnerHitsQueryParserHelper;
import org.elasticsearch.index.query.support.XContentStructure;
import org.elasticsearch.index.search.child.ParentConstantScoreQuery;
import org.elasticsearch.index.search.child.ParentQuery;
import org.elasticsearch.index.search.child.ScoreType;
import org.elasticsearch.search.fetch.innerhits.InnerHitsContext;
import org.elasticsearch.search.fetch.innerhits.InnerHitsSubSearchContext;

public class HasParentQueryParser
implements QueryParser {
    public static final String NAME = "has_parent";
    private static final ParseField QUERY_FIELD = new ParseField("query", "filter");
    private static final ParseField SCORE_MODE = new ParseField("score_mode", "score_type");
    private final InnerHitsQueryParserHelper innerHitsQueryParserHelper;

    @Inject
    public HasParentQueryParser(InnerHitsQueryParserHelper innerHitsQueryParserHelper) {
        this.innerHitsQueryParserHelper = innerHitsQueryParserHelper;
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean queryFound = false;
        float boost = 1.0f;
        String parentType = null;
        boolean score = false;
        String queryName = null;
        InnerHitsSubSearchContext innerHits = null;
        String currentFieldName = null;
        XContentStructure.InnerQuery iq = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (parseContext.parseFieldMatcher().match(currentFieldName, QUERY_FIELD)) {
                    String[] stringArray;
                    if (parentType == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = parentType;
                    }
                    iq = new XContentStructure.InnerQuery(parseContext, stringArray);
                    queryFound = true;
                    continue;
                }
                if ("inner_hits".equals(currentFieldName)) {
                    innerHits = this.innerHitsQueryParserHelper.parse(parseContext);
                    continue;
                }
                throw new QueryParsingException(parseContext, "[has_parent] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if ("type".equals(currentFieldName) || "parent_type".equals(currentFieldName) || "parentType".equals(currentFieldName)) {
                parentType = parser.text();
                continue;
            }
            if (parseContext.parseFieldMatcher().match(currentFieldName, SCORE_MODE)) {
                String scoreTypeValue = parser.text();
                if ("score".equals(scoreTypeValue)) {
                    score = true;
                    continue;
                }
                if (!"none".equals(scoreTypeValue)) continue;
                score = false;
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext, "[has_parent] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (!queryFound) {
            throw new QueryParsingException(parseContext, "[has_parent] query requires 'query' field", new Object[0]);
        }
        if (parentType == null) {
            throw new QueryParsingException(parseContext, "[has_parent] query requires 'parent_type' field", new Object[0]);
        }
        Query innerQuery = iq.asQuery(parentType);
        if (innerQuery == null) {
            return null;
        }
        innerQuery.setBoost(boost);
        Query query = HasParentQueryParser.createParentQuery(innerQuery, parentType, score, parseContext, innerHits);
        if (query == null) {
            return null;
        }
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }

    static Query createParentQuery(Query innerQuery, String parentType, boolean score, QueryParseContext parseContext, InnerHitsSubSearchContext innerHits) throws IOException {
        DocumentMapper parentDocMapper = parseContext.mapperService().documentMapper(parentType);
        if (parentDocMapper == null) {
            throw new QueryParsingException(parseContext, "[has_parent] query configured 'parent_type' [" + parentType + "] is not a valid type", new Object[0]);
        }
        if (innerHits != null) {
            ParsedQuery parsedQuery = new ParsedQuery(innerQuery, parseContext.copyNamedQueries());
            InnerHitsContext.ParentChildInnerHits parentChildInnerHits = new InnerHitsContext.ParentChildInnerHits(innerHits.getSubSearchContext(), parsedQuery, null, parseContext.mapperService(), parentDocMapper);
            String name = innerHits.getName() != null ? innerHits.getName() : parentType;
            parseContext.addInnerHits(name, parentChildInnerHits);
        }
        HashSet<String> parentTypes = new HashSet<String>(5);
        parentTypes.add(parentDocMapper.type());
        ParentChildIndexFieldData parentChildIndexFieldData = null;
        for (DocumentMapper documentMapper : parseContext.mapperService().docMappers(false)) {
            ParentFieldMapper parentFieldMapper = documentMapper.parentFieldMapper();
            if (!parentFieldMapper.active()) continue;
            DocumentMapper parentTypeDocumentMapper = parseContext.mapperService().documentMapper(parentFieldMapper.type());
            parentChildIndexFieldData = (ParentChildIndexFieldData)parseContext.getForField(parentFieldMapper.fieldType());
            if (parentTypeDocumentMapper != null) continue;
            parentTypes.add(parentFieldMapper.type());
        }
        if (parentChildIndexFieldData == null) {
            throw new QueryParsingException(parseContext, "[has_parent] no _parent field configured", new Object[0]);
        }
        Query parentFilter = null;
        if (parentTypes.size() == 1) {
            DocumentMapper documentMapper;
            documentMapper = parseContext.mapperService().documentMapper((String)parentTypes.iterator().next());
            if (documentMapper != null) {
                parentFilter = documentMapper.typeFilter();
            }
        } else {
            BooleanQuery.Builder parentsFilter = new BooleanQuery.Builder();
            for (String parentTypeStr : parentTypes) {
                DocumentMapper documentMapper = parseContext.mapperService().documentMapper(parentTypeStr);
                if (documentMapper == null) continue;
                parentsFilter.add(documentMapper.typeFilter(), BooleanClause.Occur.SHOULD);
            }
            parentFilter = parentsFilter.build();
        }
        if (parentFilter == null) {
            return null;
        }
        innerQuery = Queries.filtered(innerQuery, parentDocMapper.typeFilter());
        QueryWrapperFilter childrenFilter = new QueryWrapperFilter(Queries.not(parentFilter));
        if (parseContext.indexVersionCreated().onOrAfter(Version.V_2_0_0_beta1)) {
            ScoreType scoreMode = score ? ScoreType.MAX : ScoreType.NONE;
            return HasChildQueryParser.joinUtilHelper(parentType, parentChildIndexFieldData, (Query)childrenFilter, scoreMode, innerQuery, 0, Integer.MAX_VALUE);
        }
        if (score) {
            return new ParentQuery(parentChildIndexFieldData, innerQuery, parentDocMapper.type(), (Filter)childrenFilter);
        }
        return new ParentConstantScoreQuery(parentChildIndexFieldData, innerQuery, parentDocMapper.type(), (Filter)childrenFilter);
    }
}

