/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParser;
import org.elasticsearch.index.query.functionscore.exp.ExponentialDecayFunctionParser;
import org.elasticsearch.index.query.functionscore.factor.FactorParser;
import org.elasticsearch.index.query.functionscore.fieldvaluefactor.FieldValueFactorFunctionParser;
import org.elasticsearch.index.query.functionscore.gauss.GaussDecayFunctionParser;
import org.elasticsearch.index.query.functionscore.lin.LinearDecayFunctionParser;
import org.elasticsearch.index.query.functionscore.random.RandomScoreFunctionParser;
import org.elasticsearch.index.query.functionscore.script.ScriptScoreFunctionParser;

public class ScoreFunctionParserMapper {
    protected Map<String, ScoreFunctionParser> functionParsers;

    @Inject
    public ScoreFunctionParserMapper(Set<ScoreFunctionParser> parsers) {
        HashMap<String, ScoreFunctionParser> map = new HashMap<String, ScoreFunctionParser>();
        this.addParser(new FactorParser(), map);
        this.addParser(new ScriptScoreFunctionParser(), map);
        this.addParser(new GaussDecayFunctionParser(), map);
        this.addParser(new LinearDecayFunctionParser(), map);
        this.addParser(new ExponentialDecayFunctionParser(), map);
        this.addParser(new RandomScoreFunctionParser(), map);
        this.addParser(new FieldValueFactorFunctionParser(), map);
        for (ScoreFunctionParser scoreFunctionParser : parsers) {
            this.addParser(scoreFunctionParser, map);
        }
        this.functionParsers = Collections.unmodifiableMap(map);
    }

    public ScoreFunctionParser get(QueryParseContext parseContext, String parserName) {
        ScoreFunctionParser functionParser = this.get(parserName);
        if (functionParser == null) {
            throw new QueryParsingException(parseContext, "No function with the name [" + parserName + "] is registered.", null);
        }
        return functionParser;
    }

    private ScoreFunctionParser get(String parserName) {
        return this.functionParsers.get(parserName);
    }

    private void addParser(ScoreFunctionParser scoreFunctionParser, Map<String, ScoreFunctionParser> map) {
        for (String name : scoreFunctionParser.getNames()) {
            map.put(name, scoreFunctionParser);
        }
    }
}

