/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.recovery.RecoveryResponse;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoverySourceHandler;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.transport.TransportService;

public class SharedFSRecoverySourceHandler
extends RecoverySourceHandler {
    private final IndexShard shard;
    private final StartRecoveryRequest request;

    public SharedFSRecoverySourceHandler(IndexShard shard, StartRecoveryRequest request, RecoverySettings recoverySettings, TransportService transportService, ESLogger logger) {
        super(shard, request, recoverySettings, transportService, logger);
        this.shard = shard;
        this.request = request;
    }

    @Override
    public RecoveryResponse recoverToTarget() {
        boolean engineClosed = false;
        try {
            this.logger.trace("{} recovery [phase1] to {}: skipping phase 1 for shared filesystem", this.request.shardId(), this.request.targetNode());
            if (this.isPrimaryRelocation()) {
                this.logger.debug("[phase1] closing engine on primary for shared filesystem recovery", new Object[0]);
                try {
                    engineClosed = true;
                    this.shard.engine().flushAndClose();
                }
                catch (IOException e) {
                    this.logger.warn("close engine failed", e, new Object[0]);
                    this.shard.failShard("failed to close engine (phase1)", e);
                }
            }
            this.prepareTargetForTranslog(Translog.View.EMPTY_VIEW);
            this.finalizeRecovery();
            return this.response;
        }
        catch (Throwable t) {
            if (engineClosed) {
                this.logger.info("recovery failed for primary shadow shard, failing shard", new Object[0]);
                this.shard.failShard("primary relocation failed on shared filesystem caused by: [" + t.getMessage() + "]", null);
            } else {
                this.logger.info("recovery failed on shared filesystem", t, new Object[0]);
            }
            throw t;
        }
    }

    @Override
    protected int sendSnapshot(Translog.Snapshot snapshot) {
        this.logger.trace("{} skipping recovery of translog snapshot on shared filesystem to: {}", this.shard.shardId(), this.request.targetNode());
        return 0;
    }

    private boolean isPrimaryRelocation() {
        return this.request.recoveryType() == RecoveryState.Type.RELOCATION && this.shard.routingEntry().primary();
    }
}

