/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.sampler.InternalSampler;
import org.elasticsearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParser;
import org.elasticsearch.search.internal.SearchContext;

public class SamplerParser
implements Aggregator.Parser {
    public static final int DEFAULT_SHARD_SAMPLE_SIZE = 100;
    public static final ParseField SHARD_SIZE_FIELD = new ParseField("shard_size", new String[0]);
    public static final ParseField MAX_DOCS_PER_VALUE_FIELD = new ParseField("max_docs_per_value", new String[0]);
    public static final ParseField EXECUTION_HINT_FIELD = new ParseField("execution_hint", new String[0]);
    public static final boolean DEFAULT_USE_GLOBAL_ORDINALS = false;
    public static final int MAX_DOCS_PER_VALUE_DEFAULT = 1;

    @Override
    public String type() {
        return InternalSampler.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        String executionHint = null;
        int shardSize = 100;
        int maxDocsPerValue = 1;
        ValuesSourceParser vsParser = null;
        boolean diversityChoiceMade = false;
        vsParser = ValuesSourceParser.any(aggregationName, InternalSampler.TYPE, context).scriptable(true).formattable(false).build();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (vsParser.token(currentFieldName, token, parser)) continue;
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if (context.parseFieldMatcher().match(currentFieldName, SHARD_SIZE_FIELD)) {
                    shardSize = parser.intValue();
                    continue;
                }
                if (context.parseFieldMatcher().match(currentFieldName, MAX_DOCS_PER_VALUE_FIELD)) {
                    diversityChoiceMade = true;
                    maxDocsPerValue = parser.intValue();
                    continue;
                }
                throw new SearchParseException(context, "Unsupported property \"" + currentFieldName + "\" for aggregation \"" + aggregationName, parser.getTokenLocation());
            }
            if (!vsParser.token(currentFieldName, token, parser)) {
                if (context.parseFieldMatcher().match(currentFieldName, EXECUTION_HINT_FIELD)) {
                    executionHint = parser.text();
                    continue;
                }
                throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].", parser.getTokenLocation());
            }
            throw new SearchParseException(context, "Unsupported property \"" + currentFieldName + "\" for aggregation \"" + aggregationName, parser.getTokenLocation());
        }
        ValuesSourceConfig vsConfig = vsParser.config();
        if (vsConfig.valid()) {
            return new SamplerAggregator.DiversifiedFactory(aggregationName, shardSize, executionHint, vsConfig, maxDocsPerValue);
        }
        if (diversityChoiceMade) {
            throw new SearchParseException(context, "Sampler aggregation has " + MAX_DOCS_PER_VALUE_FIELD.getPreferredName() + " setting but no \"field\" or \"script\" setting to provide values for aggregation \"" + aggregationName + "\"", parser.getTokenLocation());
        }
        return new SamplerAggregator.Factory(aggregationName, shardSize);
    }
}

