/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.concurrent.AsyncStoppable;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.internal.id.IdGenerator;
import org.gradle.messaging.dispatch.DiscardingFailureHandler;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.DispatchFailureHandler;
import org.gradle.messaging.remote.internal.AsyncConnection;
import org.gradle.messaging.remote.internal.AsyncConnectionAdapter;
import org.gradle.messaging.remote.internal.BroadcastSendProtocol;
import org.gradle.messaging.remote.internal.BufferingProtocol;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.DelegatingConnection;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.MethodInvocationMarshallingDispatch;
import org.gradle.messaging.remote.internal.MethodInvocationUnmarshallingDispatch;
import org.gradle.messaging.remote.internal.OutgoingMultiplex;
import org.gradle.messaging.remote.internal.ProtocolStack;
import org.gradle.messaging.remote.internal.ReceiveProtocol;
import org.gradle.messaging.remote.internal.RemoteDisconnectProtocol;
import org.gradle.messaging.remote.internal.Router;
import org.gradle.messaging.remote.internal.SendProtocol;
import org.gradle.messaging.remote.internal.WorkerProtocol;
import org.gradle.messaging.remote.internal.protocol.EndOfStreamEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHub
implements AsyncStoppable {
    private final Lock lock = new ReentrantLock();
    private final CompositeStoppable executors = CompositeStoppable.stoppable((Object[])new Object[0]);
    private final CompositeStoppable connections = CompositeStoppable.stoppable((Object[])new Object[0]);
    private final Collection<ProtocolStack<Message>> handlers = new ArrayList<ProtocolStack<Message>>();
    private final Collection<ProtocolStack<Message>> workers = new ArrayList<ProtocolStack<Message>>();
    private final Map<String, ProtocolStack<Message>> outgoingUnicasts = new HashMap<String, ProtocolStack<Message>>();
    private final Map<String, ProtocolStack<Message>> outgoingBroadcasts = new HashMap<String, ProtocolStack<Message>>();
    private final DispatchFailureHandler<Object> failureHandler;
    private final Router router;
    private final String displayName;
    private final String nodeName;
    private final ExecutorFactory executorFactory;
    private final IdGenerator<UUID> idGenerator;
    private final ClassLoader messagingClassLoader;
    private final StoppableExecutor incomingExecutor;

    public MessageHub(String displayName, String nodeName, ExecutorFactory executorFactory, IdGenerator<UUID> idGenerator, ClassLoader messagingClassLoader) {
        this.displayName = displayName;
        this.nodeName = nodeName;
        this.executorFactory = executorFactory;
        this.idGenerator = idGenerator;
        this.messagingClassLoader = messagingClassLoader;
        this.failureHandler = new DiscardingFailureHandler<Object>(LoggerFactory.getLogger(MessageHub.class));
        StoppableExecutor executor = executorFactory.create(displayName + " message router");
        this.executors.add(new Object[]{executor});
        this.router = new Router((Executor)executor, this.failureHandler);
        this.incomingExecutor = executorFactory.create(displayName + " worker");
        this.executors.add(new Object[]{this.incomingExecutor});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection<Message> connection) {
        this.lock.lock();
        try {
            EndOfStreamConnection wrapper = new EndOfStreamConnection(connection);
            AsyncConnectionAdapter<Object> asyncConnection = new AsyncConnectionAdapter<Object>(wrapper, this.failureHandler, this.executorFactory, new RemoteDisconnectProtocol());
            this.connections.add(new Object[]{asyncConnection});
            AsyncConnection<Message> incomingEndpoint = this.router.createRemoteConnection();
            incomingEndpoint.dispatchTo(new MethodInvocationMarshallingDispatch(asyncConnection));
            asyncConnection.dispatchTo(new MethodInvocationUnmarshallingDispatch(incomingEndpoint, this.messagingClassLoader));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dispatch<Object> addMulticastOutgoing(String channel) {
        this.lock.lock();
        try {
            ProtocolStack<Object> outgoing = this.outgoingBroadcasts.get(channel);
            if (outgoing == null) {
                BroadcastSendProtocol broadcastProtocol = new BroadcastSendProtocol();
                SendProtocol sendProtocol = new SendProtocol((UUID)this.idGenerator.generateId(), this.nodeName, channel);
                StoppableExecutor executor = this.executorFactory.create(this.displayName + " outgoing broadcast " + channel);
                this.executors.add(new Object[]{executor});
                outgoing = new ProtocolStack<Object>((Executor)executor, this.failureHandler, this.failureHandler, broadcastProtocol, sendProtocol);
                this.outgoingBroadcasts.put(channel, outgoing);
                AsyncConnection<Message> outgoingEndpoint = this.router.createLocalConnection();
                outgoing.getBottom().dispatchTo(outgoingEndpoint);
                outgoingEndpoint.dispatchTo(outgoing.getBottom());
            }
            OutgoingMultiplex outgoingMultiplex = new OutgoingMultiplex(channel, outgoing.getTop());
            return outgoingMultiplex;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncoming(String channel, Dispatch<Object> dispatch) {
        this.lock.lock();
        try {
            UUID id = (UUID)this.idGenerator.generateId();
            WorkerProtocol workerProtocol = new WorkerProtocol(dispatch);
            ReceiveProtocol receiveProtocol = new ReceiveProtocol(id, this.nodeName, channel);
            ProtocolStack<Object> workerStack = new ProtocolStack<Object>((Executor)this.incomingExecutor, this.failureHandler, this.failureHandler, workerProtocol);
            this.workers.add(workerStack);
            ProtocolStack<Object> stack = new ProtocolStack<Object>((Executor)this.incomingExecutor, this.failureHandler, this.failureHandler, new BufferingProtocol(200), receiveProtocol);
            this.handlers.add(stack);
            workerStack.getBottom().dispatchTo(stack.getTop());
            stack.getTop().dispatchTo(workerStack.getBottom());
            AsyncConnection<Message> incomingEndpoint = this.router.createLocalConnection();
            stack.getBottom().dispatchTo(incomingEndpoint);
            incomingEndpoint.dispatchTo(stack.getBottom());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStop() {
        this.lock.lock();
        try {
            for (ProtocolStack<Message> stack : this.outgoingUnicasts.values()) {
                stack.requestStop();
            }
            for (ProtocolStack<Message> stack : this.outgoingBroadcasts.values()) {
                stack.requestStop();
            }
            for (ProtocolStack<Message> worker : this.workers) {
                worker.requestStop();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.requestStop();
        CompositeStoppable stoppable = new CompositeStoppable();
        this.lock.lock();
        try {
            stoppable.add(this.outgoingUnicasts.values());
            stoppable.add(this.outgoingBroadcasts.values());
            stoppable.add(this.workers);
            stoppable.add(this.handlers);
            stoppable.add(new Object[]{this.connections});
            stoppable.add(new Object[]{this.router});
            stoppable.add(new Object[]{this.executors});
        }
        finally {
            this.outgoingUnicasts.clear();
            this.outgoingBroadcasts.clear();
            this.workers.clear();
            this.handlers.clear();
            this.lock.unlock();
        }
        stoppable.stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EndOfStreamConnection
    extends DelegatingConnection<Message> {
        private static final Logger LOGGER = LoggerFactory.getLogger(EndOfStreamConnection.class);
        boolean incomingFinished;

        private EndOfStreamConnection(Connection<Message> connection) {
            super(connection);
        }

        @Override
        public Message receive() {
            Message result;
            if (this.incomingFinished) {
                return null;
            }
            try {
                result = (Message)super.receive();
            }
            catch (Throwable e) {
                LOGGER.error("Could not receive message from connection. Discarding connection.", e);
                result = null;
            }
            if (result instanceof EndOfStreamEvent) {
                this.incomingFinished = true;
            } else if (result == null) {
                this.incomingFinished = true;
                result = new EndOfStreamEvent();
            }
            return result;
        }
    }
}

