/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.tasks.apigen.abi;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.internal.Factory;
import org.gradle.language.base.internal.tasks.apigen.abi.ApiValidator;
import org.gradle.language.base.internal.tasks.apigen.abi.FieldSig;
import org.gradle.language.base.internal.tasks.apigen.abi.InvalidPublicAPIException;
import org.gradle.language.base.internal.tasks.apigen.abi.MemberOfApiChecker;
import org.gradle.language.base.internal.tasks.apigen.abi.MethodSig;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultApiValidator
implements ApiValidator {
    private final MemberOfApiChecker memberOfApiChecker;

    public DefaultApiValidator(MemberOfApiChecker memberOfApiChecker) {
        this.memberOfApiChecker = memberOfApiChecker;
    }

    @Override
    public <T> T validateMethod(MethodSig methodSig, Factory<T> onValidate) {
        Sets.SetView invalidReferencedTypes = this.invalidReferencedTypes(methodSig.getSignature() == null ? methodSig.getDesc() : methodSig.getSignature());
        for (String exception : methodSig.getExceptions()) {
            invalidReferencedTypes = Sets.union(invalidReferencedTypes, this.invalidReferencedTypes(exception));
        }
        if (invalidReferencedTypes.isEmpty()) {
            return (T)onValidate.create();
        }
        if (invalidReferencedTypes.size() == 1) {
            throw new InvalidPublicAPIException(String.format("In %s, type %s is exposed in the public API but its package is not one of the allowed packages.", methodSig, invalidReferencedTypes.iterator().next()));
        }
        StringBuilder sb = new StringBuilder("The following types are referenced in ");
        sb.append(methodSig);
        sb.append(" but their package is not one of the allowed packages:\n");
        for (String invalidReferencedType : invalidReferencedTypes) {
            sb.append("   - ").append(invalidReferencedType).append("\n");
        }
        throw new InvalidPublicAPIException(sb.toString());
    }

    @Override
    public <T> T validateField(FieldSig fieldSig, Factory<T> onValidate) {
        Set<String> invalidReferencedTypes = this.invalidReferencedTypes(fieldSig.getSignature());
        if (invalidReferencedTypes.isEmpty()) {
            return (T)onValidate.create();
        }
        if (invalidReferencedTypes.size() == 1) {
            throw new InvalidPublicAPIException(String.format("Field '%s' references disallowed API type '%s'", fieldSig, invalidReferencedTypes.iterator().next()));
        }
        StringBuilder sb = new StringBuilder("The following types are referenced in ");
        sb.append(fieldSig);
        sb.append(" but their package is not one of the allowed packages:\n");
        for (String invalidReferencedType : invalidReferencedTypes) {
            sb.append("   - ").append(invalidReferencedType).append("\n");
        }
        throw new InvalidPublicAPIException(sb.toString());
    }

    @Override
    public <T> T validateAnnotation(String owner, String annotationDesc, Factory<T> onValidate) {
        String annotation = Type.getType((String)annotationDesc).getClassName();
        if (this.memberOfApiChecker.belongsToApi(annotation)) {
            return (T)onValidate.create();
        }
        throw new InvalidPublicAPIException(String.format("'%s' is annotated with '%s' effectively exposing it in the public API but its package is not one of the allowed packages.", owner, annotation));
    }

    public static String toClassName(String cn) {
        return cn.replace('/', '.');
    }

    @Override
    public void validateSuperTypes(String name, String signature, String superName, String[] interfaces) {
        if (!this.memberOfApiChecker.belongsToApi(DefaultApiValidator.toClassName(superName))) {
            throw new InvalidPublicAPIException(String.format("'%s' extends '%s' and its package is not one of the allowed packages.", DefaultApiValidator.toClassName(name), DefaultApiValidator.toClassName(superName)));
        }
        Set<String> invalidReferencedTypes = this.invalidReferencedTypes(signature);
        if (!invalidReferencedTypes.isEmpty()) {
            if (invalidReferencedTypes.size() == 1) {
                throw new InvalidPublicAPIException(String.format("'%s' references disallowed API type '%s' in superclass or interfaces.", DefaultApiValidator.toClassName(name), invalidReferencedTypes.iterator().next()));
            }
            StringBuilder sb = new StringBuilder("The following types are referenced in ");
            sb.append(DefaultApiValidator.toClassName(name));
            sb.append(" superclass but their package don't belong to the allowed packages:\n");
            for (String invalidReferencedType : invalidReferencedTypes) {
                sb.append("   - ").append(invalidReferencedType).append("\n");
            }
            throw new InvalidPublicAPIException(sb.toString());
        }
        if (interfaces != null) {
            for (String intf : interfaces) {
                if (this.memberOfApiChecker.belongsToApi(DefaultApiValidator.toClassName(intf))) continue;
                throw new InvalidPublicAPIException(String.format("'%s' declares interface '%s' and its package is not one of the allowed packages.", DefaultApiValidator.toClassName(name), DefaultApiValidator.toClassName(intf)));
            }
        }
    }

    protected Set<String> invalidReferencedTypes(String signature) {
        if (signature == null) {
            return Collections.emptySet();
        }
        SignatureReader sr = new SignatureReader(signature);
        final LinkedHashSet result = Sets.newLinkedHashSet();
        sr.accept(new SignatureVisitor(327680){

            public void visitClassType(String name) {
                super.visitClassType(name);
                String className = DefaultApiValidator.toClassName(name);
                if (!DefaultApiValidator.this.memberOfApiChecker.belongsToApi(className)) {
                    result.add(className);
                }
            }
        });
        return result;
    }
}

