/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.DependencySpecBuilder;
import org.gradle.platform.base.DependencySpecContainer;
import org.gradle.platform.base.internal.DefaultDependencySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependencySpecContainer
implements DependencySpecContainer {
    private final List<DefaultDependencySpec.Builder> builders = new LinkedList<DefaultDependencySpec.Builder>();

    @Override
    public DependencySpecBuilder project(final String path) {
        return this.doCreate((Action<? super DefaultDependencySpec.Builder>)new Action<DefaultDependencySpec.Builder>(){

            public void execute(DefaultDependencySpec.Builder builder) {
                builder.project(path);
            }
        });
    }

    @Override
    public DependencySpecBuilder library(final String name) {
        return this.doCreate((Action<? super DefaultDependencySpec.Builder>)new Action<DefaultDependencySpec.Builder>(){

            public void execute(DefaultDependencySpec.Builder builder) {
                builder.library(name);
            }
        });
    }

    @Override
    public Collection<DependencySpec> getDependencies() {
        if (this.builders.isEmpty()) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf((Collection)Lists.transform(this.builders, (Function)new Function<DefaultDependencySpec.Builder, DependencySpec>(){

            public DependencySpec apply(DefaultDependencySpec.Builder builder) {
                return builder.build();
            }
        }));
    }

    private DefaultDependencySpec.Builder doCreate(Action<? super DefaultDependencySpec.Builder> action) {
        DefaultDependencySpec.Builder builder = new DefaultDependencySpec.Builder();
        action.execute((Object)builder);
        this.builders.add(builder);
        return builder;
    }

    @Override
    public boolean isEmpty() {
        return this.builders.isEmpty();
    }
}

