/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.parameters;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gradle.api.GradleException;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.jarjar.com.google.common.collect.Lists;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.CancellationTokenInternal;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.parameters.ProgressListenerAdapter;
import org.gradle.tooling.internal.gradle.TaskListingLaunchable;
import org.gradle.tooling.internal.protocol.BuildOperationParametersVersion1;
import org.gradle.tooling.internal.protocol.BuildParameters;
import org.gradle.tooling.internal.protocol.BuildParametersVersion1;
import org.gradle.tooling.internal.protocol.InternalLaunchable;
import org.gradle.tooling.internal.protocol.ProgressListenerVersion1;
import org.gradle.tooling.model.Launchable;
import org.gradle.tooling.model.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerOperationParameters
implements BuildOperationParametersVersion1,
BuildParametersVersion1,
BuildParameters {
    private final ProgressListenerAdapter progressListener;
    private final CancellationToken cancellationToken;
    private final ConnectionParameters parameters;
    private final long startTime = System.currentTimeMillis();
    private final OutputStream stdout;
    private final OutputStream stderr;
    private final Boolean colorOutput;
    private final InputStream stdin;
    private final File javaHome;
    private final List<String> jvmArguments;
    private final List<String> arguments;
    private final List<String> tasks;
    private final List<InternalLaunchable> launchables;

    public static Builder builder() {
        return new Builder();
    }

    private ConsumerOperationParameters(ConnectionParameters parameters, OutputStream stdout, OutputStream stderr, Boolean colorOutput, InputStream stdin, File javaHome, List<String> jvmArguments, List<String> arguments, List<String> tasks, List<InternalLaunchable> launchables, ProgressListenerAdapter listener, CancellationToken cancellationToken) {
        this.parameters = parameters;
        this.stdout = stdout;
        this.stderr = stderr;
        this.colorOutput = colorOutput;
        this.stdin = stdin;
        this.javaHome = javaHome;
        this.jvmArguments = jvmArguments;
        this.arguments = arguments;
        this.tasks = tasks;
        this.launchables = launchables;
        this.progressListener = listener;
        this.cancellationToken = cancellationToken;
    }

    private static List<String> rationalizeInput(String[] arguments) {
        return arguments != null && arguments.length > 0 ? Arrays.asList(arguments) : null;
    }

    private static void validateJavaHome(File javaHome) {
        if (javaHome == null) {
            return;
        }
        if (!javaHome.isDirectory()) {
            throw new IllegalArgumentException("Supplied javaHome is not a valid folder. You supplied: " + javaHome);
        }
    }

    public BuildCancellationToken getCancellationToken() {
        return ((CancellationTokenInternal)((Object)this.cancellationToken)).getToken();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean getVerboseLogging() {
        return this.parameters.getVerboseLogging();
    }

    @Override
    public File getGradleUserHomeDir() {
        return this.parameters.getGradleUserHomeDir();
    }

    @Override
    public File getProjectDir() {
        return this.parameters.getProjectDir();
    }

    @Override
    public Boolean isSearchUpwards() {
        return this.parameters.isSearchUpwards();
    }

    @Override
    public Boolean isEmbedded() {
        return this.parameters.isEmbedded();
    }

    @Override
    public TimeUnit getDaemonMaxIdleTimeUnits() {
        return this.parameters.getDaemonMaxIdleTimeUnits();
    }

    @Override
    public Integer getDaemonMaxIdleTimeValue() {
        return this.parameters.getDaemonMaxIdleTimeValue();
    }

    public File getDaemonBaseDir() {
        return this.parameters.getDaemonBaseDir();
    }

    @Override
    public OutputStream getStandardOutput() {
        return this.stdout;
    }

    @Override
    public OutputStream getStandardError() {
        return this.stderr;
    }

    public Boolean isColorOutput() {
        return this.colorOutput;
    }

    @Override
    public ProgressListenerVersion1 getProgressListener() {
        return this.progressListener;
    }

    @Override
    public InputStream getStandardInput() {
        return this.stdin;
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public List<String> getJvmArguments() {
        return this.jvmArguments;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    @Override
    public List<String> getTasks() {
        return this.tasks;
    }

    public List<InternalLaunchable> getLaunchables() {
        return this.launchables;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final ProgressListenerAdapter progressListener = new ProgressListenerAdapter();
        private CancellationToken cancellationToken;
        private ConnectionParameters parameters;
        private OutputStream stdout;
        private OutputStream stderr;
        private Boolean colorOutput;
        private InputStream stdin;
        private File javaHome;
        private List<String> jvmArguments;
        private List<String> arguments;
        private List<String> tasks;
        private List<InternalLaunchable> launchables;

        private Builder() {
        }

        public void setCancellationToken(CancellationToken cancellationToken) {
            this.cancellationToken = cancellationToken;
        }

        public Builder setParameters(ConnectionParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder setStdout(OutputStream stdout) {
            this.stdout = stdout;
            return this;
        }

        public Builder setStderr(OutputStream stderr) {
            this.stderr = stderr;
            return this;
        }

        public Builder setColorOutput(Boolean colorOutput) {
            this.colorOutput = colorOutput;
            return this;
        }

        public Builder setStdin(InputStream stdin) {
            this.stdin = stdin;
            return this;
        }

        public Builder setJavaHome(File javaHome) {
            ConsumerOperationParameters.validateJavaHome(javaHome);
            this.javaHome = javaHome;
            return this;
        }

        public Builder setJvmArguments(String ... jvmArguments) {
            this.jvmArguments = ConsumerOperationParameters.rationalizeInput(jvmArguments);
            return this;
        }

        public Builder setArguments(String[] arguments) {
            this.arguments = ConsumerOperationParameters.rationalizeInput(arguments);
            return this;
        }

        public Builder setTasks(List<String> tasks) {
            this.tasks = tasks;
            return this;
        }

        public Builder setLaunchables(Iterable<? extends Launchable> launchables) {
            LinkedHashSet<String> taskPaths = new LinkedHashSet<String>();
            ArrayList<InternalLaunchable> launchablesParams = Lists.newArrayList();
            for (Launchable launchable : launchables) {
                Object original = new ProtocolToModelAdapter().unpack(launchable);
                if (original instanceof InternalLaunchable) {
                    launchablesParams.add((InternalLaunchable)original);
                    continue;
                }
                if (original instanceof TaskListingLaunchable) {
                    taskPaths.addAll(((TaskListingLaunchable)original).getTaskNames());
                    continue;
                }
                if (launchable instanceof Task) {
                    taskPaths.add(((Task)launchable).getPath());
                    continue;
                }
                throw new GradleException("Only Task or TaskSelector instances are supported: " + (launchable != null ? launchable.getClass() : "null"));
            }
            this.launchables = launchablesParams;
            this.tasks = Lists.newArrayList(taskPaths);
            return this;
        }

        public void addProgressListener(ProgressListener listener) {
            this.progressListener.add(listener);
        }

        public ConsumerOperationParameters build() {
            return new ConsumerOperationParameters(this.parameters, this.stdout, this.stderr, this.colorOutput, this.stdin, this.javaHome, this.jvmArguments, this.arguments, this.tasks, this.launchables, this.progressListener, this.cancellationToken);
        }
    }
}

