/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import groovy.lang.Closure;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.extension.AbstractAnnotationDrivenExtension;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.extension.builtin.PreconditionContext;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.ISkippable;
import org.spockframework.runtime.model.SpecInfo;
import spock.lang.IgnoreIf;

public class IgnoreIfExtension
extends AbstractAnnotationDrivenExtension<IgnoreIf> {
    @Override
    public void visitSpecAnnotation(IgnoreIf annotation, SpecInfo spec) {
        this.doVisit(annotation, spec);
    }

    @Override
    public void visitFeatureAnnotation(IgnoreIf annotation, FeatureInfo feature) {
        this.doVisit(annotation, feature);
    }

    private void doVisit(IgnoreIf annotation, ISkippable skippable) {
        Closure condition = this.createCondition(annotation.value());
        Object result = this.evaluateCondition(condition);
        skippable.setSkipped(GroovyRuntimeUtil.isTruthy(result));
    }

    private Closure createCondition(Class<? extends Closure> clazz) {
        try {
            return clazz.getConstructor(Object.class, Object.class).newInstance(null, null);
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to instantiate @IgnoreIf condition", e);
        }
    }

    private Object evaluateCondition(Closure condition) {
        condition.setDelegate((Object)new PreconditionContext());
        condition.setResolveStrategy(3);
        try {
            return condition.call();
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to evaluate @IgnoreIf condition", e);
        }
    }
}

