/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.collection.mutable;

import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.Function3;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.tuple.Twin;
import com.gs.collections.impl.AbstractRichIterable;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.block.procedure.CollectionAddProcedure;
import com.gs.collections.impl.block.procedure.MutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import com.gs.collections.impl.collection.mutable.CollectionAdapter;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.utility.internal.IterableIterate;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableCollection<T>
extends AbstractRichIterable<T>
implements MutableCollection<T> {
    public <P> Twin<MutableList<T>> selectAndRejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return IterableIterate.selectAndRejectWith(this, predicate, parameter);
    }

    public void removeIf(Predicate<? super T> predicate) {
        IterableIterate.removeIf(this, predicate);
    }

    public <P> void removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        IterableIterate.removeIfWith(this, predicate, parameter);
    }

    public <IV, P> IV injectIntoWith(IV injectValue, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        return IterableIterate.injectIntoWith(injectValue, this, function, parameter);
    }

    public boolean addAllIterable(Iterable<? extends T> iterable) {
        int oldSize = this.size();
        IterableIterate.forEach(iterable, CollectionAddProcedure.on(this));
        return oldSize != this.size();
    }

    public boolean removeAllIterable(Iterable<?> iterable) {
        return this.removeAll((Collection<?>)CollectionAdapter.wrapSet(iterable));
    }

    public boolean retainAllIterable(Iterable<?> iterable) {
        return this.retainAll((Collection<?>)CollectionAdapter.wrapSet(iterable));
    }

    public RichIterable<RichIterable<T>> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        Iterator iterator = this.iterator();
        MutableList result = Lists.mutable.of();
        while (iterator.hasNext()) {
            MutableCollection batch = this.newEmpty();
            for (int i = 0; i < size && iterator.hasNext(); ++i) {
                batch.add(iterator.next());
            }
            result.add((Object)batch);
        }
        return result;
    }

    public <K, V> MutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public <K, V> MutableMap<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new NonMutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }

    public boolean add(T element) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    public boolean remove(Object o) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!Comparators.nullSafeEquals(o, iterator.next())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean addAll(Collection<? extends T> source) {
        return this.addAllIterable(source);
    }

    public boolean removeAll(Collection<?> source) {
        int oldSize = this.size();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!source.contains(iterator.next())) continue;
            iterator.remove();
        }
        return this.size() != oldSize;
    }

    public boolean retainAll(Collection<?> source) {
        int oldSize = this.size();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (source.contains(iterator.next())) continue;
            iterator.remove();
        }
        return this.size() != oldSize;
    }
}

