/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.IntList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.lazy.primitive.AbstractLazyIntIterable;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import java.util.NoSuchElementException;

public class ReverseIntIterable
extends AbstractLazyIntIterable {
    private final IntList adapted;

    public ReverseIntIterable(IntList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseIntIterable adapt(IntList intList) {
        return new ReverseIntIterable(intList);
    }

    public IntIterator intIterator() {
        return new ReverseIntIterator();
    }

    public void forEach(IntProcedure procedure) {
        IntIterator iterator = this.intIterator();
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public long sum() {
        return this.adapted.sum();
    }

    public int max() {
        return this.adapted.max();
    }

    public int min() {
        return this.adapted.min();
    }

    public int minIfEmpty(int defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    public int maxIfEmpty(int defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    public double average() {
        return this.adapted.average();
    }

    public double median() {
        return this.adapted.median();
    }

    public int[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newList((IntIterable)this).sortThis();
    }

    public int[] toArray() {
        int[] results = new int[this.adapted.size()];
        int index = 0;
        IntIterator iterator = this.intIterator();
        while (iterator.hasNext()) {
            results[index] = iterator.next();
            ++index;
        }
        return results;
    }

    public boolean contains(int value) {
        return this.adapted.contains(value);
    }

    public boolean containsAll(int ... source) {
        return this.adapted.containsAll(source);
    }

    public boolean containsAll(IntIterable source) {
        return this.adapted.containsAll(source);
    }

    public int size() {
        return this.adapted.size();
    }

    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    public MutableIntList toList() {
        return IntArrayList.newList((IntIterable)this);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSet((IntIterable)this);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBag((IntIterable)this);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    private class ReverseIntIterator
    implements IntIterator {
        private int currentIndex;

        private ReverseIntIterator() {
            this.currentIndex = ReverseIntIterable.this.adapted.size() - 1;
        }

        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int next = ReverseIntIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

